/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class FmeaEntityDefinition
extends FmeaObject
implements FmeaSerializable {
    private static String prefix = "EntityDefinition";
    private static int count = 0;
    private String _key;
    private Map<String, FmeaAttributeDefinition> _attributeDefs = new TreeMap<String, FmeaAttributeDefinition>();
    private FmeaEntityDefinition _defaultRelatedEntityDef = null;
    private Sequence _sequence = new SimpleSequence();

    public FmeaEntityDefinition(String key) {
        this._key = key;
        this.initKey();
    }

    protected void initKey() {
        if (this._key == null) {
            this._key = prefix + count++;
        } else if (this._key.length() > prefix.length() && this._key.startsWith(prefix)) {
            boolean number = true;
            int n = 0;
            try {
                n = Integer.parseInt(this._key.substring(prefix.length()));
            }
            catch (NumberFormatException e) {
                number = false;
            }
            if (number) {
                count = Math.max(count, n) + 1;
            }
        }
        this._internalAttributes.put("KEY", this._key);
        this.addAttributeDefinition(new FmeaAttributeDefinition(this._key, this._key));
        this.setName(this._key);
    }

    public String getKey() {
        return this._key;
    }

    public void setName(String name) {
        this._internalAttributes.put("NAME", name);
        this.getAttributeDefinition(this.getKey()).setName(name);
        this._changeNotifier.changed(this);
    }

    public void addAttributeDefinition(FmeaAttributeDefinition attribute) {
        this._attributeDefs.put(attribute.getKey(), attribute);
        if (attribute.getKey().equals(this.getKey())) {
            attribute.setType(FmeaAttributeDefinition.Reference);
        }
        this._changeNotifier.changed(this);
    }

    public void removeAttributeDefinition(FmeaAttributeDefinition attribute) {
        this._attributeDefs.remove(attribute.getKey());
        this._changeNotifier.changed(this);
    }

    public void changeAttributeDefinitionName(String oldName, String newName) {
        FmeaAttributeDefinition attributeDef = this.getAttributeDefinitionWithName(oldName);
        attributeDef.setName(newName);
        this._changeNotifier.changed(this);
    }

    public int getAttributeCount() {
        return this._attributeDefs.size();
    }

    public Object[] getAttributeDefinitions() {
        Comparator<FmeaAttributeDefinition> c = new Comparator<FmeaAttributeDefinition>(){

            @Override
            public int compare(FmeaAttributeDefinition o1, FmeaAttributeDefinition o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        ArrayList<FmeaAttributeDefinition> lst = new ArrayList<FmeaAttributeDefinition>();
        lst.addAll(this._attributeDefs.values());
        Collections.sort(lst, c);
        return lst.toArray();
    }

    public Iterator getAttributeDefinitionIterator() {
        return this._attributeDefs.values().iterator();
    }

    public FmeaAttributeDefinition getAttributeDefinition(String key) {
        return this._attributeDefs.get(key);
    }

    public FmeaAttributeDefinition getAttributeDefinitionWithName(String name) {
        for (FmeaAttributeDefinition attDef : this._attributeDefs.values()) {
            if (!attDef.getName().equals(name)) continue;
            return attDef;
        }
        return null;
    }

    public void setDefaultRelatedEntityDefinition(FmeaEntityDefinition entityDef) {
        this._defaultRelatedEntityDef = entityDef;
        this._changeNotifier.changed(this);
    }

    public FmeaEntityDefinition getDefaultRelatedEntityDefinition() {
        return this._defaultRelatedEntityDef;
    }

    public String getNewEntityName() {
        return this.getNewEntityNameSuffix() + this.getNextID();
    }

    public String getNewEntityNameSuffix() {
        return "new " + this.getName() + " ";
    }

    public Integer getIDFromName(String name) {
        String pattern = this.getNewEntityNameSuffix();
        Integer ID = null;
        if (name.startsWith(pattern)) {
            try {
                ID = Integer.parseInt(name.substring(pattern.length()));
            }
            catch (NumberFormatException e) {
                ID = null;
            }
        }
        return ID;
    }

    public boolean reserveIDFromNameIfNeeded(String name) {
        Integer ID = this.getIDFromName(name);
        if (ID == null) {
            return false;
        }
        this.reserveID(ID);
        return true;
    }

    public boolean releaseIDFromNameIfNeeded(String name) {
        Integer ID = this.getIDFromName(name);
        if (ID == null) {
            return false;
        }
        this.releaseID(ID);
        return true;
    }

    public void reserveID(int id) {
        this._sequence.addValue(id);
    }

    public void releaseID(int id) {
        this._sequence.removeValue(id);
    }

    public int getNextID() {
        return this._sequence.getNextValue();
    }

    public boolean equals(Object o) {
        return o == null ? false : this.getName().equals(((FmeaEntityDefinition)o).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.incTabCount();
        w.write("<ENTITY_DEFINITION KEY=\"");
        w.write(this.getKey());
        w.write("\" NAME=\"");
        w.write(this.getName());
        w.writeln("\">");
        for (FmeaAttributeDefinition attributeDef : this._attributeDefs.values()) {
            attributeDef.writeXML(w);
        }
        w.writeln("</ENTITY_DEFINITION>");
        w.decTabCount();
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<ENTITY_DEFINITION");
        out.append(" KEY=\"").append(this.getKey()).append("\"");
        out.append(" NAME=\"").append(this.getName()).append("\"");
        if (this._attributeDefs.isEmpty()) {
            out.append("/>\n");
        } else {
            out.append(">\n");
            String indent1 = indent + "  ";
            for (FmeaAttributeDefinition attributeDef : this._attributeDefs.values()) {
                attributeDef.toXML(out, indent1);
            }
            out.append(indent).append("</ENTITY_DEFINITION>\n");
        }
    }

    public FmeaEntityDefinition getCopy() {
        return (FmeaEntityDefinition)this.clone();
    }

    public Object clone() {
        FmeaEntityDefinition clone = new FmeaEntityDefinition(this._key);
        clone._internalAttributes.putAll(this._internalAttributes);
        clone._attributeDefs.putAll(this._attributeDefs);
        clone._defaultRelatedEntityDef = this._defaultRelatedEntityDef;
        return clone;
    }

    public void copy(FmeaEntityDefinition def) {
        this._internalAttributes.clear();
        this._internalAttributes.putAll(def._internalAttributes);
        this._attributeDefs.clear();
        this._attributeDefs.putAll(def._attributeDefs);
        this._defaultRelatedEntityDef = def._defaultRelatedEntityDef;
        this._changeNotifier.changed(this);
    }

    class SimpleSequence
    implements Sequence {
        private int nextval = 0;

        SimpleSequence() {
        }

        @Override
        public void addValue(int v) {
            this.nextval = Math.max(this.nextval, v + 1);
        }

        @Override
        public void removeValue(int v) {
        }

        @Override
        public int getNextValue() {
            int val = this.nextval++;
            return val;
        }
    }

    static interface Sequence {
        public void addValue(int var1);

        public void removeValue(int var1);

        public int getNextValue();
    }

    class ExtSequence
    implements Sequence {
        private List a = new ArrayList();
        private Map values = new TreeMap();
        private int curVal = 0;

        @Override
        public void addValue(int v) {
            int index = 0;
            if (this.a.size() == 0) {
                index = 0;
                this.a.add(index, v);
                int[] t = new int[]{v, v};
                this.values.put(v, t);
            } else {
                int[] nextRange;
                int first = (Integer)this.a.get(0);
                int last = (Integer)this.a.get(this.a.size() - 1);
                int[] range = null;
                if (v < first) {
                    this.a.add(0, v);
                    newRange = new int[]{v, v};
                    this.values.put(v, newRange);
                    range = newRange;
                } else {
                    index = v > last ? this.a.size() - 1 : this.index(v);
                    range = (int[])this.values.get(this.a.get(index));
                    if (v == range[1] + 1) {
                        range[1] = range[1] + 1;
                    } else if (v > range[1]) {
                        this.a.add(index + 1, v);
                        newRange = new int[]{v, v};
                        this.values.put(v, newRange);
                    } else if (v <= range[1]) {
                        throw new RuntimeException("Try to insert value " + v + " which is already inserted");
                    }
                }
                if (this.values.size() > index + 1 && range[1] + 1 == (nextRange = (int[])this.values.get(this.a.get(index + 1)))[0]) {
                    range[1] = nextRange[1];
                    this.values.remove(this.a.get(index + 1));
                    this.a.remove(index + 1);
                }
            }
            int[] firstRange = (int[])this.values.get(this.a.get(0));
            if (firstRange[0] <= this.curVal && this.curVal <= firstRange[1]) {
                this.curVal = firstRange[1] + 1;
            }
        }

        @Override
        public void removeValue(int v) {
            if (this.a.size() == 0) {
                return;
            }
            int first = (Integer)this.a.get(0);
            if (v < first) {
                throw new RuntimeException("Try to remove value " + v + " which do not belong to an existing range");
            }
            int index = this.index(v);
            int[] range = (int[])this.values.get(this.a.get(index));
            int binf = range[0];
            int bsup = range[1];
            if (v <= bsup) {
                if (binf == bsup) {
                    this.values.remove(this.a.get(index));
                    this.a.remove(index);
                } else if (binf == bsup - 1) {
                    if (v == binf) {
                        range[0] = range[0] + 1;
                        this.a.set(index, v + 1);
                    } else {
                        range[1] = range[1] - 1;
                    }
                } else {
                    range[1] = v - 1;
                    int[] newRange = new int[]{v + 1, bsup};
                    this.values.put(v + 1, newRange);
                    this.a.add(index + 1, v + 1);
                }
            } else {
                throw new RuntimeException("Try to remove value " + v + " which do not belong to an existing range");
            }
            if (this.curVal >= v) {
                this.curVal = v;
            }
        }

        @Override
        public int getNextValue() {
            int nextVal = this.curVal;
            this.addValue(this.curVal);
            return nextVal;
        }

        private int index(int v) {
            return this.index(v, 0, this.a.size());
        }

        private int index(int v, int from, int to) {
            if (to <= from) {
                return from - 1;
            }
            int m = (from + to) / 2;
            int pivot = (Integer)this.a.get(m);
            if (v < pivot) {
                return this.index(v, from, m);
            }
            return this.index(v, m + 1, to);
        }
    }
}

