/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.ChangeNotifier;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class FmeaGraphicPropertyCollection
extends HashMap
implements FmeaSerializable {
    public static String width = "width";
    public static String background = "background";
    public static String foreground = "foreground";
    public static String font = "font";
    public static String horizontalAlignment = "horizontalAlignment";
    public static String dictionnary = "dictionnary";
    public static String link = "link";
    public static String formula = "formula";
    public static String HA_CENTER = "CENTER";
    public static String HA_LEFT = "LEFT";
    public static String HA_RIGHT = "RIGHT";
    public static String HA_LEADING = "LEADING";
    public static String HA_TRAILING = "TRAILING";
    private static final String PROP_FMEA_TABLE_COLUMN_DEFAULT = "cecilia.fmea.TableColumnHorizontalAlignment";
    protected ChangeNotifier changeNotifier = new ChangeNotifier(this);

    public FmeaGraphicPropertyCollection() {
        String align = System.getProperty(PROP_FMEA_TABLE_COLUMN_DEFAULT);
        if (align != null) {
            this.putProperty(horizontalAlignment, align);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putProperty(String key, String value) {
        try {
            if (key.equals(width)) {
                Object object = this.putInteger((Object)key, value);
                return object;
            }
            if (key.equals(background)) {
                Object object = this.putColor(key, value);
                return object;
            }
            if (key.equals(foreground)) {
                Object object = this.putColor(key, value);
                return object;
            }
            if (key.equals(font)) {
                Object object = this.putFont(key, value);
                return object;
            }
            if (key.equals(horizontalAlignment)) {
                Object object = this.putHorizAlign(key, value);
                return object;
            }
            if (key.equals(link)) {
                Object object = this.putBoolean((Object)key, value);
                return object;
            }
            if (key.equals(formula)) {
                Object object = this.putString((Object)key, (Object)value);
                return object;
            }
            String string = super.put(key, value);
            return string;
        }
        finally {
            this.changeNotifier.changed(this);
        }
    }

    public void putString(String property, String value) {
        this.put(property, value);
        this.changeNotifier.changed(this);
    }

    public void putInteger(String property, int value) {
        this.put(property, value);
        this.changeNotifier.changed(this);
    }

    public void putDouble(String property, double value) {
        this.put(property, value);
        this.changeNotifier.changed(this);
    }

    public void putBoolean(String property, boolean value) {
        this.put(property, value);
        this.changeNotifier.changed(this);
    }

    public Integer getInteger(String property) {
        return (Integer)this.get(property);
    }

    public Double getDouble(String property) {
        return (Double)this.get(property);
    }

    public boolean getBoolean(String property) {
        Boolean p = (Boolean)this.get(property);
        return p == null ? false : p;
    }

    public String getString(String property) {
        return (String)this.get(property);
    }

    public Color getColor(String property) {
        return (Color)this.get(property);
    }

    public Font getFont(String property) {
        return (Font)this.get(property);
    }

    public Integer getHorizontalAlignment() {
        return (Integer)this.get(horizontalAlignment);
    }

    public ChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        Iterator itr = this.keySet().iterator();
        while (itr.hasNext()) {
            String name = itr.next().toString();
            Object value = this.get(name);
            if (value == null) continue;
            Object string = null;
            if (value instanceof String) {
                string = value.toString();
            } else if (value instanceof Number) {
                string = value.toString();
            } else if (value instanceof Boolean) {
                string = value.toString();
            } else if (value instanceof Color) {
                Color color = (Color)value;
                string = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
            } else if (value instanceof Font) {
                Font f = (Font)value;
                string = (String)string + f.getFamily() + "-";
                Object style = "";
                if ((f.getStyle() & 0) != 0) {
                    style = (String)style + "plain";
                }
                if ((f.getStyle() & 2) != 0) {
                    style = (String)style + "italic";
                }
                if ((f.getStyle() & 1) != 0) {
                    style = (String)style + "bold";
                }
                string = (String)string + "-" + (String)style + "-";
                string = (String)string + f.getSize();
            } else if (name.equalsIgnoreCase(horizontalAlignment)) {
                int align = (Integer)value;
                switch (align) {
                    case 0: {
                        string = HA_CENTER;
                        break;
                    }
                    case 4: {
                        string = HA_RIGHT;
                        break;
                    }
                    case 2: {
                        string = HA_LEFT;
                        break;
                    }
                    case 10: {
                        string = HA_LEADING;
                        break;
                    }
                    case 11: {
                        string = HA_TRAILING;
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
            }
            if (string == null) continue;
            w.incTabCount();
            w.write("<GRAPHIC_PROPERTY ");
            w.write(" NAME=\"");
            w.write(name);
            w.write("\" VALUE=\"");
            w.write((String)string);
            w.writeln("\"></GRAPHIC_PROPERTY>");
            w.decTabCount();
        }
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        Iterator itr = this.keySet().iterator();
        while (itr.hasNext()) {
            String name = itr.next().toString();
            Object value = this.get(name);
            if (value == null) continue;
            Object string = null;
            if (value instanceof String) {
                string = value.toString();
            } else if (value instanceof Number) {
                string = value.toString();
            } else if (value instanceof Boolean) {
                string = value.toString();
            } else if (value instanceof Color) {
                Color color = (Color)value;
                string = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
            } else if (value instanceof Font) {
                Font f = (Font)value;
                string = (String)string + f.getFamily() + "-";
                Object style = "";
                if ((f.getStyle() & 0) != 0) {
                    style = (String)style + "plain";
                }
                if ((f.getStyle() & 2) != 0) {
                    style = (String)style + "italic";
                }
                if ((f.getStyle() & 1) != 0) {
                    style = (String)style + "bold";
                }
                string = (String)string + "-" + (String)style + "-";
                string = (String)string + f.getSize();
            } else if (name.equalsIgnoreCase(horizontalAlignment)) {
                int align = (Integer)value;
                switch (align) {
                    case 0: {
                        string = HA_CENTER;
                        break;
                    }
                    case 4: {
                        string = HA_RIGHT;
                        break;
                    }
                    case 2: {
                        string = HA_LEFT;
                        break;
                    }
                    case 10: {
                        string = HA_LEADING;
                        break;
                    }
                    case 11: {
                        string = HA_TRAILING;
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
            }
            if (string == null) continue;
            out.append(indent).append("<GRAPHIC_PROPERTY");
            out.append(" NAME=\"").append(name).append("\"");
            out.append(" VALUE=\"").append((CharSequence)string).append("\"");
            out.append("/>\n");
        }
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    private Object putInteger(Object property, Object value) {
        return super.put(property, Integer.parseInt((String)value));
    }

    private Object putBoolean(Object property, Object value) {
        return super.put(property, Boolean.parseBoolean((String)value));
    }

    private Object putString(Object property, Object value) {
        return super.put(property, value.toString());
    }

    private Object putColor(Object property, Object value) {
        StringTokenizer tokenizer = new StringTokenizer((String)value, ",");
        int r = Integer.parseInt(tokenizer.nextToken());
        int g = Integer.parseInt(tokenizer.nextToken());
        int b = Integer.parseInt(tokenizer.nextToken());
        return super.put(property, new Color(r, g, b));
    }

    private Object putFont(Object property, Object value) {
        StringTokenizer tokenizer = new StringTokenizer((String)value, "-");
        String family = tokenizer.nextToken();
        String strStyle = tokenizer.nextToken();
        int style = 0;
        if (strStyle.contains("plain")) {
            style |= 0;
        }
        if (strStyle.contains("italic")) {
            style |= 2;
        }
        if (strStyle.contains("bold")) {
            style |= 1;
        }
        int size = Integer.parseInt(tokenizer.nextToken());
        return super.put(property, new Font(family, style, size));
    }

    private Object putHorizAlign(Object property, Object value) {
        String prop = (String)property;
        if (prop.equalsIgnoreCase(HA_CENTER)) {
            return super.put(property, 0);
        }
        if (prop.equalsIgnoreCase(HA_LEFT)) {
            return super.put(property, 2);
        }
        if (prop.equalsIgnoreCase(HA_RIGHT)) {
            return super.put(property, 4);
        }
        if (prop.equalsIgnoreCase(HA_LEADING)) {
            return super.put(property, 10);
        }
        if (prop.equalsIgnoreCase(HA_TRAILING)) {
            return super.put(property, 11);
        }
        return super.put(property, 0);
    }
}

