/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelationDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import java.io.IOException;
import org.w3c.dom.Element;

public class FmeaRelation
extends FmeaObject
implements FmeaSerializable {
    private FmeaRelationDefinition _definition = null;
    private FmeaEntity _entity1 = null;
    private FmeaEntity _entity2 = null;

    public FmeaRelation(FmeaRelationDefinition definition, FmeaEntity entity1, FmeaEntity entity2) {
        this._definition = definition;
        this._entity1 = entity1;
        this._entity2 = entity2;
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        w.write("<RELATION ");
        w.write(" DEFINITION=\"");
        w.write(this.getDefinition().getKey());
        w.write("\" ENTITY_REF1=\"");
        w.write(Util.formatStringForXml(this._entity1.getName()));
        w.write("\" ENTITY_REF2=\"");
        w.write(Util.formatStringForXml(this._entity2.getName()));
        w.writeln("\"></RELATION>");
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<RELATION ");
        out.append(" DEFINITION=\"").append(this.getDefinition().getKey()).append("\"");
        out.append(" ENTITY_REF1=\"").append(Util.formatStringForXml(this._entity1.getName())).append("\"");
        out.append(" ENTITY_REF2=\"").append(Util.formatStringForXml(this._entity2.getName())).append("\"");
        out.append("/>\n");
    }

    FmeaRelationDefinition getDefinition() {
        return this._definition;
    }

    FmeaEntity getEntity1() {
        return this._entity1;
    }

    FmeaEntity getEntity2() {
        return this._entity2;
    }
}

