/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.core.cecilia.error.Msg;
import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.model.Dictionnary;
import com.dassault.cecilia.dbobj.fmea.model.DictionnaryManager;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaExternalRefAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaGraphicPropertyCollection;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableDefinition;
import com.dassault.cecilia.dbobj.fmea.model.Formula;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class FmeaTableModel
extends AbstractTableModel {
    static int __count = 0;
    private Fmea _fmea;
    private DictionnaryManager _dicoMgr;
    private Vector<Map<FmeaColumnDefinition, FmeaEntity>> _data = new Vector();

    public FmeaTableModel(DictionnaryManager dicoMgr) {
        this._dicoMgr = dicoMgr;
    }

    public Fmea getFmea() {
        return this._fmea;
    }

    public void setFmea(Fmea fmea) {
        this._fmea = fmea;
        this.loadFmea();
    }

    public void loadFmea() {
        this._data.clear();
        int depth = 0;
        FmeaTableDefinition tableDef = this._fmea.getModel().getTableDefinition();
        FmeaEntityDefinition originEntityDef = this._fmea.getModel().getEntityDefinitionFromPath(0);
        if (originEntityDef == null) {
            return;
        }
        Map curMap = this._fmea.getEntities(originEntityDef.getKey());
        Map curEntityAttributeMap = new HashMap();
        Stack<Object> stack = new Stack<Object>();
        Iterator curIterator = curMap.values().iterator();
        while (true) {
            if (curIterator.hasNext()) {
                FmeaEntity curEntity = curIterator.next();
                HashMap entityAttributeMap = new HashMap();
                entityAttributeMap.putAll(curEntityAttributeMap);
                Iterator attributes = curEntity.getDefinition().getAttributeDefinitionIterator();
                while (attributes.hasNext()) {
                    FmeaAttributeDefinition attribute = (FmeaAttributeDefinition)attributes.next();
                    FmeaColumnDefinition columnDef = tableDef.getColumnDefinition(curEntity.getDefinition().getKey(), attribute.getKey());
                    if (columnDef == null) continue;
                    entityAttributeMap.put(columnDef, curEntity);
                }
                if (depth == this._fmea.getModel().getEntityPathLength() - 1) {
                    this._data.add(entityAttributeMap);
                    continue;
                }
                curMap = (Map)curEntity.getRelations().get(this._fmea.getModel().getEntityDefinitionFromPath(depth + 1).getKey());
                if (curMap == null) {
                    this._data.add(entityAttributeMap);
                    continue;
                }
                stack.push(curIterator);
                stack.push(curEntityAttributeMap);
                curIterator = curMap.values().iterator();
                curEntityAttributeMap = entityAttributeMap;
                ++depth;
                continue;
            }
            if (stack.isEmpty()) break;
            curEntityAttributeMap = (Map)stack.pop();
            curIterator = (Iterator)stack.pop();
            --depth;
        }
        this.fireTableDataChanged();
    }

    public FmeaColumnDefinition getColumnDefinition(int column) {
        return this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
    }

    @Override
    public int getColumnCount() {
        return this._fmea.getModel().getTableDefinition().getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumnDefinition(column).getName();
    }

    public Class getColumnClass(int column) {
        return this.getColumnDefinition(column).getColumnClass();
    }

    public FmeaAttributeDefinition.Type getColumnType(int column) {
        return this.getColumnDefinition(column).getColumnType();
    }

    public Integer getColumnWidth(int column) {
        return this.getColumnDefinition(column).getGraphicProperties().getInteger(FmeaGraphicPropertyCollection.width);
    }

    public boolean isReferenceColumn(int column) {
        return this.getColumnType(column) instanceof FmeaAttributeDefinition.Reference;
    }

    public Iterator getEntities(int column) {
        FmeaColumnDefinition columnDef = this.getColumnDefinition(column);
        return this._fmea.getEntities(columnDef.getEntityDefinition().getKey()).values().iterator();
    }

    @Override
    public int getRowCount() {
        return this._data.size();
    }

    public int getColumnForDefinition(String entDefKey, String attKey) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnDefinition(i).getEntityDefinition().getKey().equals(entDefKey) || !this.getColumnDefinition(i).getAttributeDefinition().getKey().equals(attKey)) continue;
            return i;
        }
        return -1;
    }

    public FmeaEntity getEntityAt(int row, int column) {
        FmeaColumnDefinition columnDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        return this.getEntityAt(row, columnDef);
    }

    public int getRowForEntity(int column, String entName) {
        FmeaColumnDefinition colDef = this.getColumnDefinition(column);
        return this.getRowForEntity(colDef, entName);
    }

    public int getRowForEntity(FmeaColumnDefinition colDef, String entName) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Map<FmeaColumnDefinition, FmeaEntity> entityAttributeMap = this._data.get(row);
            FmeaEntity entity = entityAttributeMap.get(colDef);
            if (!entity.getName().equals(entName)) continue;
            return row;
        }
        return -1;
    }

    public FmeaAttribute getAttributeAt(int row, int column) {
        FmeaEntity entity = this.getEntityAt(row, column);
        if (entity == null) {
            return null;
        }
        FmeaColumnDefinition colDef = this.getColumnDefinition(column);
        FmeaAttributeDefinition attDef = colDef.getAttributeDefinition();
        return entity.getAttribute(attDef.getKey());
    }

    public void setAttributeAt(FmeaAttribute attribute, int row, int column) {
        FmeaColumnDefinition colDef;
        FmeaAttributeDefinition attDef;
        FmeaEntity entity = this.getEntityAt(row, column);
        FmeaAttribute oldAttribute = entity.getAttribute((attDef = (colDef = this.getColumnDefinition(column)).getAttributeDefinition()).getKey());
        if (oldAttribute != null && oldAttribute instanceof FmeaExternalRefAttribute) {
            this.getFmea().getExternalLinks().removeAll(((FmeaExternalRefAttribute)oldAttribute).getExternalReferences());
        }
        entity.setAttribute(attDef.getKey(), attribute);
        if (attribute != null && attribute instanceof FmeaExternalRefAttribute) {
            this.getFmea().getExternalLinks().addAll(((FmeaExternalRefAttribute)attribute).getExternalReferences());
        }
    }

    public FmeaEntity getEntityAt(int row, FmeaColumnDefinition columnDef) {
        Map<FmeaColumnDefinition, FmeaEntity> entityAttributeMap = this._data.get(row);
        FmeaEntity entity = entityAttributeMap.get(columnDef);
        return entity;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = this.getRealValueAt(row, column);
        if (value == null) {
            return null;
        }
        String dicoValue = this.getDictionnaryValue(column, value);
        return dicoValue == null ? value : dicoValue;
    }

    private Object getRealValueAt(int row, int column) {
        FmeaColumnDefinition columnDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        Object value = null;
        if (columnDef.isLinkedToAttribute()) {
            FmeaEntity entity = this.getEntityAt(row, columnDef);
            if (entity == null) {
                return null;
            }
            String attributeKey = columnDef.getAttributeDefinition().getKey();
            value = entity.getAttributeValue(attributeKey);
        } else if (columnDef.getFormula() != null) {
            Formula formula = columnDef.getFormula();
            HashMap<String, Number> operands = new HashMap<String, Number>();
            for (int i = 0; i < formula.getCountOperands(); ++i) {
                String opName = formula.getOperandName(i);
                int col = Integer.parseInt(opName);
                Number src = (Number)this.getRealValueAt(row, col);
                src = src == null ? (Number)0.0 : (Number)src;
                operands.put(opName, src);
            }
            value = formula.apply(operands);
        }
        return value;
    }

    private String getDictionnaryValue(int column, Object value) {
        String dicoName = this.getColumnDefinition(column).getGraphicProperties().getString(FmeaGraphicPropertyCollection.dictionnary);
        if (dicoName == null) {
            return null;
        }
        Dictionnary dico = this._dicoMgr.getDictionnary(dicoName);
        if (dico == null) {
            return null;
        }
        return dico.getThreshold(value);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        Map<FmeaColumnDefinition, FmeaEntity> entityAttributeMap = this._data.get(row);
        FmeaColumnDefinition columnDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        FmeaEntity oldEntity = entityAttributeMap.get(columnDef);
        String attributeKey = columnDef.getAttributeDefinition().getKey();
        if (this.isReferenceColumn(column)) {
            FmeaEntityDefinition entityDef = oldEntity.getDefinition();
            FmeaEntity entity = this._fmea.getEntity(entityDef.getKey(), value.toString());
            if (entity == null) {
                oldEntity.setName(value.toString());
                this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount(), column, 0));
            }
        } else if (oldEntity != null) {
            oldEntity.setAttributeValue(attributeKey, value);
            if (columnDef.getColumnType() instanceof FmeaAttributeDefinition.Number) {
                FmeaTableDefinition tableDef = this._fmea.getModel().getTableDefinition();
                for (int col = 0; col < tableDef.getColumnCount(); ++col) {
                    FmeaColumnDefinition colDef = tableDef.getColumnDefinition(col);
                    if (!(colDef.getColumnType() instanceof FmeaAttributeDefinition.Number)) continue;
                    this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount(), col, 0));
                }
            } else {
                this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount(), column, 0));
            }
        }
    }

    public boolean checkValue(Object value, int row, int column) {
        if (value != null) {
            FmeaEntityDefinition entityDef;
            FmeaEntity otherEntity;
            FmeaEntity entity = this.getEntityAt(row, column);
            if (this.isReferenceColumn(column) && (otherEntity = this._fmea.getEntity((entityDef = entity.getDefinition()).getKey(), value.toString())) != null && otherEntity != entity) {
                Fmea.errorMgr.add(new Msg(Messages.getString("FmeaTableModel.0")));
                return false;
            }
        }
        return this._fmea.checkValue(value, row, column);
    }

    public boolean isDataExist(int row, int column) {
        return this.getEntityAt(row, this._fmea.getModel().getTableDefinition().getColumnDefinition(column)) != null;
    }

    public boolean isSortDataColumnResult(int col) {
        SortData sortData = this.getFmea().getModel().getSortData();
        if (sortData == null) {
            return false;
        }
        if (!sortData.getGroupCells()) {
            return false;
        }
        FmeaColumnDefinition colDef = this.getColumnDefinition(col);
        for (int i = 0; i < sortData.getColumnCount(); ++i) {
            if (sortData.getColumnDefinition(i) != colDef) continue;
            return sortData.formulaApplied(i);
        }
        return false;
    }

    public FmeaEntity createEntity(int row, int column) {
        FmeaColumnDefinition colDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        if (colDef.getEntityDefinition() != this._fmea.getModel().getEntityDefinitionFromPath(0)) {
            return null;
        }
        FmeaEntityDefinition entDef = colDef.getEntityDefinition();
        FmeaEntity entity = this._fmea.createEntity(entDef, null);
        this.loadFmea();
        return entity;
    }

    public void createRelation(int row, int column) {
        FmeaColumnDefinition colDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        FmeaEntity entity = this.getEntityAt(row, colDef);
        if (entity == null) {
            return;
        }
        this._fmea.createRelation(entity);
        this.loadFmea();
    }

    public void createAllRelations(int row, int column) {
        FmeaColumnDefinition colDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        FmeaEntity entity = this.getEntityAt(row, colDef);
        if (entity == null) {
            return;
        }
        this._fmea.createAllRelations(entity);
        this.loadFmea();
    }

    public void removeEntity(int row, int column) {
        FmeaColumnDefinition colDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        FmeaEntity entity = this.getEntityAt(row, colDef);
        if (entity == null) {
            return;
        }
        this._fmea.removeEntity(entity);
        this.loadFmea();
    }

    public void removeRelation(int row, int column) {
        FmeaColumnDefinition colDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        FmeaEntity entity = this.getEntityAt(row, colDef);
        if (entity == null) {
            return;
        }
        FmeaEntity parent = entity.getRelationOrigin();
        if (parent == null) {
            return;
        }
        this._fmea.removeRelation(parent, entity);
        this.loadFmea();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        FmeaColumnDefinition colDef = this._fmea.getModel().getTableDefinition().getColumnDefinition(column);
        return colDef.getGraphicProperties().getString(FmeaGraphicPropertyCollection.dictionnary) == null;
    }
}

