/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.io.FmeaBufferedWriter;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaSerializable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;

public class SortData
extends FmeaObject
implements FmeaSerializable {
    public static final int SUM = 0;
    public static final int PRODUCT = 1;
    protected Vector<Column> _columns = new Vector();
    protected boolean _groupCells = false;

    public SortData(boolean groupCells) {
        this._groupCells = groupCells;
    }

    public void setGroupCells(boolean groupCells) {
        this._groupCells = groupCells;
        this._changeNotifier.changed(this);
    }

    public boolean getGroupCells() {
        return this._groupCells;
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public void addColumn(FmeaColumnDefinition colDef, String sortOrder) {
        assert (this.getColumn(colDef) == null);
        this._columns.add(new Column(colDef, sortOrder));
        this._changeNotifier.changed(this);
    }

    public void removeColumn(FmeaColumnDefinition colDef) {
        if (this.getColumn(colDef) == null) {
            return;
        }
        this._columns.remove(this.getColumn(colDef));
        this._changeNotifier.changed(this);
    }

    public void removeColumn(int index) {
        assert (this._columns.size() > index);
        this._columns.remove(index);
        this._changeNotifier.changed(this);
    }

    public void swapColumns(int index1, int index2) {
        assert (index1 < this._columns.size() && index2 < this._columns.size());
        Column col1 = this._columns.get(index1);
        Column col2 = this._columns.get(index2);
        this._columns.set(index1, col2);
        this._columns.set(index2, col1);
        this._changeNotifier.changed(this);
    }

    public boolean containsColumn(FmeaColumnDefinition colDef) {
        return this.getColumn(colDef) != null;
    }

    public void setColumnOrder(FmeaColumnDefinition colDef, String order) {
        assert (this.getColumn(colDef) != null);
        Column column = this.getColumn(colDef);
        column.setSortOrder(order);
        this._changeNotifier.changed(this);
    }

    public void setColumnFormula(FmeaColumnDefinition colDef, boolean formula) {
        assert (this.getColumn(colDef) != null);
        Column column = this.getColumn(colDef);
        column.setFormula(formula ? new Formula() : null);
        this._changeNotifier.changed(this);
    }

    public void setColumnFormula(FmeaColumnDefinition colDef, FmeaColumnDefinition srcColDef, int operation) {
        assert (this.getColumn(colDef) != null);
        Column column = this.getColumn(colDef);
        column.setFormula(new Formula(srcColDef, operation));
        this._changeNotifier.changed(this);
    }

    public void setColumnFormulaOperation(FmeaColumnDefinition colDef, int operation) {
        assert (this.getColumn(colDef) != null);
        Column column = this.getColumn(colDef);
        column.getFormula().setOperation(operation);
        this._changeNotifier.changed(this);
    }

    public void setColumnFormulaSourceColumn(FmeaColumnDefinition colDef, FmeaColumnDefinition srcColDef) {
        assert (this.getColumn(colDef) != null);
        Column column = this.getColumn(colDef);
        column.getFormula().setSourceColDef(srcColDef);
        this._changeNotifier.changed(this);
    }

    public FmeaColumnDefinition getColumnDefinition(int index) {
        assert (this._columns.size() > index);
        return this._columns.get(index).getColumnDefinition();
    }

    public String getColumnSortOrder(int index) {
        assert (this._columns.size() > index);
        return this._columns.get(index).getSortOrder();
    }

    public boolean formulaApplied(int index) {
        Formula formula = this._columns.get(index).getFormula();
        if (formula == null) {
            return false;
        }
        return formula.getOperation() != -1 && formula.getSourceColumnDefinition() != null;
    }

    public boolean formulaApplied(FmeaColumnDefinition colDef) {
        Formula formula = this.getColumn(colDef).getFormula();
        if (formula == null) {
            return false;
        }
        return formula.getOperation() != -1 && formula.getSourceColumnDefinition() != null;
    }

    public FmeaColumnDefinition getFormulaSourceColumn(int index) {
        assert (this._columns.size() > index);
        return this._columns.get(index).getFormula().getSourceColumnDefinition();
    }

    public int getFormulaOperation(int index) {
        assert (this._columns.size() > index);
        return this._columns.get(index).getFormula().getOperation();
    }

    public FmeaColumnDefinition getFormulaSourceColumn(FmeaColumnDefinition colDef) {
        assert (this.getColumn(colDef) != null);
        return this.getColumn(colDef).getFormula().getSourceColumnDefinition();
    }

    public int getFormulaOperation(FmeaColumnDefinition colDef) {
        assert (this.getColumn(colDef) != null);
        return this.getColumn(colDef).getFormula().getOperation();
    }

    public SortData copy() {
        SortData sortData = new SortData(this.getGroupCells());
        Iterator<Column> i = this._columns.iterator();
        while (i.hasNext()) {
            sortData._columns.add((Column)i.next().copy());
        }
        return sortData;
    }

    @Override
    public Object readXML(Element node) {
        return null;
    }

    @Override
    public void writeXML(FmeaBufferedWriter w) throws IOException {
        if (this._columns.size() == 0) {
            return;
        }
        w.write("<SORT");
        w.write(" GROUP_CELLS=\"" + this._groupCells + "\"");
        w.writeln(">");
        Iterator<Column> iterator = this._columns.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeXML(w);
        }
        w.writeln("</SORT>");
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        if (this._columns.size() == 0) {
            return;
        }
        out.append(indent).append("<SORT");
        out.append(" GROUP_CELLS=\"" + this._groupCells + "\"");
        out.append(">\n");
        String indent1 = indent + "  ";
        Iterator<Column> iterator = this._columns.iterator();
        while (iterator.hasNext()) {
            iterator.next().toXML(out, indent1);
        }
        out.append(indent).append("</SORT>\n");
    }

    private Column getColumn(FmeaColumnDefinition colDef) {
        for (int i = 0; i < this._columns.size(); ++i) {
            if (this._columns.get(i).getColumnDefinition() != colDef) continue;
            return this._columns.get(i);
        }
        return null;
    }

    public static void main(String[] args) {
    }

    private class Column
    implements FmeaSerializable {
        private FmeaColumnDefinition _colDef;
        String _sortOrder = "ascending";
        Formula _formula;

        Column(FmeaColumnDefinition colDef, String sortOrder) {
            this._colDef = colDef;
            this._sortOrder = sortOrder;
        }

        FmeaColumnDefinition getColumnDefinition() {
            return this._colDef;
        }

        String getSortOrder() {
            return this._sortOrder;
        }

        void setSortOrder(String sortOrder) {
            this._sortOrder = sortOrder;
        }

        Formula getFormula() {
            return this._formula;
        }

        void setFormula(Formula formula) {
            this._formula = formula;
        }

        @Override
        public void writeXML(FmeaBufferedWriter w) throws IOException {
            if (this.getColumnDefinition() == null) {
                return;
            }
            w.incTabCount();
            w.write("<SORT_COLUMN");
            w.write(" COLUMN=\"");
            w.write(this.getColumnDefinition().getKey() == null ? "" : this.getColumnDefinition().getKey());
            w.write("\" SORT_ORDER=\"");
            w.write(this.getSortOrder());
            w.writeln("\">");
            if (this.getFormula() != null) {
                this.getFormula().writeXML(w);
            }
            w.writeln("</SORT_COLUMN>");
            w.decTabCount();
        }

        @Override
        public void toXML(Appendable out, String indent) throws IOException {
            if (this.getColumnDefinition() == null) {
                return;
            }
            out.append(indent).append("<SORT_COLUMN");
            out.append(" COLUMN=\"").append(this.getColumnDefinition().getKey() == null ? "" : this.getColumnDefinition().getKey()).append("\"");
            out.append(" SORT_ORDER=\"").append(this.getSortOrder()).append("\"");
            if (this.getFormula() == null) {
                out.append("/>\n");
            } else {
                out.append(">\n");
                this.getFormula().toXML(out, indent);
                out.append(indent).append("</SORT_COLUMN>\n");
            }
        }

        @Override
        public Object readXML(Element node) {
            return null;
        }

        public Object copy() {
            Column column = new Column(this._colDef, "ascending");
            column.setSortOrder(this._sortOrder);
            column.setFormula(this._formula == null ? null : (Formula)this._formula.copy());
            return column;
        }
    }

    private class Formula
    implements FmeaSerializable {
        int _operation = -1;
        FmeaColumnDefinition _sourceColDef = null;

        Formula() {
        }

        Formula(FmeaColumnDefinition sourceColDef, int operation) {
            this._sourceColDef = sourceColDef;
            this._operation = operation;
        }

        int getOperation() {
            return this._operation;
        }

        void setOperation(int operation) {
            this._operation = operation;
        }

        FmeaColumnDefinition getSourceColumnDefinition() {
            return this._sourceColDef;
        }

        void setSourceColDef(FmeaColumnDefinition sourceColDef) {
            this._sourceColDef = sourceColDef;
        }

        @Override
        public void writeXML(FmeaBufferedWriter w) throws IOException {
            w.incTabCount();
            w.write("<GROUPBY_FORMULA");
            w.write(" SOURCE_COLUMN=\"");
            w.write(this.getSourceColumnDefinition().getKey());
            w.write("\" OPERATION=\"");
            w.write(this.getOperation() == 0 ? "sum" : (this.getOperation() == 1 ? "product" : null));
            w.write("\">");
            w.writeln("</GROUPBY_FORMULA>");
            w.decTabCount();
        }

        @Override
        public void toXML(Appendable out, String indent) throws IOException {
            out.append(indent).append("<GROUPBY_FORMULA");
            out.append(" SOURCE_COLUMN=\"").append(this.getSourceColumnDefinition().getKey()).append("\"");
            out.append(" OPERATION=\"").append(this.getOperation() == 0 ? "sum" : (this.getOperation() == 1 ? "product" : null)).append("\"");
            out.append("/>\n");
        }

        @Override
        public Object readXML(Element node) {
            return null;
        }

        public Object copy() {
            return new Formula(this._sourceColDef, this._operation);
        }
    }
}

