/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.util;

import com.dassault.cecilia.dbobj.fmea.util.SorterTableHeader;
import com.dassault.cecilia.dbobj.fmea.util.SorterTableModel2;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class SorterTable2
extends JTable {
    protected boolean sorting = false;
    protected boolean sortEnabled = true;

    public SorterTable2() {
        this.setSorterTableModel(new SorterTableModel2());
        this.initSorting();
    }

    public SorterTable2(SorterTableModel2 sorterModel) {
        this.setSorterTableModel(sorterModel);
        this.initSorting();
    }

    public SorterTableModel2 getSorterTableModel() {
        return (SorterTableModel2)this.getModel();
    }

    public void setSorterTableModel(SorterTableModel2 sorterModel) {
        this.setModel(sorterModel);
    }

    public void setDataModel(TableModel model) {
        this.setSorterTableModel(new SorterTableModel2(model));
    }

    public TableModel getDataModel() {
        return this.getSorterTableModel().getModel();
    }

    public SorterTableHeader getSorterTableHeader() {
        return (SorterTableHeader)this.getTableHeader();
    }

    public void setSorterTableHeader(SorterTableHeader sth) {
        this.setTableHeader(sth);
    }

    public void setSortEnabled(boolean enabled) {
        this.sortEnabled = enabled;
        this.getSorterTableHeader().setSortEnabled(enabled);
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void sort(Vector columns, Vector sortingOrders) {
        this.getSorterTableModel().sort(columns, sortingOrders);
    }

    public void sort(int column, boolean ascending) {
        this.getSorterTableModel().sort(column, ascending);
        this.getSorterTableHeader().setColumnSorted(column, ascending);
    }

    protected void initSorting() {
        this.setColumnSelectionAllowed(false);
        this.setTableHeader(new SorterTableHeader(this.getColumnModel()));
        this.defineSorterListener();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int column;
        if (e.getSource() instanceof SorterTableModel2 && this.getSorterTableModel().getSortingColumns().size() > 1 && (column = ((Integer)this.getSorterTableModel().getSortingColumns().get(0)).intValue()) < this.getColumnCount()) {
            boolean order = this.getSorterTableModel().getAscendingOrder().equals("ascending");
            this.getSorterTableHeader().setColumnSorted(column, order);
        }
        super.tableChanged(e);
    }

    private void defineSorterListener() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SorterTable2.this.sortEnabled) {
                    return;
                }
                if (e.getClickCount() == 1 && e.getModifiersEx() == 1024) {
                    SorterTable2.this.sorting = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!SorterTable2.this.sortEnabled) {
                    return;
                }
                if (e.getClickCount() == 1 && e.getModifiersEx() == 1024 && SorterTable2.this.sorting) {
                    int viewColumn = SorterTable2.this.getColumnModel().getColumnIndexAtX(e.getX());
                    if (viewColumn == -1) {
                        return;
                    }
                    int column = SorterTable2.this.convertColumnIndexToModel(viewColumn);
                    SorterTable2.this.sort(column, SorterTable2.this.getSorterTableHeader().getAscendingOrder());
                }
            }
        });
        this.getTableHeader().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!SorterTable2.this.sortEnabled) {
                    return;
                }
                SorterTable2.this.sorting = false;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }
}

