/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CCmdFolder;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeNodeFile;
import com.dassault.cecilia.dbobj.ResMsgObj;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class AssociatedFileCmdEdit
extends CCmdFolder {
    private static Logger _LOG = Logger.getLogger(AssociatedFileCmdEdit.class.getPackage().getName());
    protected CAppl _application;
    protected DBFolderTreeNodeFile _ctrlTree;

    public AssociatedFileCmdEdit(CAppl appl, Component c, DBFolderTreeNodeFile ctrlTree) {
        super(appl, c, ctrlTree.getDBFolder());
        this._application = appl;
        this._ctrlTree = ctrlTree;
    }

    @Override
    protected boolean prepareDo() {
        return true;
    }

    @Override
    protected void firstDo() {
        File file = this._ctrlTree.getFile(this._application.getDAOFactory(), this._application.getTmpDirectory());
        if (file == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(AssociatedFileCmdEdit.this.getSource(), ResMsgObj.getString("MSG_FILE_ASSOCIATED_DONT_READ"));
                }
            });
            return;
        }
        if (this._ctrlTree.getDBFolder().isFreeze()) {
            try {
                if (!file.setWritable(false, false)) {
                    _LOG.finest("Freeze folder - Impossible de mettre le fichier associ\u00e9 en lecture seul pour tous");
                    if (!file.setWritable(false, true)) {
                        _LOG.finest("Freeze folder - Impossible de mettre le fichier associ\u00e9 en lecture seul pour l'utilisateur courant");
                    }
                }
            }
            catch (Exception e) {
                _LOG.finest("Freeze folder - Exception au moement de mettre le fichier associ\u00e9 en lecture");
            }
        }
        boolean open = false;
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            try {
                Desktop.getDesktop().open(file);
                open = true;
            }
            catch (IOException ex) {
                _LOG.log(Level.INFO, "Impossible d'ouvrir le flux '" + this._ctrlTree.getName() + "' du dossier " + this._ctrlTree.getSource().getRefPath(), ex);
            }
        }
        if (!open) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(AssociatedFileCmdEdit.this.getSource(), ResMsgObj.getString("MSG_FILE_ASSOCIATED_DONT_OPEN"));
                }
            });
        }
    }
}

