/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CCmd;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderSelectUtility;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.faulttree.egli.EGLICmdGenerate;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DBFolderCmdProperty
extends CCmd {
    private static Logger _LOG = Logger.getLogger(DBFolderCmdProperty.class.getPackage().getName());
    protected CAppl _application;
    protected DBFolderTreeEditable _ctrlTree;
    protected DBFolder _dbFolder;
    protected DBUser _dbUser;
    protected boolean _bEditProperties;
    DBFolderPropertiesPanel _panel;

    public DBFolderCmdProperty(CAppl appl, DBFolderTreeEditable ctrlTree, boolean edit) {
        super(appl, ctrlTree);
        this._application = appl;
        this._ctrlTree = ctrlTree;
        this._bEditProperties = edit;
    }

    public boolean isEditProperties() {
        return this._bEditProperties;
    }

    public DBFolderCmdProperty setDBFolder(DBFolder dbFolder) {
        this._dbFolder = dbFolder;
        if (this._dbFolder.getChildren() == null) {
            this._application.getDAOFactory().createFolderDAO().findChildren(this._dbFolder);
        }
        if (this._dbFolder.getAccesses() == null) {
            this._application.getDAOFactory().createFolderDAO().findAccesses(this._dbFolder);
        }
        if (this._bEditProperties) {
            this._dbFolder.setMustBeUpdated(true);
            this._application.refreshDAOFolder(true);
        }
        return this;
    }

    public DBFolderCmdProperty setDBUser(DBUser dbUser) {
        this._dbUser = dbUser;
        return this;
    }

    @Override
    protected boolean prepareDo() {
        Window winOwner = SwingUtilities.getWindowAncestor(this._ctrlTree);
        this._panel = this.constructDialog();
        if (this._panel == null) {
            return false;
        }
        JDialogCecilia dlg = new JDialogCecilia(winOwner, this._panel.getTitle(), true){

            @Override
            protected boolean verifyParameters() {
                return DBFolderCmdProperty.this._panel.verifyParameters();
            }

            @Override
            public void setVisible(boolean b) {
                Container dlgContent = this.getContentPane();
                dlgContent.setLayout(new BorderLayout());
                DBFolderCmdProperty.this._panel.doCreate();
                dlgContent.add((Component)DBFolderCmdProperty.this._panel, "Center");
                if (DBFolderCmdProperty.this._panel.isReadOnly() && DBFolderCmdProperty.this._panel.isAccessReadOnly()) {
                    dlgContent.add((Component)this.createButPanelClose(false), "South");
                } else {
                    dlgContent.add((Component)this.createButPanel(), "South");
                }
                this.pack();
                this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
                super.setVisible(b);
            }
        };
        ImageIcon icon = DBFolderResources.getIcon(this._panel.getDBFolder(), false, false, false, false);
        dlg.setIconImage(icon.getImage());
        dlg.setVisible(true);
        return dlg.getResult();
    }

    @Override
    protected void firstDo() {
        if (!this.isEditProperties()) {
            if (this._panel.isFamilyTarget()) {
                this.createFamilyFolder(this._panel);
            } else if (this._dbFolder.isFolder() || this._dbFolder.isSystem()) {
                this.createModelFolder(this._panel);
            } else if (this._dbFolder.isModel()) {
                this.createVersionFolder(this._panel);
            }
        } else if (this._panel.isFamilyTarget()) {
            this.updateFamilyFolder(this._panel);
        } else {
            this.updateModelFolder(this._panel);
        }
    }

    protected DBFolder createDBFolder(DBFolder create) {
        DBFolder result = this._application.getDAOFactory().createFolderDAO().create(create);
        if (result == null) {
            _LOG.warning("Erreur lors de la cr\u00e9ation dans la BdD du dossier : " + create.toString());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTree), ResMsgObj.msgFormat("MSG_FOL_ERR_CREATE", new Object[0]), this._application.getTitle(), 0);
        } else {
            result.setMustBeUpdated(true);
            this._application.refreshDAOFolder(true);
            SwingUtilities.invokeLater(new DBFolderSelectUtility((DBFolderTree)this._ctrlTree, result));
        }
        return result;
    }

    protected void createFamilyFolder(DBFolderPropertiesPanel dlg) {
        DBFolder create = dlg.getDBFolder();
        this.createDBFolder(create);
    }

    protected void createModelFolder(DBFolderPropertiesPanel dlg) {
        DBFolder dbFolderModel = dlg.getDBFolder();
        DBFolder dbFolderVersion = new DBFolder(dbFolderModel, this._dbUser);
        dbFolderVersion.setName("1");
        dbFolderVersion.setDescription(dbFolderModel.getDescription());
        dbFolderVersion.setFlags(DBFolder.createFlagsVersion(dbFolderModel.getFamily(), (short)0, (short)0));
        dbFolderVersion.setObject(this.createObject(dbFolderVersion));
        dbFolderModel.setChildren(Collections.singletonList(dbFolderVersion));
        this.createDBFolder(dbFolderModel);
    }

    protected DBObject createObject(DBFolder dbFolderVersion) {
        DBObject dbObject = new DBObject();
        dbFolderVersion.setObject(dbObject);
        DBObjProperty dbProperty = new DBObjProperty().setName("object.release").setType("Long").setValue("0");
        dbObject.addProperty(dbProperty);
        dbProperty = new DBObjProperty().setName("object.creator").setType("String").setValue(this.getAppl().getDBUser().getLogin());
        dbObject.addProperty(dbProperty);
        return dbObject;
    }

    protected void createVersionFolder(DBFolderPropertiesPanel dlg) {
        DAOFactory daoFactory;
        DBFolder resVersion = dlg.getDBFolder();
        DBFolder refVersion = dlg.getRefVersion();
        DBObject resObject = this.duplicateDBObject(refVersion.getObject());
        resObject.addProperty(new DBObjProperty().setName("object.creator").setType("String").setValue(resVersion.getUserOwner().getLogin()));
        resVersion.setObject(resObject);
        Collection<DBRelation> srcRelations = this._application.getDAOFactory().createRelationDAO().getDestinationRelations(refVersion);
        if (srcRelations.size() > 0) {
            ArrayList<DBRelation> dstRelations = new ArrayList<DBRelation>(srcRelations.size());
            for (DBRelation srcRelation : srcRelations) {
                DBRelation dstRelation = new DBRelation(resVersion, srcRelation.getTypeSource(), srcRelation.getDestination(), srcRelation.getTypeDestination());
                dstRelations.add(dstRelation);
            }
            resVersion.setRelations(dstRelations);
        }
        if ((resVersion = this.createDBFolder(resVersion)) != null && resVersion.getFamily() == DBFolder.Family.PROJECT && (daoFactory = this._application.getDAOFactory()) instanceof CECFactory) {
            switch (resVersion.getFamilyFlag()) {
                case 2: 
                case 3: 
                case 5: {
                    if (EGLICmdGenerate.GenerateEGLI((CECFactory)daoFactory, resVersion)) break;
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTree), ResMsgObj.getString("EGL_MSG_GENERATE_GENERAL"), this._application.getTitle(), 2);
                }
            }
        }
    }

    protected DBObject duplicateDBObject(DBObject ref) {
        DBObject dstObject = new DBObject();
        dstObject.setFlags(ref.getFlags());
        dstObject.unsetBinFlag(2);
        for (DBObjProperty refProp : ref.getProperties()) {
            DBObjProperty dstObjProp = new DBObjProperty(refProp);
            dstObjProp.setID(-1L);
            dstObject.addProperty(dstObjProp);
        }
        DBObjProperty dbProperty = dstObject.getProperty("object.creator");
        if (dbProperty != null) {
            dbProperty.setValue(this.getAppl().getDBUser().getLogin());
        } else {
            dbProperty = new DBObjProperty().setName("object.creator").setType("String").setValue(this.getAppl().getDBUser().getLogin());
            dstObject.addProperty(dbProperty);
        }
        dbProperty = dstObject.getProperty("object.release");
        if (dbProperty != null) {
            dbProperty.setValue("0");
        } else {
            dbProperty = new DBObjProperty().setName("object.release").setType("Long").setValue("0");
            dstObject.addProperty(dbProperty);
        }
        for (DBObjModel refModel : ref.getModels()) {
            DBObjModel dstObjMod = new DBObjModel(refModel);
            dstObjMod.setID(-1L);
            dstObjMod.setStreamToSave(this._application.getDAOFactory().createObjModelDAO().getBinaryStream(refModel));
            dstObject.addModel(dstObjMod);
        }
        return dstObject;
    }

    protected boolean updateDBFolder(DBFolder modify) {
        boolean update = false;
        update = this._application.getDAOFactory().createFolderDAO().update(modify);
        if (!update) {
            _LOG.warning("Erreur lors de la cr\u00e9ation dans la BdD du dossier : " + modify.toString());
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTree), ResMsgObj.msgFormat("MSG_FOL_ERR_CREATE", new Object[0]), this._application.getTitle(), 0);
        } else {
            this._dbFolder.setMustBeUpdated(true);
            this._application.refreshDAOFolder(true);
            EventQueue.invokeLater(new DBFolderSelectUtility((DBFolderTree)this._ctrlTree, this._dbFolder));
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFamilyFolder(DBFolderPropertiesPanel dlg) {
        DBFolder modify = dlg.getDBFolder();
        DBFolder cancel = new DBFolder(this._dbFolder);
        boolean update = false;
        try {
            if (this._dbFolder.getObject() != null && this._dbFolder.getObject().isFreeze()) {
                this._application.getDAOFactory().createFolderDAO().setAutoUpdateObject(false).setAutoUpdateDepenties(false);
            }
            this._dbFolder.copyFrom(modify);
            update = this.updateDBFolder(this._dbFolder);
        }
        finally {
            this._application.getDAOFactory().createFolderDAO().setAutoUpdateObject(true).setAutoUpdateDepenties(true);
            if (!update) {
                this._dbFolder.copyFrom(cancel);
            }
        }
    }

    protected void updateModelFolder(DBFolderPropertiesPanel dlg) {
        this.updateFamilyFolder(dlg);
    }

    protected DBFolderPropertiesPanel constructDialog() {
        DBFolderPropertiesPanel dlg = new DBFolderPropertiesPanel();
        if (!this.configurePanel(dlg)) {
            return null;
        }
        return dlg;
    }

    protected boolean configurePanel(DBFolderPropertiesPanel panel) {
        PluginWithOptions opts;
        Preferencies prefs = this._application.getPreferencies();
        if (prefs != null && (opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY)) != null && opts instanceof GeneralTextPreferencies) {
            panel.setDateFormat(((GeneralTextPreferencies)opts).getDateFormat());
        }
        panel.setDAOFactory(this._application.getDAOFactory());
        panel.setUserIsAdmin(this._dbUser.isAdmin());
        panel.setEditProperties(this.isEditProperties());
        if (!this.isEditProperties()) {
            DBFolder create = new DBFolder(this._dbFolder, this._dbUser);
            panel.setFolder(create);
            DBFolder.Family familyFolder = this._dbFolder.getFamily();
            short familyFlagFolder = this._dbFolder.getFamilyFlag();
            int depth = this._dbFolder.getDepthUntilSystem();
            boolean createFamily = depth < familyFolder.getDepthFolder();
            panel.setFamilyTarget(createFamily);
            if (createFamily) {
                panel.setVisiblePath(depth > 0);
                panel.setQuestion(DBFolderResources.getTypeFolder(familyFolder, depth));
                if (depth == 0) {
                    panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_FAMILY"));
                } else {
                    panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_SUBFAMILY"));
                }
                create.setFlags(DBFolder.createFlagsFolder(familyFolder, familyFlagFolder, (short)0));
            } else {
                if (!this.verifyCreateNewModel()) {
                    return false;
                }
                if (this._dbFolder.isFolder()) {
                    panel.setQuestion(DBFolderResources.getTypeModel(familyFolder, this._dbFolder.getFamilyFlag()));
                    panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_MODEL"));
                    create.setFlags(DBFolder.createFlagsModel(familyFolder, familyFlagFolder, (short)0));
                } else if (this._dbFolder.isModel()) {
                    List<DBFolder> refChildren = this.getUnlockChildren(SwingUtilities.getWindowAncestor(panel));
                    if (refChildren.isEmpty()) {
                        return false;
                    }
                    panel.setQuestion(DBFolderResources.getTypeVersion(familyFolder));
                    panel.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_VERSION"));
                    create.setFlags(DBFolder.createFlagsVersion(familyFolder, familyFlagFolder, (short)0));
                    panel.setVersionsReferencies(refChildren, this._dbFolder.getChildren());
                }
            }
        } else {
            panel.setReadOnly(this.propertiesHasReadOnly());
            panel.setAccessReadOnly(this.accessHasReadOnly());
            int depth = this._dbFolder.getDepthUntilSystem();
            DBFolder dbFolder = new DBFolder(this._dbFolder);
            panel.setWithDepends(dbFolder.getObject() != null);
            panel.setFolder(dbFolder);
            panel.setVisiblePath(depth > 1);
            panel.setQuestion(ResMsgVoc.getString("VOC_NAME"));
            panel.setTitle(ResMsgVoc.getString("VOC_PROPERTIES") + " - " + DBFolderResources.getTypeName(this._dbFolder));
            panel.setNameEditable(!this.nameHasReadOnly());
        }
        return true;
    }

    protected boolean verifyCreateNewModel() {
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && !((DemoLimitedFactory)this._application.getDAOFactory()).verifyCreateNewModel(this._dbFolder)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.getString("DEMO_ERROR_CREATE"), this._application.getTitle(), 0);
            return false;
        }
        return true;
    }

    protected List<DBFolder> getUnlockChildren(Window win) {
        ArrayList<DBFolder> children = new ArrayList<DBFolder>(this._dbFolder.getChildren());
        Iterator iterChild = children.iterator();
        while (iterChild.hasNext()) {
            DBFolder dbVersion = (DBFolder)iterChild.next();
            if (dbVersion.isFreeze() || !dbVersion.isEdited() && !dbVersion.isLocked()) continue;
            iterChild.remove();
        }
        if (children.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(win), ResMsgObj.getString("MSG_ERR_VERIFY_VERSION_REF"), ResMsgObj.getString("TITLE_GEN_CREATE_VERSION"), 0);
        }
        return children;
    }

    protected boolean propertiesHasReadOnly() {
        if (this._application.isReader()) {
            return true;
        }
        if (this._dbFolder.getAccessRight(this._dbUser) != DBAccess.Right.WRITE) {
            return true;
        }
        if (this._dbFolder.isVersion()) {
            if (this._dbFolder.isEdited()) {
                return true;
            }
            if (this._dbFolder.isLocked()) {
                return true;
            }
            if (this._dbFolder.isFreeze()) {
                return true;
            }
        }
        return false;
    }

    protected boolean accessHasReadOnly() {
        if (this._application.isReader()) {
            return true;
        }
        if (this._dbFolder.getAccessRight(this._dbUser) != DBAccess.Right.WRITE) {
            return true;
        }
        if (this._dbFolder.isVersion()) {
            if (this._dbFolder.isEdited()) {
                return true;
            }
            if (this._dbFolder.isLocked()) {
                return true;
            }
        }
        return false;
    }

    protected boolean nameHasReadOnly() {
        if (this._dbFolder.isVersion()) {
            return true;
        }
        if (this._dbFolder.isModel()) {
            for (DBFolder dbChild : this._dbFolder.getChildren()) {
                if (dbChild.isEdited()) {
                    return true;
                }
                if (dbChild.isLocked()) {
                    return true;
                }
                if (!dbChild.isFreeze()) continue;
                return true;
            }
        }
        return false;
    }
}

