/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.folder;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.action.CCmd;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderDlgDisplayError;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

public abstract class DBFolderCmdWithError
extends CCmd {
    ArrayList<GeneralError<DBFolder>> _errors = new ArrayList();
    boolean _withError = false;
    private DBFolderTree _ctrlTree;

    public boolean withWarnning() {
        return !this._errors.isEmpty();
    }

    public boolean withError() {
        return this._withError;
    }

    protected void addError(DBFolder folder, String msg) {
        this._errors.add(new GeneralError<DBFolder>(folder, msg));
        this._withError = true;
    }

    protected void addError(DBFolder folder, MsgType type, String msg) {
        this._errors.add(new GeneralError<DBFolder>(folder, msg, type));
        switch (type) {
            case ERROR: 
            case FATAL: {
                this._withError = true;
            }
        }
    }

    public List<GeneralError<DBFolder>> getErrors() {
        return this._errors;
    }

    protected void displayErrors(final List<GeneralError<DBFolder>> errors) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DBFolderDlgDisplayError dlg = new DBFolderDlgDisplayError(DBFolderCmdWithError.this.getAppl().getTopWindow());
                dlg.setTitle(DBFolderCmdWithError.this.getTitle());
                dlg.setSelectTree(DBFolderCmdWithError.this.getCtrlTree());
                dlg.setErrors(errors);
                dlg.setModal(false);
                dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(DBFolderCmdWithError.this.getSource()));
                dlg.setVisible(true);
            }
        });
    }

    protected abstract String getTitle();

    protected DBFolderTree getCtrlTree() {
        return this._ctrlTree;
    }

    public DBFolderCmdWithError(CAppl appl, DBFolderTree owner) {
        super(appl, owner);
        this._ctrlTree = owner;
    }

    public DBFolderCmdWithError(CAppl appl, Component owner) {
        super(appl, owner);
        this._ctrlTree = owner instanceof DBFolderTree ? (DBFolderTree)owner : null;
    }
}

