/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import java.awt.Color;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DBObjectXmlUtility
implements DBObjectXmlConstant {
    protected static Logger _LOG = Logger.getLogger(DBObjectXmlUtility.class.getPackage().getName());

    public static StringBuilder appendXML(StringBuilder out, String data) {
        char curCar = ' ';
        block7: for (int i = 0; i < data.length(); ++i) {
            curCar = data.charAt(i);
            switch (curCar) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                default: {
                    out.append(curCar);
                }
            }
        }
        return out;
    }

    public static Appendable appendXML(Appendable out, String data) throws IOException {
        char curCar = ' ';
        block7: for (int i = 0; i < data.length(); ++i) {
            curCar = data.charAt(i);
            switch (curCar) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                default: {
                    out.append(curCar);
                }
            }
        }
        return out;
    }

    public static void writeDBFolder(Appendable out, DBFolder dbFolder, String eltName) throws IOException {
        if (dbFolder != null) {
            if (eltName != null) {
                out.append("<").append(eltName);
            }
            out.append(" ").append("refID").append("='").append(Long.toString(dbFolder.getID())).append("'");
            DBObjectXmlUtility.appendXML(out.append(" ").append("refPath").append("='"), dbFolder.getRefPath()).append("'");
            if (eltName != null) {
                out.append("/>\n");
            }
        }
    }

    public static void writeDBFolder(Appendable out, DBFolder dbFolder, String eltName, boolean withID) throws IOException {
        if (dbFolder != null) {
            if (eltName != null) {
                out.append("<").append(eltName);
            }
            if (withID) {
                out.append(" ").append("refID").append("='").append(Long.toString(dbFolder.getID())).append("'");
            } else {
                out.append(" ").append("refID").append("='-1'");
            }
            DBObjectXmlUtility.appendXML(out.append(" ").append("refPath").append("='"), dbFolder.getRefPath()).append("'");
            if (eltName != null) {
                out.append("/>\n");
            }
        }
    }

    public static void writeAttrColor(Appendable out, String name, boolean opaque, Color color) throws IOException {
        out.append(" ").append(name).append("='");
        if (!opaque) {
            out.append("null");
        } else {
            out.append("rgb(").append(Integer.toString(color.getRed()));
            out.append(",").append(Integer.toString(color.getGreen()));
            out.append(",").append(Integer.toString(color.getBlue()));
            out.append(")");
        }
        out.append("'");
    }

    public static Color readColor(String value) {
        return DBObjectXmlUtility.readColor(value, false);
    }

    public static Color readColor(String value, boolean opt) throws IllegalArgumentException {
        if (opt) {
            if (value.equals("false")) {
                return null;
            }
            if (value.equals("null")) {
                return null;
            }
        }
        if (value.equals("true")) {
            return Color.black;
        }
        if (value.startsWith("rgb(")) {
            StringTokenizer st = new StringTokenizer(value.substring(4), ",)");
            if (st.countTokens() == 3) {
                try {
                    int r = Integer.parseInt(st.nextToken());
                    int g = Integer.parseInt(st.nextToken());
                    int b = Integer.parseInt(st.nextToken());
                    if (r < 0) {
                        r = 0;
                    } else if (r > 255) {
                        r = 255;
                    }
                    if (g < 0) {
                        g = 0;
                    } else if (g > 255) {
                        g = 255;
                    }
                    if (b < 0) {
                        b = 0;
                    } else if (b > 255) {
                        b = 255;
                    }
                    return new Color(r, g, b);
                }
                catch (NumberFormatException nfe) {
                    _LOG.log(Level.WARNING, "Error during convert String To Color: " + value, nfe);
                    throw nfe;
                }
            }
        } else {
            if (value.startsWith("0x")) {
                try {
                    int codeRBG = Integer.parseInt(value.substring(2), 16);
                    if (codeRBG == -1) {
                        codeRBG = 0;
                    }
                    return new Color(codeRBG);
                }
                catch (NumberFormatException nfe) {
                    _LOG.log(Level.WARNING, "Error during convert String To Color: " + value, nfe);
                    throw nfe;
                }
            }
            if (value.length() == 9) {
                try {
                    int r = Integer.parseInt(value.substring(0, 3));
                    int g = Integer.parseInt(value.substring(3, 6));
                    int b = Integer.parseInt(value.substring(6, 9));
                    if (r < 0) {
                        r = 0;
                    } else if (r > 255) {
                        r = 255;
                    }
                    if (g < 0) {
                        g = 0;
                    } else if (g > 255) {
                        g = 255;
                    }
                    if (b < 0) {
                        b = 0;
                    } else if (b > 255) {
                        b = 255;
                    }
                    return new Color(r, g, b);
                }
                catch (NumberFormatException nfe) {
                    _LOG.log(Level.WARNING, "Error during convert String To Color: " + value, nfe);
                    throw nfe;
                }
            }
        }
        throw new IllegalArgumentException("Color format unknown: " + value);
    }

    public static void appendXMLHeader(Appendable out) throws IOException {
        out.append("<?xml version='1.0'?>\n");
    }
}

