/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib;

import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public interface Attr {
    public static final String XML_ATTR_TYPE = "type";
    public static final String XML_ATTR_NAME = "name";
    public static final String XML_ATTR_OP = "op";
    public static final String XML_ATTR_DATA = "data";

    public Key getKey();

    public Object getValue();

    public static class DefaultKey
    implements Key {
        AttrType _type;
        String _name;

        public DefaultKey(AttrType type, String name) {
            this._type = type;
            this._name = name;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this._name).append(" {");
            switch (this._type) {
                case ALIAS: {
                    buffer.append("a");
                    break;
                }
                case ENUM: {
                    buffer.append("e");
                    break;
                }
                case FIELD: {
                    buffer.append("f");
                    break;
                }
                case NUMBER: {
                    buffer.append("n");
                    break;
                }
                case STRING: {
                    buffer.append("s");
                }
            }
            buffer.append("}");
            return buffer.toString();
        }

        public int hashCode() {
            return this._type.hashCode() * 17 + this._name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            if (this._type != key.getType()) {
                return false;
            }
            return this._name.equals(key.getName());
        }

        @Override
        public int compareTo(Key o) {
            int cmp = this._type.ordinal() - o.getType().ordinal();
            if (cmp != 0) {
                return cmp;
            }
            return this._name.compareTo(o.getName());
        }

        @Override
        public AttrType getType() {
            return this._type;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public static void saveToXML(Key attr, Appendable output) throws IOException {
            output.append(" name='").append(XMLWriter.toXML((String)attr.getName())).append("'");
            output.append(" type='").append(XMLWriter.toXML((String)attr.getType().toString())).append("'");
        }

        public static Key loadFromXML(Element xmlElt) throws SAXException, IOException {
            String attrName = xmlElt.getAttribute(Attr.XML_ATTR_NAME);
            String attrType = xmlElt.getAttribute(Attr.XML_ATTR_TYPE);
            AttrType type = AttrType.valueOf(attrType);
            if (type == null) {
                throw new SAXException("Value of attribute 'type' unknown : " + attrType + " !");
            }
            return new DefaultKey(type, attrName);
        }
    }

    public static interface Key
    extends Comparable<Key> {
        public AttrType getType();

        public String getName();

        public static boolean containsAttribut(Map<? extends Key, Set<String>> attrs, Key attr) {
            boolean find = false;
            for (Key key : attrs.keySet()) {
                if (key.getType() != attr.getType() || !key.getName().equals(attr.getName())) continue;
                find = true;
                break;
            }
            return find;
        }

        public static Key findAttribut(Map<? extends Key, Set<String>> attrs, Key attr) {
            for (Key key : attrs.keySet()) {
                if (key.getType() != attr.getType() || !key.getName().equals(attr.getName())) continue;
                return key;
            }
            return null;
        }
    }
}

