/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib;

import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBAttribUtility {
    private static final Pattern PATTERN_PATH_OLD = Pattern.compile("([^\\[;]+)(([;]([0-9]+))|\\[([0-9]+)\\])?");
    private static final Pattern PATTERN_FORMAT_OLD_OLD = Pattern.compile("('([^']+)')(\\s)*(.*)");
    private static final Pattern PATTERN_FORMAT_OLD = Pattern.compile("([^=]*)(=(.*))?");

    public static String checkPath(String path) {
        String dbPath = null;
        Matcher matcher = PATTERN_PATH_OLD.matcher(path);
        if (matcher.matches()) {
            dbPath = matcher.group(1);
            String dbVersion = matcher.group(3) != null ? matcher.group(4) : matcher.group(5);
            if (dbVersion == null) {
                return dbPath;
            }
            return new StringBuilder(dbPath.length() + 16).append(dbPath).append("/").append(dbVersion).toString();
        }
        return null;
    }

    public static Attr checkEventAttribute(String description) {
        Matcher matcher;
        String value = null;
        String dbPath = null;
        if (dbPath == null && (matcher = PATTERN_FORMAT_OLD_OLD.matcher(description)).matches()) {
            dbPath = matcher.group(2);
            value = matcher.group(4);
            if (value.isEmpty()) {
                value = null;
            }
        }
        if (dbPath == null && (matcher = PATTERN_FORMAT_OLD.matcher(description)).matches()) {
            dbPath = matcher.group(1);
            value = matcher.group(3);
        }
        if (dbPath == null) {
            return null;
        }
        if ((dbPath = DBAttribUtility.checkPath(dbPath)) == null) {
            return null;
        }
        return new CheckAttr(dbPath, value);
    }

    private static class CheckAttr
    implements Attr,
    Attr.Key {
        String _dbPath;
        String _value;

        CheckAttr(String dbPath, String value) {
            this._dbPath = dbPath;
            this._value = value;
        }

        @Override
        public Attr.Key getKey() {
            return this;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public int compareTo(Attr.Key o) {
            return 0;
        }

        @Override
        public AttrType getType() {
            return this._value == null ? AttrType.ALIAS : AttrType.STRING;
        }

        @Override
        public String getName() {
            return this._dbPath;
        }
    }
}

