/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AttributeCriterionPanel
extends JPanel {
    Map<? extends Attr.Key, Set<String>> _attributes;
    Attr.Key[] _keys;
    private static final String VALUE_LAYOUT_ENUMS = "Ctr.Value.Layout.Enums";
    private static final String VALUE_LAYOUT_INPUT = "Ctr.Value.Layout.Input";
    JComboBox _ctrlNames;
    JLabel _ctrlType;
    JComboBox _ctrlOperators;
    JPanel _ctrlValue;
    CardLayout _ctrlValueLayout;
    JComboBox _ctrlValueEnums;
    JTextField _ctrlValueInput;
    boolean _isEditable = true;

    public AttributeCriterionPanel(Map<? extends Attr.Key, Set<String>> attributes) {
        super(new GridBagLayout());
        this.create();
        if (attributes != null) {
            this.setAttributes(attributes);
        }
    }

    public void setAttributes(Map<? extends Attr.Key, Set<String>> attributes) {
        this._attributes = attributes;
        this._keys = new Attr.Key[this._attributes.size()];
        int idx = 0;
        for (Attr.Key key : this._attributes.keySet()) {
            this._keys[idx++] = key;
        }
        Arrays.sort(this._keys);
        this._ctrlNames.setModel(new DefaultComboBoxModel<Attr.Key>(this._keys));
        if (this._ctrlNames.getItemCount() > 0) {
            this._ctrlNames.setSelectedIndex(0);
        }
    }

    public final String getNameValue() {
        return this._ctrlNames.getSelectedItem().toString();
    }

    private void create() {
        this._ctrlNames = new JComboBox();
        this._ctrlNames.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Attr.Key key = (Attr.Key)value;
                if (key != null) {
                    this.setText(key.getName());
                }
                return this;
            }
        });
        this._ctrlNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeCriterionPanel.this.changeAttribute();
            }
        });
        this._ctrlType = new JLabel(ResMsgVoc.getString("VOC_STRING"));
        this._ctrlOperators = new JComboBox();
        this._ctrlOperators.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                AttrCriterion.Operator op = (AttrCriterion.Operator)((Object)value);
                if (op != null) {
                    this.setText(op.getLabel());
                }
                return this;
            }
        });
        this._ctrlValueLayout = new CardLayout();
        this._ctrlValue = new JPanel(this._ctrlValueLayout);
        this._ctrlValueEnums = new JComboBox();
        this._ctrlValue.add((Component)this._ctrlValueEnums, VALUE_LAYOUT_ENUMS);
        this._ctrlValueInput = new JTextField();
        this._ctrlValue.add((Component)this._ctrlValueInput, VALUE_LAYOUT_INPUT);
        this._ctrlValueInput.setEditable(true);
        Insets stdInsets = new Insets(2, 2, 2, 2);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, stdInsets, 0, 0);
        this.add((Component)new JLabel(ResMsgVoc.getString("VOC_ATTRIBUTE")), constraints);
        ++constraints.gridy;
        this.add((Component)new JLabel(ResMsgObj.getString("ATTRIBUTE_TYPE")), constraints);
        ++constraints.gridy;
        this.add((Component)new JLabel(ResMsgObj.getString("ATTRIBUTE_OPERATOR")), constraints);
        ++constraints.gridy;
        this.add((Component)new JLabel(ResMsgObj.getString("ATTRIBUTE_VALUE")), constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, stdInsets, 0, 0);
        this.add((Component)this._ctrlNames, constraints);
        ++constraints.gridy;
        this.add((Component)this._ctrlType, constraints);
        ++constraints.gridy;
        this.add((Component)this._ctrlOperators, constraints);
        ++constraints.gridy;
        this.add((Component)this._ctrlValue, constraints);
    }

    private void changeAttribute() {
        Attr.Key key = (Attr.Key)this._ctrlNames.getSelectedItem();
        if (key == null) {
            this._ctrlType.setText("");
            this._ctrlOperators.setSelectedItem(null);
            this._ctrlValueEnums.setSelectedItem(null);
            this._ctrlValueInput.setText("");
            return;
        }
        this._ctrlType.setText(key.getType().getLabel());
        AttrCriterion.Operator op = (AttrCriterion.Operator)((Object)this._ctrlOperators.getSelectedItem());
        this._ctrlOperators.removeAllItems();
        switch (key.getType()) {
            case ALIAS: {
                break;
            }
            case ENUM: {
                this._ctrlOperators.addItem(AttrCriterion.Operator.EQ);
                this._ctrlOperators.addItem(AttrCriterion.Operator.NEQ);
                break;
            }
            case STRING: {
                this._ctrlOperators.addItem(AttrCriterion.Operator.EQ);
                this._ctrlOperators.addItem(AttrCriterion.Operator.NEQ);
                this._ctrlOperators.addItem(AttrCriterion.Operator.MATCH);
                break;
            }
            case NUMBER: {
                this._ctrlOperators.addItem(AttrCriterion.Operator.EQ);
                this._ctrlOperators.addItem(AttrCriterion.Operator.NEQ);
                this._ctrlOperators.addItem(AttrCriterion.Operator.GEQ);
                this._ctrlOperators.addItem(AttrCriterion.Operator.GT);
                this._ctrlOperators.addItem(AttrCriterion.Operator.LEQ);
                this._ctrlOperators.addItem(AttrCriterion.Operator.LT);
            }
        }
        if (op != null) {
            int idxSelect = -1;
            for (int i = this._ctrlOperators.getItemCount() - 1; i >= 0; --i) {
                if (this._ctrlOperators.getItemAt(i) != op) continue;
                idxSelect = i;
                break;
            }
            if (idxSelect != -1) {
                this._ctrlOperators.setSelectedIndex(idxSelect);
            }
        }
        if (key.getType() == AttrType.ENUM) {
            this._ctrlValueLayout.show(this._ctrlValue, VALUE_LAYOUT_ENUMS);
            this._ctrlValueEnums.removeAllItems();
            ArrayList<String> listValuesEnum = (ArrayList<String>)((Object)this._attributes.get(key));
            if (listValuesEnum == null || listValuesEnum.isEmpty() && key instanceof DBAttrib) {
                listValuesEnum = ((DBAttrib)key).getEnums();
            }
            for (String value : listValuesEnum) {
                this._ctrlValueEnums.addItem(value);
            }
            if (this._ctrlValueEnums.getItemCount() > 0) {
                this._ctrlValueEnums.setSelectedIndex(0);
            }
        } else {
            this._ctrlValueLayout.show(this._ctrlValue, VALUE_LAYOUT_INPUT);
        }
        if (key.getType() == AttrType.ALIAS) {
            this._ctrlOperators.setEnabled(false);
            this._ctrlValueEnums.setEnabled(false);
            this._ctrlValueInput.setEnabled(false);
            this._ctrlValueInput.setEditable(false);
        } else {
            this._ctrlOperators.setEnabled(true);
            this._ctrlValueEnums.setEnabled(true);
            this._ctrlValueInput.setEnabled(true);
            this._ctrlValueInput.setEditable(true);
        }
    }

    private boolean doVerifyParameters() {
        Attr.Key key = (Attr.Key)this._ctrlNames.getSelectedItem();
        if (key == null) {
            return false;
        }
        if (key.getType() == AttrType.ALIAS) {
            return true;
        }
        if (this._ctrlOperators.getSelectedItem() == null) {
            return false;
        }
        switch (key.getType()) {
            case ENUM: {
                if (this._ctrlValueEnums.getSelectedItem() != null) break;
                return false;
            }
            case NUMBER: {
                try {
                    Double.parseDouble(this._ctrlValueInput.getText());
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case STRING: {
                String txt = this._ctrlValueInput.getText().trim();
                if (txt.length() == 0) {
                    return false;
                }
                if (!this._ctrlOperators.getSelectedItem().equals((Object)AttrCriterion.Operator.MATCH)) break;
                try {
                    Pattern.compile(txt);
                    break;
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean verifyParameters() {
        return this.doVerifyParameters();
    }

    public void setCurrentAttributeCriterion(AttrCriterion criterion) {
        if (criterion == null) {
            this._ctrlNames.setSelectedItem(null);
            return;
        }
        Attr.Key key = criterion.getKey();
        if (!Attr.Key.containsAttribut(this._attributes, key)) {
            this._ctrlNames.setSelectedItem(null);
            return;
        }
        this._ctrlNames.setSelectedItem(key);
        this._ctrlOperators.setSelectedItem((Object)criterion.getOperator());
        switch (key.getType()) {
            case ALIAS: {
                break;
            }
            case ENUM: {
                this._ctrlValueEnums.setSelectedItem(criterion.getData());
                break;
            }
            default: {
                this._ctrlValueInput.setText(criterion.getData());
            }
        }
        if (this._ctrlNames.isEnabled()) {
            this._ctrlNames.requestFocus();
        } else {
            this._ctrlOperators.requestFocus();
        }
    }

    public AttrCriterion getCurrentAttributeCriterion() {
        if (!this.verifyParameters()) {
            return null;
        }
        Attr.Key key = (Attr.Key)this._ctrlNames.getSelectedItem();
        AttrCriterion.Operator op = (AttrCriterion.Operator)((Object)this._ctrlOperators.getSelectedItem());
        switch (key.getType()) {
            case ALIAS: {
                return new AttrCriterion(key, null, null);
            }
            case ENUM: {
                return new AttrCriterion(key, op, (String)this._ctrlValueEnums.getSelectedItem());
            }
        }
        return new AttrCriterion(key, op, this._ctrlValueInput.getText());
    }

    public void setEditable(boolean editable) {
        if (this._isEditable == editable) {
            return;
        }
        this._isEditable = editable;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof JLabel)) continue;
            comp.setEnabled(editable);
        }
        Attr.Key key = (Attr.Key)this._ctrlNames.getSelectedItem();
        boolean isAlias = key != null && key.getType() == AttrType.ALIAS;
        this._ctrlNames.setEnabled(editable);
        this._ctrlType.setEnabled(editable);
        this._ctrlOperators.setEnabled(editable && !isAlias);
        this._ctrlValueEnums.setEnabled(editable && !isAlias);
        this._ctrlValueInput.setEnabled(editable && !isAlias);
        this._ctrlValueInput.setEditable(editable && !isAlias);
    }
}

