/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.attrib.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.io.SAXLogHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBAttribHandlerXml
extends SAXLogHandler
implements DBObjectXmlConstant {
    public static final String ELT_CEC_ATTRIBUTE = "cec.attribute";
    public static final String ELT_ATTRIBUTE_ENUM = "attribute.enum";
    AttrType _type;
    List<String> _enums;

    public DBAttribHandlerXml(DBLogs.DBLogsManager logMng, Locator locator) {
        super(logMng);
        if (locator != null) {
            this.setLocator(locator);
        }
    }

    public AttrType getType() {
        return this._type;
    }

    public List<String> getEnums() {
        return this._enums;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            String type;
            if (!ELT_CEC_ATTRIBUTE.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_CEC_ATTRIBUTE), this.getLocator()));
            }
            if ((type = attrs.get("type")) == null || type.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", ELT_CEC_ATTRIBUTE, "type"), this.getLocator()));
            }
            this._type = (AttrType)DBAttribHandlerXml.valueOfEnum(AttrType.class, (String)type.toUpperCase());
            if (this._type == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", ELT_CEC_ATTRIBUTE, "type", type), this.getLocator()));
            }
            this._enums = this._type == AttrType.ENUM ? new ArrayList<String>() : null;
        } else if (ELT_ATTRIBUTE_ENUM.equals(key)) {
            if (this._type != AttrType.ENUM) {
                this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIB_XML_ENUM_ERR", ELT_ATTRIBUTE_ENUM), this.getLocator()));
            } else {
                String name = attrs.get("name");
                if (name == null || name.isEmpty()) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", ELT_ATTRIBUTE_ENUM, "name"), this.getLocator()));
                }
                if (this._enums.contains(name)) {
                    this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_ERR_DBMOD_ATTRIB_XML_ENUM_CONTAIN", name), this.getLocator()));
                } else {
                    this._enums.add(name);
                }
            }
        } else {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ELEMENT_UNKNOWN", key, this.getClass().getName()), this.getLocator()));
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXParseException {
        return ELT_CEC_ATTRIBUTE.equals(name);
    }
}

