/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.conflict;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.conflict.DBConflict;
import com.dassault.cecilia.dbobj.general.conflict.DBConflictChoice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class DBConflictsChoiceDlg<T>
extends JDialogCecilia {
    ArrayList<? extends DBConflictChoice<T>> _conflicts;
    DBConfictChoiceTableModel _ctrlTableModel;
    JComboBox _ctrlChoice;
    JLabel _ctrlLabel;

    public DBConflictsChoiceDlg(Component owner, ArrayList<? extends DBConflictChoice<T>> conflicts) {
        this(owner, ResMsgObj.getString("TITLE_CONFLICT"), conflicts);
    }

    public DBConflictsChoiceDlg(Component owner, String title, ArrayList<? extends DBConflictChoice<T>> conflicts) {
        super(SwingUtilities.getWindowAncestor(owner), title, true);
        this._conflicts = conflicts;
        this._ctrlTableModel = new DBConfictChoiceTableModel();
        this.make();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    protected abstract String getNameOfItem();

    protected abstract TableCellRenderer getRendererOfItem();

    private void make() {
        this._ctrlLabel = new JLabel(ResMsgObj.msgFormat("MSG_CONFLICT_QUESTION", this._conflicts.size()));
        this._ctrlChoice = new JComboBox<DBConflict>(DBConflict.values());
        Dimension size = this._ctrlChoice.getPreferredSize();
        size.width = size.width * 12 / 10;
        this._ctrlChoice.setPreferredSize(size);
        this._ctrlChoice.setRenderer(DBConflict.getListCellRenderer());
        JTable ctrlTable = new JTable(this._ctrlTableModel);
        TableColumnModel colModel = ctrlTable.getTableHeader().getColumnModel();
        ctrlTable.setDefaultRenderer(DBConflict.class, DBConflict.getTableCellRenderer());
        ctrlTable.setDefaultEditor(DBConflict.class, new DefaultCellEditor(this._ctrlChoice));
        colModel.getColumn(0).setPreferredWidth(250);
        colModel.getColumn(1).setPreferredWidth(100);
        TableCellRenderer itemRenderer = this.getRendererOfItem();
        if (itemRenderer != null) {
            colModel.getColumn(0).setCellRenderer(itemRenderer);
        }
        ctrlTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._ctrlLabel, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane(ctrlTable), new GridBagConstraints(0, 1, 1, 1, 100.0, 100.0, 21, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.init();
        this.pack();
    }

    public void setConflicts(ArrayList<? extends DBConflictChoice<T>> conflicts) {
        this._ctrlLabel.setText(ResMsgObj.msgFormat("MSG_CONFLICT_QUESTION", conflicts.size()));
        this._conflicts = conflicts;
        this._ctrlTableModel.fireTableChanged(new TableModelEvent(this._ctrlTableModel));
    }

    @Override
    protected boolean verifyParameters() {
        return true;
    }

    class DBConfictChoiceTableModel
    implements TableModel {
        ArrayList<TableModelListener> _listeners = new ArrayList();

        DBConfictChoiceTableModel() {
        }

        @Override
        public int getRowCount() {
            return DBConflictsChoiceDlg.this._conflicts.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return DBConflictsChoiceDlg.this.getNameOfItem();
            }
            return ResMsgVoc.getString("VOC_CONFLICT");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Object.class;
            }
            return DBConflict.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return DBConflictsChoiceDlg.this._conflicts.get(rowIndex).getItem();
            }
            return DBConflictsChoiceDlg.this._conflicts.get(rowIndex).getConfict();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1 && aValue instanceof DBConflict) {
                DBConflictsChoiceDlg.this._conflicts.get(rowIndex).setConflict((DBConflict)((Object)aValue));
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (!this._listeners.contains(l)) {
                this._listeners.add(l);
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this._listeners.remove(l);
        }

        public void fireTableChanged(TableModelEvent evt) {
            for (TableModelListener l : this._listeners) {
                l.tableChanged(evt);
            }
        }
    }
}

