/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.event;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.io.DBAttributesHandlerXml;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Event {
    public static final float MAX_PERIODICITY_VAUE = 9.8765434E8f;
    public static final String EVENT_MODIFIER_INSPECTED = "inspected";
    public static final String EVENT_MODIFIER_EXPOSED = "exposed";
    public static final String PROP_EVENT_MODIFIER_TYPE = "cecilia.event.DistribModifierType";
    public static final String PROP_EVENT_MODIFIER_VALUE = "cecilia.event.DistribModifierValue";
    public static final String PROP_EVENT_ATTRIBUTE_WRITE51 = "cecilia.event.WriteAttributeCecilia51";
    private static Logger _LOG = Logger.getLogger(Event.class.getPackage().getName());
    private Law _law = null;
    private Param _inspected = null;
    private Param _inflight_tested = null;
    private DBModelLaw _dbModelLaw = null;
    private Map<DBAttrib, DBAttrib.Value> _attributes = new LinkedHashMap<DBAttrib, DBAttrib.Value>();
    private static boolean __LOG_FFT1398_ATTR_UNKNOWN = true;

    public void initialise(CeciliaAppl appl) {
        String defaultModifier;
        String defaultAttribute = System.getProperty("cecilia.attribute.DefaultName");
        if (defaultAttribute != null && (defaultAttribute = defaultAttribute.trim()).length() != 0) {
            DBWrap dbWrap;
            DBAttrib dbAttrib = null;
            DBFolder dbFolder = appl.getDAOFactory().createFolderDAO().findFolder("ATTRIBUTES", defaultAttribute);
            if (dbFolder != null && (dbWrap = appl.getDAOFactory().findOrCreateWrap(dbFolder)) != null) {
                dbAttrib = (DBAttrib)dbWrap;
            }
            if (dbAttrib == null) {
                if (__LOG_FFT1398_ATTR_UNKNOWN) {
                    _LOG.warning("Default attribute '" + defaultAttribute + "' is unknown in current database.");
                    __LOG_FFT1398_ATTR_UNKNOWN = false;
                }
            } else {
                String defaultValue = System.getProperty("cecilia.attribute.DefaultValue");
                if (defaultValue != null && (defaultValue = defaultValue.trim()).length() != 0) {
                    DBAttrib.Value dbValue = dbAttrib.createInstance(defaultValue);
                    if (dbValue == null) {
                        if (__LOG_FFT1398_ATTR_UNKNOWN) {
                            _LOG.warning("Default value '" + defaultValue + "' is no compatible with default attribute '" + defaultAttribute + "'.");
                            __LOG_FFT1398_ATTR_UNKNOWN = false;
                        }
                    } else {
                        this.addAttribute(dbValue);
                    }
                }
            }
        }
        if ((defaultModifier = System.getProperty(PROP_EVENT_MODIFIER_TYPE, EVENT_MODIFIER_INSPECTED)) != null) {
            if (EVENT_MODIFIER_INSPECTED.equalsIgnoreCase(defaultModifier = defaultModifier.trim())) {
                double value = Double.NaN;
                try {
                    defaultValue = System.getProperty(PROP_EVENT_MODIFIER_VALUE, Float.toString(9.8765434E8f));
                    value = Double.parseDouble(defaultValue);
                }
                catch (Exception defaultValue) {
                    // empty catch block
                }
                if (!Double.isNaN(value)) {
                    this.setInspected(new ParamValue(TypeParam.DELAY, value));
                }
            } else if (EVENT_MODIFIER_EXPOSED.equalsIgnoreCase(defaultModifier)) {
                double value = Double.NaN;
                try {
                    defaultValue = System.getProperty(PROP_EVENT_MODIFIER_VALUE);
                    value = Double.parseDouble(defaultValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!Double.isNaN(value)) {
                    this.setInflightTested(new ParamValue(TypeParam.DELAY, value));
                }
            }
        }
    }

    public abstract String getLabel();

    public abstract void setLabel(String var1);

    protected void copy(Event src) {
        if (src.getModelLaw() != null) {
            this.setModelLaw(src.getModelLaw());
        } else {
            this.setModelLaw(null);
            this.setOccurrence(null);
        }
        if (src.getOccurrence() != null) {
            this.setOccurrence(src.getOccurrence().getCopy());
        } else {
            this.setOccurrence(null);
        }
        if (src.getInspected() != null) {
            this.setInspected(src.getInspected().getCopy());
        } else {
            this.setInspected(null);
        }
        if (src.getInflightTested() != null) {
            this.setInflightTested(src.getInflightTested().getCopy());
        } else {
            this.setInflightTested(null);
        }
        this.setAttributes(src.getAttributes());
    }

    public Law getOccurrence() {
        return this._law;
    }

    public boolean setOccurrence(Law law) {
        this._law = law;
        if (this._law == null) {
            return true;
        }
        if (law.getManager().isInspectedCompatible(law)) {
            return true;
        }
        if (this.isInspected()) {
            this._inspected = null;
            return false;
        }
        if (this.isInflightTested()) {
            this._inflight_tested = null;
            return false;
        }
        return true;
    }

    public Param getInspected() {
        return this._inspected;
    }

    public boolean isInspected() {
        return this._inspected != null;
    }

    public boolean setInspected(Param value) {
        Law law;
        if (value != null && (law = this.getLaw()) != null && !law.getManager().isInspectedCompatible(law)) {
            return false;
        }
        this._inspected = value;
        return true;
    }

    public Param getInflightTested() {
        return this._inflight_tested;
    }

    public boolean isInflightTested() {
        return this._inflight_tested != null;
    }

    public boolean setInflightTested(Param value) {
        Law law;
        if (value != null && (law = this.getLaw()) != null && !law.getManager().isInspectedCompatible(law)) {
            return false;
        }
        this._inflight_tested = value;
        return true;
    }

    public DBModelLaw getModelLaw() {
        return this._dbModelLaw;
    }

    public boolean setModelLaw(DBModelLaw dbModelLaw) {
        if (dbModelLaw == null && this._dbModelLaw != null) {
            this._law = this._dbModelLaw.getLaw().getCopy();
        }
        this._dbModelLaw = dbModelLaw;
        if (dbModelLaw != null) {
            Law law = dbModelLaw.getLaw();
            if (law.getManager().isInspectedCompatible(law)) {
                return true;
            }
            if (this.isInspected()) {
                this._inspected = null;
                return false;
            }
            if (this.isInflightTested()) {
                this._inflight_tested = null;
                return false;
            }
        }
        return true;
    }

    public Set<Param> recupParams(Set<Param> result, FctParamSelect fctSelect) {
        Law law = this.getLaw();
        if (law != null) {
            law.recupParams(result, fctSelect);
        }
        if (this._inspected != null) {
            this._inspected.recupParams(result, fctSelect);
        }
        if (this._inflight_tested != null) {
            this._inflight_tested.recupParams(result, fctSelect);
        }
        return result;
    }

    public Law getLaw() {
        DBModelLaw dbModelLaw = this.getModelLaw();
        if (dbModelLaw != null) {
            return dbModelLaw.getLaw();
        }
        return this._law;
    }

    public Collection<DBAttrib.Value> getAttributes() {
        return this._attributes.values();
    }

    public void setAttributes(Collection<DBAttrib.Value> attributes) {
        this._attributes.clear();
        for (DBAttrib.Value value : attributes) {
            this._attributes.put(value.getKey(), value);
        }
    }

    public DBAttrib.Value getAttribute(DBAttrib dbAttrib) {
        if (dbAttrib == null) {
            throw new NullPointerException();
        }
        return this._attributes.get(dbAttrib);
    }

    public void addAttribute(DBAttrib.Value dbAttrValue) {
        if (dbAttrValue == null) {
            throw new NullPointerException();
        }
        this._attributes.put(dbAttrValue.getKey(), dbAttrValue);
    }

    public void delAttribute(DBAttrib.Value dbAttrValue) {
        if (dbAttrValue == null) {
            throw new NullPointerException();
        }
        this._attributes.remove(dbAttrValue.getKey());
    }

    public int getAttributeCount() {
        return this._attributes.size();
    }

    public void removeAllAttributes() {
        if (this._attributes.size() != 0) {
            this._attributes.clear();
        }
    }

    public void clearProperties() {
        this._law = null;
        this._inspected = null;
        this._inflight_tested = null;
        if (this._attributes.size() != 0) {
            this._attributes.clear();
        }
    }

    public boolean compareProperties(Event event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (!this.compareInspected(event)) {
            return false;
        }
        if (!this.compareInflightTested(event)) {
            return false;
        }
        if (!this.compareOccurence(event)) {
            return false;
        }
        if (this._attributes.size() != event.getAttributeCount()) {
            return false;
        }
        for (DBAttrib keyAttrib : this._attributes.keySet()) {
            DBAttrib.Value otherValue = event.getAttribute(keyAttrib);
            if (otherValue == null) {
                return false;
            }
            if (otherValue.compareTo(this._attributes.get(keyAttrib)) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean compareOccurence(Event event) {
        Law otherLaw = event.getOccurrence();
        if (this._law == null) {
            return otherLaw == null;
        }
        if (otherLaw == null) {
            return this._law == null;
        }
        return this._law.equals(otherLaw);
    }

    public boolean compareInspected(Event event) {
        Param otherParam = event.getInspected();
        if (this._inspected == null) {
            return otherParam == null;
        }
        if (otherParam == null) {
            return this._inspected == null;
        }
        return this._inspected.equals(otherParam);
    }

    public boolean compareInflightTested(Event event) {
        Param otherParam = event.getInflightTested();
        if (this._inflight_tested == null) {
            return otherParam == null;
        }
        if (otherParam == null) {
            return this._inflight_tested == null;
        }
        return this._inflight_tested.equals(otherParam);
    }

    public String getAttributesAsDisplayedString() {
        StringBuilder buf = new StringBuilder();
        Iterator<DBAttrib.Value> iterAttrib = this._attributes.values().iterator();
        while (iterAttrib.hasNext()) {
            DBAttrib.Value dbValue = iterAttrib.next();
            dbValue.appendDisplay(buf);
            if (!iterAttrib.hasNext()) continue;
            buf.append("; ");
        }
        return buf.toString();
    }

    protected void toXML_Content(Appendable out, String indent0, String comment, boolean withID) throws IOException {
        String indent1 = indent0 + "  ";
        String indent2 = indent1 + "  ";
        if (comment != null && !comment.isEmpty()) {
            out.append(indent1).append("<").append("label").append(">");
            DBObjectXmlUtility.appendXML(out, comment);
            out.append("</").append("label").append(">\n");
        }
        if (this._dbModelLaw != null && this._dbModelLaw.getDBFolder() != null) {
            out.append(indent1);
            DBObjectXmlUtility.writeDBFolder(out, this._dbModelLaw.getDBFolder(), "frb");
        }
        if (this._law != null) {
            this._law.toXML("law", out, indent1, withID);
        }
        if (this._inspected != null) {
            out.append(indent1).append("<").append(EVENT_MODIFIER_INSPECTED).append(">\n");
            this._inspected.toXML(out, indent2, withID);
            out.append(indent1).append("</").append(EVENT_MODIFIER_INSPECTED).append(">\n");
        }
        if (this._inflight_tested != null) {
            out.append(indent1).append("<").append("inflight").append(">\n");
            this._inflight_tested.toXML(out, indent2, withID);
            out.append(indent1).append("</").append("inflight").append(">\n");
        }
        if (!this._attributes.isEmpty()) {
            DBAttributesHandlerXml.writeAttributes(out, this._attributes.values(), indent1);
        }
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        if (this._dbModelLaw != null && this._dbModelLaw.getDBFolder() != null) {
            relations.add(new DBRelation(dbSrcFolder, typeSrcRelation, this._dbModelLaw.getDBFolder(), "LAW_MODEL"));
        }
        if (this._law != null) {
            this._law.addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
        if (this._inspected != null) {
            this._inspected.addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
        if (this._inflight_tested != null) {
            this._inflight_tested.addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
        for (DBAttrib.Value attribValue : this.getAttributes()) {
            relations.add(new DBRelation(dbSrcFolder, typeSrcRelation, attribValue.getKey().getDBFolder(), "ATTRIBUTE"));
        }
    }

    public void update(CECFactory cecFactory, DBLogs.DBLogsManager logMng, String name) {
        Collection<DBAttrib.Value> updateAttrib;
        Param param;
        if (this._dbModelLaw != null && this._dbModelLaw.getDBFolder() != null) {
            DBWrap dbWrap = DBWrap.createOrFind(cecFactory, this._dbModelLaw.getDBFolder(), logMng, DBModelLaw.class);
            if (dbWrap == null) {
                this._law = this._dbModelLaw.getLaw().getCopy();
            }
            this._dbModelLaw = (DBModelLaw)dbWrap;
        }
        if (this._law != null) {
            this._law = this._law.update(cecFactory, logMng, name);
        }
        if (this._inspected != null) {
            param = this._inspected.update(cecFactory, logMng, name);
            if (param != null && param.getType() != TypeParam.DELAY) {
                logMng.addLog(DBLogs.DBLevel.WARNING, name + " - " + ResMsgCore.msgFormat("PAR_ERR_TYPE_MODIFIER_FRM", ResMsgVoc.getString("VOC_INSPECTED"), TypeParam.DELAY.getLabel(), param.toString()));
                param = new ParamValue(TypeParam.DELAY, cecFactory.getLawManager().evaluate(this._inspected));
            }
            this._inspected = param;
        }
        if (this._inflight_tested != null) {
            param = this._inflight_tested.update(cecFactory, logMng, name);
            if (param != null && param.getType() != TypeParam.DELAY) {
                logMng.addLog(DBLogs.DBLevel.WARNING, name + " - " + ResMsgCore.msgFormat("PAR_ERR_TYPE_MODIFIER_FRM", ResMsgVoc.getString("VOC_INFLIGHT_TESTED"), TypeParam.DELAY.getLabel(), param.toString()));
                param = new ParamValue(TypeParam.DELAY, cecFactory.getLawManager().evaluate(this._inflight_tested));
            }
            this._inflight_tested = param;
        }
        if (!(updateAttrib = this.getAttributes()).isEmpty()) {
            updateAttrib = DBAttrib.update(updateAttrib, cecFactory, logMng, name);
            this.setAttributes(updateAttrib);
        }
    }

    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        if (this.getModelLaw() != null) {
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_FRB"), this.getModelLaw().getRefPath()));
        }
        if (this.getLaw() != null) {
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_LAW"), this.getLaw().toString()));
        }
        if (this.isInspected()) {
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_INSPECTED"), this.getInspected().getFieldsCompare()));
        }
        if (this.isInflightTested()) {
            sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_INFLIGHT_TESTED"), this.getInflightTested().getFieldsCompare()));
        }
        sb.append(this.getAttributesAsDisplayedString());
        return sb.toString();
    }
}

