/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.icon.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.icon.gui.IconPanelPreview;
import com.dassault.cecilia.dbobj.general.icon.gui.IconPanelTree;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class IconPanelCtrl
extends JPanel {
    CeciliaAppl _application;
    boolean _onlySelect;
    IconPanelTree _ctrlIcon;
    IconPanelPreview _ctrlPreview;

    public IconPanelCtrl(CeciliaAppl appl, boolean onlySelect) {
        super(new BorderLayout());
        this._application = appl;
        this._onlySelect = onlySelect;
        this.make();
    }

    private void make() {
        this._ctrlIcon = new IconPanelTree(this._application, this._onlySelect);
        this._ctrlIcon.setSelectionMode(1);
        this._ctrlIcon.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ImageIcon imag = null;
                DBFolder dbFolder = IconPanelCtrl.this._ctrlIcon.getSelectFolder();
                if (dbFolder != null) {
                    imag = DBIcon.readImage(dbFolder, IconPanelCtrl.this._application.getDAOFactory());
                }
                IconPanelCtrl.this._ctrlPreview.setImageIcon(imag);
                IconPanelCtrl.this._ctrlPreview.repaint();
            }
        });
        this._ctrlPreview = new IconPanelPreview();
        this._ctrlPreview.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._ctrlPreview.setPreferredSize(new Dimension(300, 200));
        this._ctrlPreview.setMinimumSize(new Dimension(200, 150));
        JPanel panelTitlePreview = new JPanel(new BorderLayout());
        panelTitlePreview.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_PREVIEW"))));
        JPanel panelInternPreview = new JPanel(new BorderLayout());
        panelInternPreview.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelInternPreview.add((Component)this._ctrlPreview, "Center");
        panelTitlePreview.add((Component)panelInternPreview, "Center");
        JSplitPane split = new JSplitPane(1);
        split.setLeftComponent(this._ctrlIcon);
        split.setRightComponent(panelTitlePreview);
        this.add((Component)split, "Center");
    }

    public IconPanelTree getPanelTree() {
        return this._ctrlIcon;
    }
}

