/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.LawException;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.ResLaw;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Law
implements Cloneable {
    protected int _id;
    protected ArrayList<Param> _params;
    protected LawManager _manager;
    protected Law _modifier;
    protected List<Param> _readOnlyViewParams;

    public Law() {
        this(-1, null);
    }

    public Law(int id, LawManager mng) {
        this._id = id;
        this._manager = mng;
        this._modifier = null;
        this._params = new ArrayList();
        if (this._manager != null && this._id != -1) {
            int nbr = this._manager.getLaw(this._id).size();
            for (int i = 0; i < nbr; ++i) {
                this._params.add(null);
            }
        }
    }

    public Law getCopy() {
        Law copy = new Law(this._id, this._manager);
        for (int i = 0; i < this._params.size(); ++i) {
            copy._params.set(i, this._params.get(i).getCopy());
        }
        if (this._modifier != null) {
            copy._modifier = this._modifier.getCopy();
        }
        return copy;
    }

    public void setManager(LawManager mng) {
        this._manager = mng;
    }

    public LawManager getManager() {
        return this._manager;
    }

    public int getID() {
        return this._id;
    }

    public int getNbrParam() {
        return this._params.size();
    }

    public Param getParamAt(int idx) {
        return this._params.get(idx);
    }

    public void setParamAt(int idx, Param par) {
        this._params.set(idx, par);
    }

    public List<Param> getReadOnlyParameters() {
        if (this._readOnlyViewParams == null) {
            this._readOnlyViewParams = Collections.unmodifiableList(this._params);
        }
        return this._readOnlyViewParams;
    }

    public void setModifierLaw(Law modif) {
        this._modifier = modif;
    }

    public Law getModifierLaw() {
        return this._modifier;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        Law other = (Law)otherObject;
        if (this.getID() != other.getID()) {
            return false;
        }
        if (this.getNbrParam() != other.getNbrParam()) {
            return false;
        }
        for (int i = 0; i < this.getNbrParam(); ++i) {
            if (this.getParamAt(i).equals(other.getParamAt(i))) continue;
            return false;
        }
        if (this._modifier != null) {
            if (other._modifier == null) {
                return false;
            }
            if (!this._modifier.equals(other._modifier)) {
                return false;
            }
        } else if (other._modifier != null) {
            return false;
        }
        return true;
    }

    public void verify(DAOFactory daoFactory) throws LawException {
        if (this._manager == null) {
            throw new LawException(ResLaw.getString("MSG_ERR_MANAGER"));
        }
        LawManager.LawData lawData = this._manager.getLaw(this._id);
        if (lawData == null) {
            throw new LawException(ResLaw.getString("MSG_ERR_MANAGER"));
        }
        int nbrParam = lawData.size();
        if (nbrParam != this.getNbrParam()) {
            throw new LawException(ResLaw.getString("MSG_ERR_WRONG_NUMBER_OF_PARAMS"));
        }
        for (int i = 0; i < nbrParam; ++i) {
            this.getParamAt(i).verify(daoFactory);
        }
        if (this._modifier != null) {
            this._modifier.verify(daoFactory);
        }
    }

    public String toString() {
        return LawFormat.DEFAULT.format(this, DoubleFormat.getJavaInstance());
    }

    public void toXML(String xmlElement, Appendable out, String indent, boolean withID) throws IOException {
        out.append(indent).append("<").append(xmlElement);
        out.append(" ").append("type").append("='").append(this._manager.getLaw(this._id).getExportXML()).append("'");
        out.append(">\n");
        String subIndent = indent + "  ";
        if (this._modifier != null) {
            this._modifier.toXML("law.modifier", out, subIndent, withID);
        }
        for (int i = 0; i < this.getNbrParam(); ++i) {
            this.getParamAt(i).toXML(out, subIndent, withID);
        }
        out.append(indent).append("</").append(xmlElement).append(">\n");
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        if (this._modifier != null) {
            this._modifier.addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
        for (int i = 0; i < this.getNbrParam(); ++i) {
            this.getParamAt(i).addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
    }

    public void recupParams(Set<Param> result, FctParamSelect fctSelect) {
        if (this._modifier != null) {
            this._modifier.recupParams(result, fctSelect);
        }
        for (int i = 0; i < this.getNbrParam(); ++i) {
            this.getParamAt(i).recupParams(result, fctSelect);
        }
    }

    public Law update(CECFactory cecFactory, DBLogs.DBLogsManager logMng, String name) {
        if (this._modifier != null) {
            this._modifier = this._modifier.update(cecFactory, logMng, name);
        }
        for (int i = 0; i < this.getNbrParam(); ++i) {
            Param param = this.getParamAt(i).update(cecFactory, logMng, name);
            if (param == null) {
                double defValue = ((LawManager.ParamData)this._manager.getLaw(this.getID()).get(i)).getDefaultValue();
                param = new ParamValue(this.getParamAt(i).getType(), defValue);
            }
            this.setParamAt(i, param);
        }
        return this;
    }

    public boolean withDepends() {
        if (this._modifier != null && this._modifier.withDepends()) {
            return true;
        }
        for (int i = 0; i < this.getNbrParam(); ++i) {
            if (!this.getParamAt(i).withDepends()) continue;
            return true;
        }
        return false;
    }
}

