/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelectFilter;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ParamRefPanel
extends JPanel {
    CeciliaAppl _application;
    TypeParam _typeFilter;
    DBFolderPanelSelect _ctrlSelect;
    boolean _bModified = false;
    DBFolder _previousSelectFolder;

    public ParamRefPanel(CeciliaAppl appl) {
        super(new BorderLayout());
        this._application = appl;
        this._typeFilter = null;
        this.make();
    }

    public TypeParam getTypeFilter() {
        return this._typeFilter;
    }

    public ParamRefPanel setTypeFilter(TypeParam value) {
        this._typeFilter = value;
        this._ctrlSelect.resetCache();
        return this;
    }

    private void make() {
        this._ctrlSelect = new DBFolderPanelSelectFilterParameter();
        DBFolderTree ctrlTree = this._ctrlSelect.getCtrlTree();
        ctrlTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ParamRefPanel.this.setModified(true);
            }
        });
        this.add((Component)this._ctrlSelect, "Center");
        this.setPreferredSize(new Dimension(300, 150));
    }

    public boolean isModified() {
        return this._bModified;
    }

    public void setModified(boolean value) {
        this._bModified = value;
    }

    public boolean validateParam(TypeParam type) {
        DBFolderTree ctrlTree = this._ctrlSelect.getCtrlTree();
        DBFolder dbSelect = this.getSelectFolder(true);
        if (dbSelect == null) {
            ctrlTree.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(ctrlTree), ResMsgCore.msgFormat("MSG_ERR_SELECT_FOLDER_FRM", ResMsgVoc.getString("VOC_PARAMETER")));
            return false;
        }
        DBWrap dbWrap = this._application.getDAOFactory().findOrCreateWrap(dbSelect);
        if (dbWrap == null) {
            ctrlTree.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(ctrlTree), ResMsgCore.msgFormat("MSG_ERR_LOAD_MODEL_FRM", dbSelect.getRefPath(), ResMsgVoc.getString("VOC_PARAMETER")));
            return false;
        }
        DBParam param = (DBParam)dbWrap;
        if (!param.getType().equals((Object)type)) {
            ctrlTree.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(ctrlTree), ResMsgCore.msgFormat("PAR_ERR_TYPE_FRM", type.getLabel()));
            return false;
        }
        return true;
    }

    public DBFolder getSelectFolder(boolean expand) {
        return this._ctrlSelect.getSelectFolder(expand);
    }

    public DBFolderTree getCtrlTree() {
        return this._ctrlSelect.getCtrlTree();
    }

    public void setSelectFolder(DBFolder dbFolder) {
        this._previousSelectFolder = dbFolder;
        this._ctrlSelect.setSelectFolder(dbFolder);
    }

    public void dispose() {
        this._ctrlSelect.dispose();
    }

    class DBFolderPanelSelectFilterParameter
    extends DBFolderPanelSelectFilter {
        public DBFolderPanelSelectFilterParameter() {
            super(ParamRefPanel.this._application, DBFolder.Family.PARAMETER);
        }

        @Override
        protected boolean selectThisFolder(DBFolder dbFolder) {
            if (dbFolder.isVersion()) {
                DBWrap dbWrap = ParamRefPanel.this._application.getDAOFactory().findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    return false;
                }
                if (!(dbWrap instanceof DBParam)) {
                    return false;
                }
                return ((DBParam)dbWrap).getType() == ParamRefPanel.this._typeFilter;
            }
            if (dbFolder.isModel()) {
                List<DBFolder> children = dbFolder.getChildren();
                if (children == null) {
                    children = ParamRefPanel.this._application.getDAOFactory().createFolderDAO().findChildren(dbFolder);
                }
                for (DBFolder dbChild : children) {
                    DBWrap dbWrap = ParamRefPanel.this._application.getDAOFactory().findOrCreateWrap(dbChild);
                    if (dbWrap == null || !(dbWrap instanceof DBParam) || ((DBParam)dbWrap).getType() != ParamRefPanel.this._typeFilter) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean selectFolder(DBFolder dbFolder) {
            if (ParamRefPanel.this._typeFilter == null) {
                return true;
            }
            return super.selectFolder(dbFolder);
        }
    }
}

