/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dependencies.DependsListener;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaDataReferencePanel;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.gui.LawPanel;
import com.dassault.cecilia.dbobj.general.law.gui.ParamRefPanel;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ParamValueCtrl
extends JPanel {
    JTabbedPane _ctrlTab;
    boolean _bWithDBParam = false;
    boolean _bWithSubLaw = false;
    boolean _bWithFMEA = false;
    CeciliaAppl _application;
    ActionListener _callback;
    DependsListener _callbackDependsListener = new DependsListener(){

        @Override
        public void changeDepends() {
            ParamValueCtrl.this.fireChangeDepends();
        }
    };
    Component _tabValue;
    Component _tabParam;
    Component _tabLaw;
    Component _tabFMEA;
    JTextField _ctrlValue;
    ParamRefPanel _ctrlParam;
    LawPanel _ctrlLaw;
    FmeaDataReferencePanel _ctrlFMEA;
    Param _previousValue;
    List<DependsListener> _listeners = new ArrayList<DependsListener>();

    public ParamValueCtrl(CeciliaAppl appl, boolean withDBParam, boolean withSubLaw, boolean withFMEA) {
        super(new BorderLayout());
        this._application = appl;
        this._bWithDBParam = withDBParam;
        this._bWithSubLaw = withSubLaw;
        this._bWithFMEA = withFMEA;
        this.make();
    }

    public void setCallback(ActionListener callback) {
        this._callback = callback;
    }

    public boolean isWithDBParam() {
        return this._bWithDBParam;
    }

    private void make() {
        this._ctrlTab = new JTabbedPane();
        this.add((Component)this._ctrlTab, "Center");
        int idx = 0;
        this._tabValue = this.createValueCtrl();
        this._ctrlTab.addTab(ResMsgVoc.getString("VOC_VALUE"), this._tabValue);
        this._ctrlTab.setToolTipTextAt(idx++, ResMsgCore.getString("PAR_TLT_EDIT_VALUE"));
        if (this._bWithDBParam) {
            this._tabParam = this.createParamCtrl();
            this._ctrlTab.addTab(ResMsgVoc.getString("VOC_PARAMETER"), this._tabParam);
            this._ctrlTab.setToolTipTextAt(idx++, ResMsgCore.getString("PAR_TLT_EDIT_PARAM"));
        }
        if (this._bWithSubLaw) {
            this._tabLaw = this.createLawCtrl();
            this._ctrlTab.addTab(ResMsgVoc.getString("VOC_LAW"), this._tabLaw);
            this._ctrlTab.setToolTipTextAt(idx++, ResMsgCore.getString("PAR_TLT_EDIT_LAW"));
        }
        if (this._bWithFMEA) {
            this._tabFMEA = this.createFMEACtrl();
            this._ctrlTab.addTab(ResMsgVoc.getString("VOC_FMEA"), this._tabFMEA);
            this._ctrlTab.setToolTipTextAt(idx++, ResMsgCore.getString("PAR_TLT_EDIT_FMEA"));
        }
        this._ctrlTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ParamValueCtrl.this.fireChangeDepends();
            }
        });
    }

    private Component createValueCtrl() {
        this._ctrlValue = new JTextField();
        this._ctrlValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                e.setKeyChar(e.getKeyChar() == ',' ? (char)'.' : (char)e.getKeyChar());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this._ctrlValue, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private Component createParamCtrl() {
        this._ctrlParam = new ParamRefPanel(this._application);
        this._ctrlParam.getCtrlTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ParamValueCtrl.this._callback == null) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                DBFolder dbFolder = ParamValueCtrl.this._ctrlParam.getSelectFolder(false);
                if (dbFolder == null) {
                    return;
                }
                if (!dbFolder.isVersion()) {
                    return;
                }
                ParamValueCtrl.this._callback.actionPerformed(new ActionEvent(ParamValueCtrl.this._ctrlParam, -1, "valid"));
            }
        });
        this._ctrlParam.getCtrlTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ParamValueCtrl.this.fireChangeDepends();
            }
        });
        return this._ctrlParam;
    }

    private Component createLawCtrl() {
        LawManager lawMng = this._application.getDAOFactory().getLawManager().getParameterManager();
        this._ctrlLaw = new LawPanel(lawMng, this._application);
        this._ctrlLaw.setLaw(lawMng.createLaw(0));
        this._ctrlLaw.addDependsListener(this._callbackDependsListener);
        return this._ctrlLaw;
    }

    private Component createFMEACtrl() {
        this._ctrlFMEA = new FmeaDataReferencePanel(this._application);
        this._ctrlFMEA.clean();
        this._ctrlFMEA.addDependsListener(this._callbackDependsListener);
        return this._ctrlFMEA;
    }

    public void setParamValue(Param param) {
        this._previousValue = param;
        if (param instanceof ParamValue) {
            this._ctrlValue.setText(param.toString());
            this._ctrlTab.setSelectedComponent(this._tabValue);
        } else if (param instanceof ParamLaw) {
            this._ctrlLaw.setLaw(((ParamLaw)param).getValue());
            this._ctrlLaw.setModified(false);
            this._ctrlTab.setSelectedComponent(this._tabLaw);
        } else if (param instanceof ParamRef) {
            this._ctrlParam.setSelectFolder(((ParamRef)param).getValue());
            this._ctrlParam.setModified(false);
            this._ctrlTab.setSelectedComponent(this._tabParam);
        } else if (param instanceof ParamFMEA) {
            this._ctrlFMEA.update((ParamFMEA)param);
            this._ctrlTab.setSelectedComponent(this._tabFMEA);
        }
    }

    public boolean validCtrl(TypeParam type) {
        Component tabSelect = this._ctrlTab.getSelectedComponent();
        if (tabSelect == this._tabValue) {
            String title = ResMsgVoc.getString("VOC_VALUE");
            String strValue = this._ctrlValue.getText().trim();
            if (strValue.isEmpty()) {
                this._ctrlValue.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValue), ResMsgCore.msgFormat("MSG_ERR_FIELD_EMPTY", title));
                return false;
            }
            double value = Double.NaN;
            try {
                value = Double.parseDouble(strValue);
            }
            catch (Exception e) {
                this._ctrlValue.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValue), ResMsgCore.msgFormat("MSG_ERR_FIELD_NOTDOUBLE", title));
                return false;
            }
            String msg = type.verify(value);
            if (msg != null) {
                this._ctrlValue.requestFocus();
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlValue), msg);
                return false;
            }
        } else {
            if (tabSelect == this._tabLaw) {
                return this._ctrlLaw.validateParams(type);
            }
            if (tabSelect == this._tabParam) {
                return this._ctrlParam.validateParam(type);
            }
            if (tabSelect == this._tabFMEA) {
                return this._ctrlFMEA.checkFields();
            }
        }
        return true;
    }

    public Param getParam(TypeParam type) {
        Component tabSelect = this._ctrlTab.getSelectedComponent();
        if (tabSelect == this._tabValue) {
            String strValue = this._ctrlValue.getText().trim();
            if (strValue.isEmpty()) {
                return null;
            }
            double value = Double.NaN;
            try {
                value = Double.parseDouble(strValue);
            }
            catch (Exception e) {
                return null;
            }
            String msg = type.verify(value);
            if (msg != null) {
                return null;
            }
            return new ParamValue(type, value);
        }
        if (tabSelect == this._tabLaw) {
            return new ParamLaw(type, this._ctrlLaw.getLaw());
        }
        if (tabSelect == this._tabParam) {
            return new ParamRef(type, this._ctrlParam.getSelectFolder(true));
        }
        if (tabSelect == this._tabFMEA) {
            return new ParamFMEA(type, this._ctrlFMEA.getReference());
        }
        return null;
    }

    public boolean isModified() {
        if (this._previousValue == null) {
            return true;
        }
        Component tabSelect = this._ctrlTab.getSelectedComponent();
        if (this._previousValue instanceof ParamValue) {
            if (tabSelect != this._tabValue) {
                return true;
            }
            return !this._ctrlValue.getText().trim().equals(this._previousValue.toString());
        }
        if (this._previousValue instanceof ParamLaw) {
            if (tabSelect != this._tabLaw) {
                return true;
            }
            return this._ctrlLaw.isModified();
        }
        if (this._previousValue instanceof ParamRef) {
            if (tabSelect != this._tabParam) {
                return true;
            }
            if (this._ctrlParam.getSelectFolder(true) == null) {
                return true;
            }
            return !this._ctrlParam.getSelectFolder(true).equals(((ParamRef)this._previousValue).getValue());
        }
        if (this._previousValue instanceof ParamFMEA) {
            if (tabSelect != this._tabFMEA) {
                return true;
            }
            return !new ParamFMEA(this._previousValue.getType(), this._ctrlFMEA.getReference()).equals(this._previousValue);
        }
        return true;
    }

    public void dispose() {
        this._ctrlParam.dispose();
    }

    public void setParamType(TypeParam type) {
        if (this._ctrlParam != null) {
            this._ctrlParam.setTypeFilter(type);
        }
    }

    public void addRelation(DBFolder srcFolder, String srcType, Set<DBRelation> relations) {
        Component tabSelect = this._ctrlTab.getSelectedComponent();
        if (tabSelect != this._tabValue) {
            if (tabSelect == this._tabLaw) {
                Law law = this._ctrlLaw.getLaw();
                if (law != null) {
                    law.addRelation(srcFolder, srcType, relations);
                }
            } else if (tabSelect == this._tabParam) {
                DBFolder destFolder = this._ctrlParam.getSelectFolder(false);
                if (destFolder != null && destFolder.isVersion() && destFolder.getFamily() == DBFolder.Family.PARAMETER) {
                    relations.add(new DBRelation(srcFolder, srcType, destFolder, "PARAMETER"));
                }
            } else if (tabSelect == this._tabFMEA) {
                DBFolder destFolder = null;
                if (this._ctrlFMEA.getReference() != null) {
                    destFolder = this._ctrlFMEA.getReference().getDBFolder();
                }
                if (destFolder != null) {
                    relations.add(new DBRelation(srcFolder, srcType, destFolder, "FMEA_V"));
                }
            }
        }
    }

    public void addDependsListener(DependsListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removeDependsListener(DependsListener l) {
        this._listeners.remove(l);
    }

    protected void fireChangeDepends() {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).changeDepends();
        }
    }
}

