/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.ResLaw;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.io.BasicLexer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class LawParser {
    LawManager _lawManager;
    CECFactory _cecFactory;
    ArrayList<String> _errors;

    public LawParser(LawManager lawManager, CECFactory cecFactory) {
        this._lawManager = lawManager;
        this._cecFactory = cecFactory;
        this._errors = new ArrayList();
    }

    protected void addError(String msg) {
        this._errors.add(msg);
    }

    public boolean withError() {
        return !this._errors.isEmpty();
    }

    public List<String> getErrors() {
        return this._errors;
    }

    public void clearErrors() {
        this._errors.clear();
    }

    public void traceError(DBLogs.DBLogsManager traceMng, String refEvt, String refLaw, Logger log, boolean isLaw) {
        String firstMsg = null;
        if (this.withError()) {
            for (String msg : this.getErrors()) {
                if (firstMsg == null) {
                    firstMsg = msg;
                }
                log.finer(msg);
            }
        }
        if (firstMsg == null) {
            firstMsg = "Unknown error";
        }
        String msgKey = isLaw ? (refEvt == null ? "MSG_ERR_DBMOD_EVENT_RAW_LAW" : "MSG_ERR_DBMOD_EVENT_RAW_LAW_WITH_EVT") : (refEvt == null ? "MSG_ERR_DBMOD_EVENT_RAW_PARAM" : "MSG_ERR_DBMOD_EVENT_RAW_PARAM_WITH_EVT");
        traceMng.addLog(DBLogs.DBLevel.WARNING, ResMsgCore.msgFormat(msgKey, refLaw, firstMsg, refEvt));
    }

    public void traceError(DBLogs.DBLogsManager traceMng, String refLaw, Logger log) {
        this.traceError(traceMng, null, refLaw, log, true);
    }

    protected String readNextIdentify(BasicLexer lex) {
        return lex.readNextIdentify(false);
    }

    public Law parseLaw(String str) {
        if (str.isEmpty()) {
            return null;
        }
        BasicLexer lex = new BasicLexer(str);
        Law result = this.parseLaw(lex);
        if (lex.readNextChar() != '\u0000') {
            this.addError(ResLaw.getString("MSG_ERR_SYNTAX"));
            return null;
        }
        return result;
    }

    private Law parseLaw(BasicLexer lex) {
        Law result;
        LawManager mng;
        String word = lex.readNextWord(true);
        if (word.isEmpty()) {
            this.addError(ResLaw.msgFormat("MSG_ERR_UNKNOWN_LAW", lex.getBuffer()));
            return null;
        }
        Law modifierLaw = null;
        if (this._lawManager.getModifierManager() != null && (mng = this._lawManager.getModifierManager()).findIdLawFromExport(word) != null) {
            LawParser paramParser = new LawParser(mng, this._cecFactory);
            modifierLaw = paramParser.parseLaw(word, lex);
            if (modifierLaw == null) {
                return null;
            }
            word = lex.readNextWord(true);
            if (word.isEmpty()) {
                this.addError(ResLaw.msgFormat("MSG_ERR_UNKNOWN_LAW", lex.getBuffer()));
                return null;
            }
        }
        if ((result = this.parseLaw(word, lex)) != null && modifierLaw != null) {
            result.setModifierLaw(modifierLaw);
        }
        return result;
    }

    private Law parseLaw(String word, BasicLexer lex) {
        boolean withBrack;
        LawManager.LawData lawData = this._lawManager.findIdLawFromExport(word);
        if (lawData == null) {
            this.addError(ResLaw.msgFormat("MSG_ERR_UNKNOWN_LAW", word));
            return null;
        }
        int nbrParam = lawData.isConflictExportDag() ? -1 : lawData.size();
        ArrayList<Param> params = new ArrayList<Param>();
        boolean bl = withBrack = lex.readNextChar() == '(';
        if (withBrack) {
            if (lex.readNextChar() != ')') {
                do {
                    lex.ungetChar();
                    param = this.parseParam(lex);
                    if (param == null) {
                        return null;
                    }
                    params.add((Param)param);
                    char nextCar = lex.readNextChar();
                    if (nextCar == ',') continue;
                    if (nextCar != ')') {
                        this.addError(ResLaw.getString("MSG_ERR_MALFORMED_LAW"));
                        return null;
                    }
                    break;
                } while (lex.readNextChar() != '\u0000');
            }
        } else {
            do {
                lex.ungetChar();
                param = this.parseParam(lex);
                if (param == null) {
                    return null;
                }
                params.add((Param)param);
            } while ((nbrParam == -1 || params.size() != nbrParam) && lex.readNextChar() != '\u0000');
        }
        if (nbrParam == -1 && lawData.size() != params.size()) {
            for (LawManager.LawData findData : this._lawManager.getDataLaws()) {
                if (!findData.acceptExportName(word) || findData.size() != params.size()) continue;
                lawData = findData;
                break;
            }
        }
        if (lawData.size() != params.size()) {
            this.addError(ResLaw.getString("MSG_ERR_MALFORMED_LAW"));
            return null;
        }
        Law result = this._lawManager.createLaw(lawData.getID());
        for (int i = 0; i < params.size(); ++i) {
            Param param = (Param)params.get(i);
            param.setType(((LawManager.ParamData)lawData.get(i)).getType());
            result.setParamAt(i, param);
        }
        return result;
    }

    protected ParamRef createParamRef(String dbPath) {
        if (this._cecFactory == null) {
            this.addError(ResLaw.getString("MSG_ERR_NO_PARAMETER_MANAGER"));
            return null;
        }
        DAOFolder daoFolder = this._cecFactory.createFolderDAO();
        DBFolder dbFolder = daoFolder.findFolder("LAW_PARAMETERS", dbPath);
        if (dbFolder == null) {
            this.addError(ResLaw.getString("MSG_ERR_PARAMREF_BAD_PATH"));
            return null;
        }
        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
        if (dbWrap == null) {
            this.addError(ResLaw.getString("MSG_ERR_PARAMREF_BAD_FOLDER"));
            return null;
        }
        return new ParamRef(((DBParam)dbWrap).getType(), dbFolder);
    }

    public Param parseParam(String str) {
        if (str.trim().isEmpty()) {
            this.addError(ResMsgCore.getString("MSG_ERR_TEXT_EMPTY"));
            return null;
        }
        BasicLexer lex = new BasicLexer(str);
        Param result = this.parseParam(lex);
        if (lex.readNextChar() != '\u0000') {
            this.addError(ResLaw.getString("MSG_ERR_SYNTAX"));
            return null;
        }
        return result;
    }

    protected Param parseParam(BasicLexer lex) {
        char nextCar = lex.readNextChar();
        if (nextCar >= '0' && nextCar <= '9' || nextCar == '+' || nextCar == '-' || nextCar == '.') {
            lex.ungetChar();
            double value = lex.readNextNumber();
            if (Double.isNaN(value)) {
                this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 100));
                return null;
            }
            return new ParamValue(null, value);
        }
        if (nextCar == '\'' || nextCar == '`') {
            lex.ungetChar();
            String id = this.readNextIdentify(lex);
            if (id.length() <= 2) {
                this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 101));
                return null;
            }
            return this.createParamRef(id.substring(1, id.length() - 1));
        }
        if (nextCar >= 'a' && nextCar <= 'z' || nextCar >= 'A' && nextCar <= 'Z') {
            lex.ungetChar();
            String id = this.readNextIdentify(lex);
            if (id.isEmpty()) {
                this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 102));
                return null;
            }
            LawManager lawParamMng = this._lawManager.getParameterManager();
            if (lawParamMng != null && lawParamMng.findIdLawFromExport(id) != null) {
                LawParser paramParser = new LawParser(lawParamMng, this._cecFactory);
                Law law = paramParser.parseLaw(id, lex);
                if (law != null) {
                    return new ParamLaw(null, law);
                }
            } else {
                return this.createParamRef(id);
            }
        }
        return null;
    }

    public Param parseParamFromGUI(String str) {
        BasicLexer lex = new BasicLexer(str);
        char nextCar = lex.readNextChar();
        if (nextCar == ':') {
            String typ = lex.readNextWord(false);
            if (lex.readNextChar() != ':') {
                this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 200));
                return null;
            }
            if (typ.equalsIgnoreCase("val")) {
                double value = lex.readNextNumber();
                if (Double.isNaN(value)) {
                    this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 201));
                    return null;
                }
                return new ParamValue(null, value);
            }
            if (typ.equalsIgnoreCase("law")) {
                LawParser paramParser;
                Law law;
                LawManager lawParamMng = this._lawManager.getParameterManager();
                if (lawParamMng != null && (law = (paramParser = new LawParser(lawParamMng, this._cecFactory)).parseLaw(lex)) != null) {
                    return new ParamLaw(null, law);
                }
                this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 202));
                return null;
            }
            if (typ.equalsIgnoreCase("par")) {
                String id = this.readNextIdentify(lex);
                if (id.isEmpty()) {
                    this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 203));
                    return null;
                }
                return this.createParamRef(id);
            }
            this.addError(ResLaw.getString("MSG_ERR_SYNTAX") + ResLaw.msgFormat("MSG_ERR_CODE_FRM", 204));
            return null;
        }
        return this.parseParam(lex);
    }
}

