/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.law.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.lib.util.io.BasicLexer;

public class LawParserRaw
extends LawParser {
    public LawParserRaw(LawManager mng, CECFactory cecFactory) {
        super(mng, cecFactory);
    }

    @Override
    protected Param parseParam(BasicLexer lex) {
        char nextCar = lex.readNextChar();
        if (nextCar == '@') {
            String word = lex.readNextWord(false);
            if (word.isEmpty()) {
                this.addError(ResMsgCore.getString("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX"));
                return null;
            }
            if (word.equals("param_key")) {
                long paramID = lex.readNextInteger();
                if (paramID < 0L) {
                    this.addError(ResMsgCore.getString("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX_KEY"));
                    return null;
                }
                long folID = this._cecFactory.createUtilityDAO().convertMigrationIDParamToIDFolder(paramID);
                if (folID < 0L) {
                    this.addError(ResMsgCore.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX_KEY_ID", paramID));
                    return null;
                }
                DBFolder dbFolder = (DBFolder)this._cecFactory.createFolderDAO().find(folID);
                if (dbFolder == null) {
                    this.addError(ResMsgCore.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX_KEY_FOLDER", folID, paramID));
                    return null;
                }
                return new ParamRef(null, dbFolder);
            }
            if (word.equals("param_link")) {
                double valueAttrib;
                String valueEntite;
                String nameAttrib;
                String nameEntite;
                String defAttrib;
                String defEntite;
                long fmeaID;
                ParamFMEA param = null;
                if (!(lex.readNextChar() != '[' || (fmeaID = lex.readNextInteger()) < 0L || lex.readNextChar() != ';' || (defEntite = lex.readNextIdentify(true)).isEmpty() || lex.readNextChar() != ';' || (defAttrib = lex.readNextIdentify(true)).isEmpty() || lex.readNextChar() != ';' || (nameEntite = lex.readUntil(';')).isEmpty() || (nameAttrib = lex.readUntil(';')).isEmpty() || (valueEntite = lex.readUntil(';')).isEmpty() || Double.isNaN(valueAttrib = lex.readNextNumber()) || lex.readNextChar() != ']')) {
                    DBFolder dbFolder = (DBFolder)this._cecFactory.createFolderDAO().find(fmeaID);
                    if (dbFolder == null) {
                        this.addError(ResMsgCore.msgFormat("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX_KEY_FOLDER", fmeaID));
                        return null;
                    }
                    param = new ParamFMEA(null, dbFolder);
                    param.setDefineEntity(defEntite);
                    param.setDefineAttribute(defAttrib);
                    param.setNameEntity(nameEntite);
                    param.setNameAttribute(nameAttrib);
                    param.setValueEntity(valueEntite);
                    param.setValueAttribute(valueAttrib);
                }
                if (param == null) {
                    this.addError(ResMsgCore.getString("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX_LINK"));
                }
                return param;
            }
            this.addError(ResMsgCore.getString("MSG_ERR_DBMOD_EVENT_RAW_LAW_SYNTAX"));
            return null;
        }
        lex.ungetChar();
        return super.parseParam(lex);
    }
}

