/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DBLogsDependences {
    Internal _src;
    Map<DBFolder, Internal> _map = new TreeMap<DBFolder, Internal>(DBFolder.getComparatorWithFamily());
    DBLogs.DBLevel _level;

    public DBLogsDependences(DBWrap src) {
        this._src = new Internal(src);
        this._level = this._src._maxLevel;
    }

    public void add(DBWrap dbWrap) {
        DBFolder dbFolder = dbWrap.getDBFolder();
        Internal interne = new Internal(dbWrap);
        if (this._level.compareTo(interne._maxLevel) > 0) {
            this._level = interne._maxLevel;
        }
        this._map.put(dbFolder, interne);
    }

    public boolean withLogs(DBLogs.DBLevel limit) {
        return this._level.compareTo(limit) <= 0;
    }

    public List<DBWrap> getWrap(DBLogs.DBLevel limit) {
        if (!this.withLogs(limit)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DBWrap> result = new ArrayList<DBWrap>(this._map.size());
        if (this._src._maxLevel.compareTo(limit) <= 0) {
            result.add(this._src._dbWrap);
        }
        for (Internal src : this._map.values()) {
            if (src._maxLevel.compareTo(limit) > 0) continue;
            result.add(src._dbWrap);
        }
        return result;
    }

    static class Internal {
        DBWrap _dbWrap;
        DBLogs.DBLevel _maxLevel;

        Internal(DBWrap dbWrap) {
            this._dbWrap = dbWrap;
            DBLogs dbLogs = dbWrap.getLogs();
            if (dbLogs != null) {
                this._maxLevel = DBLogs.DBLevel.ZERO;
                for (DBLogs.Log log : dbLogs.getLogs(DBLogs.DBLevel.FINEST)) {
                    if (this._maxLevel.compareTo(log.getLevel()) <= 0) continue;
                    this._maxLevel = log.getLevel();
                }
            }
        }
    }
}

