/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class DBLogsSimpleDlg
extends JDialogCecilia {
    protected static DateFormat _formatDate = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
    DBLogs _dbLogs;
    List<DBLogs.Log> _listLogs;
    DBLogsTableModel _tableModel = new DBLogsTableModel();
    JTable _ctrlTable;

    public DBLogsSimpleDlg(Window owner) throws HeadlessException {
        super(owner, ResMsgCore.getString("TITLE_LOGS"), true);
        this._dbLogs = new DBLogs();
        this.make();
        this.pack();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    public void setDBLogs(DBLogs dbLogs) {
        this._dbLogs = dbLogs;
        this._listLogs = this._dbLogs.getLogs(DBLogs.DBLevel.FINEST);
        this._tableModel.fireTableDataChanged();
    }

    private void make() {
        JScrollPane scroll = new JScrollPane(this.createTable());
        scroll.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)this.createButPanelClose(false), "South");
        this.init();
    }

    private JTable createTable() {
        this._ctrlTable = new JTable(this._tableModel);
        TableColumn column = null;
        block6: for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            column = this._ctrlTable.getColumnModel().getColumn(i);
            switch (i + 1) {
                case 1: {
                    column.setPreferredWidth(75);
                    column.setCellRenderer(DBLogs.DBLevel.getTableCellRenderer());
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(120);
                    column.setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                            if (value instanceof Date) {
                                this.setText(_formatDate.format((Date)value));
                            }
                            return this;
                        }
                    });
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(50);
                    continue block6;
                }
                case 4: {
                    column.setPreferredWidth(400);
                    column.setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                            String text = value.toString().trim();
                            if (!text.isEmpty()) {
                                if (text.contains("\n")) {
                                    StringBuilder sb = new StringBuilder(text.length() + 128);
                                    sb.append("<html>");
                                    try {
                                        if (text.length() < 4096) {
                                            Util.appendForHtml(sb, text);
                                        } else {
                                            Util.appendForHtml(sb, text.substring(0, 4096)).append("BR");
                                        }
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    sb.append("</html>");
                                    this.setToolTipText(sb.toString());
                                } else {
                                    this.setToolTipText(text);
                                }
                            }
                            return this;
                        }
                    });
                }
            }
        }
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this._ctrlTable.getModel());
        this._ctrlTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
        sorter.setSortKeys(sortKeys);
        this._ctrlTable.setPreferredScrollableViewportSize(new Dimension(800, 250));
        return this._ctrlTable;
    }

    class DBLogsTableModel
    extends AbstractTableModel {
        DBLogsTableModel() {
        }

        @Override
        public int getRowCount() {
            if (DBLogsSimpleDlg.this._listLogs == null) {
                return 0;
            }
            return DBLogsSimpleDlg.this._listLogs.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex + 1) {
                case 1: {
                    return ResMsgVoc.getString("VOC_LEVEL");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_DATE");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_USER");
                }
                case 4: {
                    return ResMsgVoc.getString("VOC_MESSAGE");
                }
            }
            return "<error>";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex + 1) {
                case 1: {
                    return DBLogs.DBLevel.class;
                }
                case 2: {
                    return Date.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex + 1) {
                case 1: {
                    return DBLogsSimpleDlg.this._listLogs.get(rowIndex).getLevel();
                }
                case 2: {
                    DBLogs.Log log = DBLogsSimpleDlg.this._listLogs.get(rowIndex);
                    if (log.getModif() != null) {
                        return log.getModif();
                    }
                    return log.getCreate();
                }
                case 3: {
                    return DBLogsSimpleDlg.this._listLogs.get(rowIndex).getUser();
                }
                case 4: {
                    return DBLogsSimpleDlg.this._listLogs.get(rowIndex).getMessage();
                }
            }
            return null;
        }
    }
}

