/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.general.log.io;

import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.util.Date;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class DBLogsHandlerXml
extends SAXExtendedHandler
implements DBObjectXmlConstant {
    public static final String ELT_CEC_LOGS = "cec.logs";
    public static final String ELT_CEC_LOG = "cec.log";
    public static final String ATT_CREATE = "create";
    public static final String ATT_USER = "user";
    public static final String ATT_LEVEL = "level";
    public static final String ATT_MODIFY = "modify";
    public static final String ATT_PRIVATE = "private";
    DBLogs _logs = new DBLogs();
    long _create = -1L;
    String _user = null;
    DBLogs.DBLevel _level = null;
    long _modify = -1L;
    boolean _private = false;

    public DBLogsHandlerXml(Locator locator) {
        if (locator != null) {
            this.setLocator(locator);
        }
    }

    public DBLogs getLogs() {
        return this._logs;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXParseException {
        if (startAction) {
            if (!ELT_CEC_LOGS.equals(key)) {
                throw new SAXParseException("La balise de d\u00e9marrage doit \u00eatre 'cec.logs'", this.getLocator());
            }
        } else if (ELT_CEC_LOG.equals(key)) {
            this._create = -1L;
            this._user = null;
            this._level = null;
            this._modify = -1L;
            this._private = false;
            String attr = attrs.get(ATT_CREATE);
            if (attr == null || attr.isEmpty()) {
                throw new SAXParseException("La balise 'cec.log' n'a pas d'attribut 'create'", this.getLocator());
            }
            try {
                this._create = Long.parseLong(attr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this._create < 0L) {
                throw new SAXParseException("L'\u00e9l\u00e9ment '" + key + "' a un attribut 'create' non conforme: " + attr, this.getLocator());
            }
            attr = attrs.get(ATT_USER);
            if (attr == null || attr.isEmpty()) {
                throw new SAXParseException("La balise 'cec.log' n'a pas d'attribut 'user'", this.getLocator());
            }
            this._user = attr;
            attr = attrs.get(ATT_LEVEL);
            if (attr == null || attr.isEmpty()) {
                throw new SAXParseException("La balise 'cec.log' n'a pas d'attribut 'level'", this.getLocator());
            }
            this._level = (DBLogs.DBLevel)DBLogsHandlerXml.valueOfEnum(DBLogs.DBLevel.class, (String)attr.toUpperCase());
            if (this._level == null) {
                throw new SAXParseException("L'\u00e9l\u00e9ment '" + key + "' a un attribut 'level' non conforme: " + attr, this.getLocator());
            }
            attr = attrs.get(ATT_MODIFY);
            if (attr != null && !attr.isEmpty()) {
                try {
                    this._modify = Long.parseLong(attr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this._modify < 0L) {
                    throw new SAXParseException("L'\u00e9l\u00e9ment '" + key + "' a un attribut 'modify' non conforme: " + attr, this.getLocator());
                }
            }
            if ((attr = attrs.get(ATT_PRIVATE)) != null && !attr.isEmpty()) {
                if (attr.equalsIgnoreCase("true")) {
                    this._private = true;
                } else if (attr.equalsIgnoreCase("false")) {
                    this._private = false;
                } else {
                    throw new SAXParseException("L'\u00e9l\u00e9ment '" + key + "' a un attribut 'private' non conforme: " + attr, this.getLocator());
                }
            }
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
        if (ELT_CEC_LOG.equals(key)) {
            if (txt == null) {
                throw new SAXParseException("La balise 'cec.log' n'a pas d'\u00e9l\u00e9ment textuel", this.getLocator());
            }
            if (txt.endsWith("  ")) {
                StringBuilder buffer = new StringBuilder(txt);
                for (int len = buffer.length(); len > 2 && buffer.charAt(len - 1) == ' ' && buffer.charAt(len - 2) == ' '; len -= 2) {
                    buffer.deleteCharAt(len - 1);
                    buffer.deleteCharAt(len - 2);
                }
                txt = buffer.toString();
            }
            if (txt.length() == 0) {
                throw new SAXParseException("La balise 'cec.log' n'a pas d'\u00e9l\u00e9ment textuel", this.getLocator());
            }
            if (this._create > 0L && this._user != null && this._level != null) {
                DBLogs.Log log = this._logs.addLog(new Date(this._create), this._user, this._level, txt);
                if (this._modify > 0L) {
                    log.setModif(new Date(this._modify));
                }
                log.setPrivate(this._private);
            }
        }
        return ELT_CEC_LOGS.equals(key);
    }
}

