/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa;

import com.dassault.cecilia.core.cecilia.dependencies.Generate;
import com.dassault.cecilia.core.cecilia.dependencies.Recup;
import com.dassault.cecilia.core.cecilia.error.GeneralError;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.io.CRCWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerateAltaricaCode
extends Generate<DBWrap> {
    public static final String PROP_MBSA_NOVERIFY_OPT_VERSION = "cecilia.mbsa.NoVerifyOptionalVersionsWhenGenerateCode";
    private boolean _bNoVerifyOptVersions = Boolean.getBoolean("cecilia.mbsa.NoVerifyOptionalVersionsWhenGenerateCode");
    static Comparator<IWrap> __COMPARATOR_WITH_REFPATH = new Comparator<IWrap>(){

        @Override
        public int compare(IWrap o1, IWrap o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getDBFolder().getRefPath().compareTo(o2.getDBFolder().getRefPath());
        }
    };
    private static Logger _LOG = Logger.getLogger(GenerateAltaricaCode.class.getPackage().getName());
    GenerateAltaRicaCodeUtility _utility;
    CECFactory _cecFactory;
    String _crc = null;
    File _output = null;

    public String getStrConfig() {
        if (this._utility == null) {
            return null;
        }
        AltaConfig config = this._utility.getConfig();
        if (config == null) {
            return null;
        }
        return config.getName();
    }

    @Override
    protected boolean dontTreatThisFamily(DBFolder.Family family) {
        if (family == DBFolder.Family.IMAG) {
            return true;
        }
        return super.dontTreatThisFamily(family);
    }

    @Override
    protected Recup<DBWrap> makeRecup(DBFolder.Family key) {
        switch (key) {
            case TYPE: {
                return new Verify(key, this, "MSG_ERR_CODE_TYPE_OTHER_VERSION_FRM");
            }
            case OPERATOR: {
                return new Verify<AltaOperator>(key, this, "MSG_ERR_CODE_OPERATOR_SAME_NAME_FRM"){

                    @Override
                    protected String constructName(DBFolder dbFolder, DBWrap t) {
                        return ((AltaOperator)t).getName();
                    }
                };
            }
            case COMPONENT: {
                return new Verify(key, this, "MSG_ERR_CODE_COMPONENT_OTHER_VERSION_FRM");
            }
            case EQUIPMENT: {
                return new Verify<AltaEquipment>(key, this, "MSG_ERR_CODE_EQUIPMENT_OTHER_VERSION_FRM"){

                    @Override
                    protected boolean isValid(DBFolder dbFolder, DBWrap t) {
                        GenerateAltaricaCode.this.verifyLinksOfEquipment(dbFolder, t);
                        return super.isValid(dbFolder, t);
                    }
                };
            }
            case PROJECT: {
                return new NoVerify<AltaSystem>(key, this){

                    @Override
                    protected boolean isValid(DBFolder dbFolder, DBWrap t) {
                        GenerateAltaricaCode.this.verifyLinksOfEquipment(dbFolder, t);
                        return super.isValid(dbFolder, t);
                    }
                };
            }
            case BTP_MODEL: {
                if (this._bNoVerifyOptVersions) {
                    return new NoVerify(key, this);
                }
                return new Verify(key, this, "MSG_ERR_CODE_FRB_OTHER_VERSION_FRM");
            }
            case ATTRIBUTE: {
                if (this._bNoVerifyOptVersions) {
                    return new NoVerify(key, this);
                }
                return new Verify(key, this, "MSG_ERR_CODE_ATTRIBUT_OTHER_VERSION_FRM");
            }
            case PARAMETER: {
                if (this._bNoVerifyOptVersions) {
                    return new NoVerify(key, this);
                }
                return new Verify(key, this, "MSG_ERR_CODE_PARAMETER_OTHER_VERSION_FRM");
            }
        }
        return null;
    }

    protected void verifyLinksOfEquipment(DBFolder dbFolder, DBWrap t) {
        if (t instanceof AltaEquipment) {
            AltaEquipment equip = (AltaEquipment)t;
            for (AltaLink link : equip.getLinks()) {
                if (link.verify()) continue;
                this.getErrors().add(new GeneralError<DBFolder>(dbFolder, ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_INVALID", link)));
            }
        }
    }

    public GenerateAltaricaCode(CECFactory cecFactory) {
        super(cecFactory);
        this._cecFactory = cecFactory;
    }

    @Override
    protected DBWrap findOrCreate(DBFolder dbDest, DBFolder.Family family) {
        return this._cecFactory.findOrCreateWrap(dbDest);
    }

    public void setUtility(GenerateAltaRicaCodeUtility utility) {
        this._utility = utility;
    }

    @Override
    public Collection<? extends DBWrap> getValues(DBFolder.Family key) {
        Collection result = super.getValues(key);
        if (result == null) {
            return result;
        }
        if (result.size() < 2) {
            return result;
        }
        switch (key) {
            case OPERATOR: 
            case EQUIPMENT: {
                return this.orderValues(result);
            }
            case TYPE: {
                return this.orderTypes(result);
            }
        }
        if (result.size() == 2) {
            Iterator iter = result.iterator();
            DBWrap i1 = (DBWrap)iter.next();
            DBWrap i2 = (DBWrap)iter.next();
            if (i1.getDBFolder().getParent().getName().compareTo(i2.getDBFolder().getParent().getName()) < 0) {
                ArrayList<DBWrap> sortResult = new ArrayList<DBWrap>(2);
                sortResult.add(i2);
                sortResult.add(i1);
                return sortResult;
            }
            return result;
        }
        ArrayList sortResult = new ArrayList(result);
        Collections.sort(sortResult, __COMPARATOR_WITH_REFPATH);
        return sortResult;
    }

    private Collection<? extends DBWrap> orderTypes(Collection<? extends DBWrap> input) {
        ArrayList<? extends DBWrap> copy = new ArrayList<DBWrap>(input);
        Collections.sort(copy, __COMPARATOR_WITH_REFPATH);
        ArrayList<? extends DBWrap> output = new ArrayList<DBWrap>(input.size());
        Iterator<? extends DBWrap> iterType = copy.iterator();
        while (iterType.hasNext()) {
            DBWrap current = iterType.next();
            if (current.getDBFolder().getFamilyFlag() != 1) continue;
            output.add(current);
            iterType.remove();
        }
        output.addAll(copy);
        return output;
    }

    private Collection<? extends DBWrap> orderValues(Collection<? extends DBWrap> input) {
        ArrayList<? extends DBWrap> copy = new ArrayList<DBWrap>(input);
        Collections.sort(copy, __COMPARATOR_WITH_REFPATH);
        ArrayList<DBWrap> output = new ArrayList<DBWrap>(input.size());
        while (!copy.isEmpty()) {
            DBWrap select = null;
            for (int i = copy.size() - 1; i >= 0 && select == null; --i) {
                DBWrap current = copy.get(i);
                boolean find = false;
                block2: for (int j = copy.size() - 1; j >= 0; --j) {
                    if (i == j) continue;
                    Collection<DBRelation> dbRelations = copy.get(j).getUseRelations();
                    for (DBRelation dbRelation : dbRelations) {
                        if (!dbRelation.getDestination().equals(current.getDBFolder())) continue;
                        find = true;
                        continue block2;
                    }
                }
                if (find) continue;
                select = copy.get(i);
            }
            if (select == null) continue;
            output.add(select);
            copy.remove(select);
        }
        Collections.reverse(output);
        return output;
    }

    protected void writeType(Appendable out, DBType type) throws IOException {
    }

    protected void writeTypes(Appendable out) throws IOException {
        Collection<? extends DBWrap> types = this.getValues(DBFolder.Family.TYPE);
        if (types != null) {
            for (DBType dBType : types) {
                dBType.writeAltaRicaDefine(out);
                out.append("\n");
            }
        }
    }

    protected void writeOperator(Appendable out, AltaOperator oper, boolean likeNode) throws IOException {
        out.append(oper.getHeader(likeNode, false));
        out.append(oper.getCode().trim()).append("\n");
        out.append(oper.getBottom(likeNode)).append("\n");
    }

    protected void writeOperators(Appendable out, AltaOperator exception) throws IOException {
        Collection<? extends DBWrap> operators = this.getValues(DBFolder.Family.OPERATOR);
        if (operators != null) {
            DBFolder dbException = exception == null ? null : exception.getDBFolder();
            for (AltaOperator altaOperator : operators) {
                if (altaOperator.getDBFolder().equals(dbException)) continue;
                this.writeOperator(out, altaOperator, false);
                out.append("\n");
            }
        }
    }

    protected void writeNode(Appendable out, AltaComponent node) throws IOException {
        out.append(node.getHeader(false));
        out.append(node.getCode().trim()).append("\n");
        out.append(node.getFooter());
    }

    protected void writeComponents(Appendable out, AltaComponent exception) throws IOException {
        Collection<? extends DBWrap> components = this.getValues(DBFolder.Family.COMPONENT);
        if (components != null) {
            DBFolder dbException = exception == null ? null : exception.getDBFolder();
            for (AltaComponent altaComponent : components) {
                if (altaComponent.getDBFolder().equals(dbException)) continue;
                this.writeNode(out, altaComponent);
                out.append("\n");
            }
        }
    }

    protected void writeEquipments(Appendable out, AltaEquipment exception) throws IOException {
        Collection<? extends DBWrap> equipments = this.getValues(DBFolder.Family.EQUIPMENT);
        if (equipments != null) {
            DBFolder dbException = exception == null ? null : exception.getDBFolder();
            for (AltaEquipment altaEquipment : equipments) {
                if (altaEquipment.getDBFolder().equals(dbException)) continue;
                this.writeNode(out, altaEquipment);
                out.append("\n");
            }
        }
    }

    public String getCRC() {
        return this._crc;
    }

    public File getFile() {
        return this._output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOperator(AltaOperator node, File outputFile) {
        Writer out = null;
        try {
            out = new FileWriter(outputFile);
            out = new BufferedWriter(out);
            this.writeTypes(out);
            this.writeOperators(out, node);
            this.writeOperator(out, node, true);
            this._output = outputFile;
        }
        catch (Exception e) {
            _LOG.log(Level.INFO, "", e);
            this.getErrors().add(new GeneralError<DBFolder>(node.getDBFolder(), e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateComponent(AltaComponent node, File outputFile) {
        Writer out = null;
        try {
            out = new FileWriter(outputFile);
            out = new BufferedWriter(out);
            this.writeTypes(out);
            this.writeOperators(out, null);
            this.writeComponents(out, node);
            this.writeNode(out, node);
            out.append("\n");
            this._output = outputFile;
        }
        catch (Exception e) {
            _LOG.log(Level.INFO, "", e);
            this.getErrors().add(new GeneralError<DBFolder>(node.getDBFolder(), e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEquipment(AltaEquipment node, File outputFile) {
        Writer out = null;
        try {
            out = new FileWriter(outputFile);
            out = new BufferedWriter(out);
            this.writeTypes(out);
            this.writeOperators(out, null);
            this.writeComponents(out, null);
            this.writeEquipments(out, node);
            this.writeNode(out, node);
            out.append("\n");
            this._output = outputFile;
        }
        catch (Exception e) {
            _LOG.log(Level.INFO, "", e);
            this.getErrors().add(new GeneralError<DBFolder>(node.getDBFolder(), e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSystem(AltaSystem node, File outputFile) {
        Writer out = null;
        CRCWriter crcOut = null;
        try {
            out = new FileWriter(outputFile);
            out = new BufferedWriter(out);
            crcOut = new CRCWriter(out);
            this.writeTypes((Appendable)crcOut);
            this.writeOperators((Appendable)crcOut, null);
            this.writeComponents((Appendable)crcOut, null);
            this.writeEquipments((Appendable)crcOut, node);
            AltaConfig config = null;
            if (this._utility != null) {
                config = this._utility.getConfig();
            }
            node.writeNode(crcOut, config);
            this._output = outputFile;
        }
        catch (Exception e) {
            _LOG.log(Level.INFO, "", e);
            this.getErrors().add(new GeneralError<DBFolder>(node.getDBFolder(), e.getMessage()));
        }
        finally {
            if (crcOut != null) {
                try {
                    crcOut.close();
                    this._crc = crcOut.getCRC();
                }
                catch (IOException iOException) {}
            } else if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static interface GenerateAltaRicaCodeUtility {
        public AltaConfig getConfig();

        public static class Default
        implements GenerateAltaRicaCodeUtility {
            AltaConfig _config;

            public Default() {
                this(null);
            }

            public Default(AltaConfig config) {
                this._config = config;
            }

            @Override
            public AltaConfig getConfig() {
                return this._config;
            }
        }
    }

    class Verify<T extends DBWrap>
    extends Recup<DBWrap> {
        Map<String, T> _dic;
        String _msgFormat;

        Verify(DBFolder.Family family, GenerateAltaricaCode generate, String msgFormat) {
            super(family, generate);
            this._dic = new HashMap<String, T>();
            this._msgFormat = msgFormat;
        }

        @Override
        protected String constructName(DBFolder dbFolder, DBWrap t) {
            StringBuilder dbPath = new StringBuilder(64);
            dbFolder.getParent().getPathUntilSystem(dbPath);
            return dbPath.substring(1).replace('/', '_');
        }

        @Override
        protected boolean verifyName(String name, DBFolder dbFolder, DBWrap t) {
            DBWrap altaPrev = (DBWrap)this._dic.get(name);
            if (altaPrev != null && !altaPrev.getDBFolder().equals(dbFolder)) {
                GenerateAltaricaCode.this.getErrors().add(new GeneralError<DBFolder>(dbFolder, ResMsgOcas.msgFormat(this._msgFormat, name, altaPrev.getDBFolder().getRefPath())));
                return false;
            }
            return true;
        }

        @Override
        protected void putName(String name, DBFolder dbFolder, DBWrap t) {
            this._dic.put(name, t);
        }
    }

    class NoVerify<T extends DBWrap>
    extends Recup<DBWrap> {
        NoVerify(DBFolder.Family family, GenerateAltaricaCode generate) {
            super(family, generate);
        }
    }
}

