/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class DBIconRenderer
implements Comparable<DBIconRenderer> {
    private static Logger _LOG = Logger.getLogger(DBIcon.class.getName());
    DBIconRenderer _defaultRenderer = null;
    boolean _dbIconOverload = false;
    DBIcon _dbIcon = null;
    boolean _colorDrawOverload = false;
    Color _colorDraw = Color.black;
    boolean _colorFillOverload = false;
    Color _colorFill = null;
    ImageIcon _imageIcon = null;

    public DBIconRenderer() {
    }

    public DBIconRenderer(boolean overload) {
        this._dbIconOverload = overload;
        this._colorDrawOverload = overload;
        this._colorFillOverload = overload;
    }

    public DBIconRenderer(DBIcon dbIcon) {
        this._dbIcon = dbIcon;
        this._dbIconOverload = dbIcon != null;
    }

    public DBIconRenderer getCopy() {
        DBIconRenderer res = new DBIconRenderer();
        res._defaultRenderer = this._defaultRenderer;
        res._dbIconOverload = this._dbIconOverload;
        res._dbIcon = this._dbIcon;
        res._colorDrawOverload = this._colorDrawOverload;
        res._colorDraw = this._colorDraw;
        res._colorFillOverload = this._colorFillOverload;
        res._colorFill = this._colorFill;
        return res;
    }

    public DBIconRenderer getDefaultRenderer() {
        return this._defaultRenderer;
    }

    public DBIconRenderer setDefaultRenderer(DBIconRenderer defaultRenderer) {
        if (this._defaultRenderer != defaultRenderer) {
            this._defaultRenderer = defaultRenderer;
            this._imageIcon = null;
        }
        return this;
    }

    public boolean isDBIconOverload() {
        return this._dbIconOverload;
    }

    public DBIconRenderer setDBIconOverload(boolean dbIconOverload) {
        if (this._dbIconOverload != dbIconOverload) {
            this._dbIconOverload = dbIconOverload;
            this._imageIcon = null;
        }
        return this;
    }

    public DBIcon getDBIcon() {
        return this._dbIcon;
    }

    public DBIconRenderer setDBIcon(DBIcon dbIcon) {
        if (this._dbIcon != null ? !this._dbIcon.equals(dbIcon) : dbIcon != null) {
            this._dbIcon = dbIcon;
            this._imageIcon = null;
        }
        return this;
    }

    public boolean isColorDrawOverload() {
        return this._colorDrawOverload;
    }

    public DBIconRenderer setColorDrawOverload(boolean colorDrawOverload) {
        if (this._colorDrawOverload != colorDrawOverload) {
            this._colorDrawOverload = colorDrawOverload;
            this._imageIcon = null;
        }
        return this;
    }

    public Color getColorDraw() {
        return this._colorDraw;
    }

    public DBIconRenderer setColorDraw(Color colorDraw) {
        if (this._colorDraw != null ? !this._colorDraw.equals(colorDraw) : colorDraw != null) {
            this._colorDraw = colorDraw;
            this._imageIcon = null;
        }
        return this;
    }

    public boolean isColorFillOverload() {
        return this._colorFillOverload;
    }

    public DBIconRenderer setColorFillOverload(boolean colorFillOverload) {
        if (this._colorFillOverload != colorFillOverload) {
            this._colorFillOverload = colorFillOverload;
            this._imageIcon = null;
        }
        return this;
    }

    public Color getColorFill() {
        return this._colorFill;
    }

    public DBIconRenderer setColorFill(Color colorFill) {
        if (this._colorFill != null ? !this._colorFill.equals(colorFill) : colorFill != null) {
            this._colorFill = colorFill;
            this._imageIcon = null;
        }
        return this;
    }

    public DBIcon collectDBIcon() {
        if (this.isDBIconOverload()) {
            return this.getDBIcon();
        }
        if (this._defaultRenderer != null) {
            return this._defaultRenderer.collectDBIcon();
        }
        return null;
    }

    public Color collectColorDraw() {
        if (this.isColorDrawOverload()) {
            return this.getColorDraw();
        }
        if (this._defaultRenderer != null) {
            return this._defaultRenderer.collectColorDraw();
        }
        return null;
    }

    public Color collectColorFill() {
        if (this.isColorFillOverload()) {
            return this.getColorFill();
        }
        if (this._defaultRenderer != null) {
            return this._defaultRenderer.collectColorFill();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        try {
            DBIcon dbIcon;
            Color color = this.collectColorFill();
            if (color != null) {
                g.setColor(color);
                g.fillRect(x, y, w, h);
            }
            if ((dbIcon = this.collectDBIcon()) != null) {
                ImageIcon icon = dbIcon.getImage();
                Graphics g2D = null;
                try {
                    BufferedImage image = new BufferedImage(w, h, 2);
                    g2D = image.createGraphics();
                    g2D.drawImage(icon.getImage(), 0, 0, w, h, null);
                    g.drawImage((Image)image, x, y, null);
                }
                finally {
                    if (g2D != null) {
                        g2D.dispose();
                    }
                }
            }
            if ((color = this.collectColorDraw()) != null) {
                g.setColor(color);
                g.drawRect(x, y, w, h);
            }
        }
        finally {
            g.setColor(oldColor);
        }
    }

    protected void addRelation(Set<DBRelation> relations, DBFolder folderSrc, String typeSrc) {
        if (this.getDBIcon() == null || this.getDBIcon().getDBFolder() == null) {
            return;
        }
        relations.add(new DBRelation(folderSrc, typeSrc, this.getDBIcon().getDBFolder(), "OA_IMAG"));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this._colorFillOverload) {
            buffer.append(this._colorFill).append(">");
        }
        if (this._dbIconOverload) {
            buffer.append(this._dbIcon).append(">");
        }
        if (this._colorDrawOverload) {
            buffer.append(this._colorDraw).append(">");
        }
        if (!buffer.isEmpty()) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Override
    public int compareTo(DBIconRenderer o) {
        int c = 0;
        c = Boolean.compare(this._colorFillOverload, o._colorFillOverload);
        if (c != 0) {
            return c;
        }
        if (this._colorFill != null) {
            if (o._colorFill == null) {
                return -1;
            }
            c = this._colorFill.getRGB() - o._colorFill.getRGB();
            if (c != 0) {
                return c;
            }
        } else if (o._colorFill != null) {
            return 1;
        }
        if ((c = Boolean.compare(this._dbIconOverload, o._dbIconOverload)) != 0) {
            return c;
        }
        if (this._dbIcon != null) {
            if (o._dbIcon == null) {
                return -1;
            }
            c = this._dbIcon.getRefPath().compareTo(o._dbIcon.getRefPath());
            if (c != 0) {
                return c;
            }
        } else if (o._dbIcon != null) {
            return 1;
        }
        if ((c = Boolean.compare(this._colorDrawOverload, o._colorDrawOverload)) != 0) {
            return c;
        }
        if (this._colorDraw != null) {
            if (o._colorDraw == null) {
                return -1;
            }
            c = this._colorDraw.getRGB() - o._colorDraw.getRGB();
            if (c != 0) {
                return c;
            }
        } else if (o._colorDraw != null) {
            return 1;
        }
        return 0;
    }

    public String toStringCompare() {
        StringBuilder buffer = new StringBuilder();
        if (this._colorFillOverload) {
            buffer.append("\tColor.Fill=");
            if (this._colorFill == null) {
                buffer.append("null");
            } else {
                buffer.append("rgb(").append(this._colorFill.getRed()).append(",").append(this._colorFill.getGreen()).append(",").append(this._colorFill.getBlue()).append(")");
            }
            buffer.append("\n");
        }
        if (this._dbIconOverload) {
            buffer.append("\tIcon=");
            if (this._dbIcon == null) {
                buffer.append("null");
            } else {
                buffer.append(this._dbIcon.getRefPath());
            }
            buffer.append("\n");
        }
        if (this._colorDrawOverload) {
            buffer.append("\tColor.Draw=");
            if (this._colorDraw == null) {
                buffer.append("null");
            } else {
                buffer.append("rgb(").append(this._colorDraw.getRed()).append(",").append(this._colorDraw.getGreen()).append(",").append(this._colorDraw.getBlue()).append(")");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public void toXML(Appendable out, String header, String indent) throws IOException {
        if (Boolean.getBoolean("cecilia.BackwardCompatibility.62x")) {
            DBIcon dbIcon = this.collectDBIcon();
            if (dbIcon != null) {
                out.append(indent).append("<").append(header);
                DBObjectXmlUtility.writeDBFolder(out, dbIcon.getDBFolder(), null);
                out.append("/>\n");
            }
        } else {
            out.append(indent).append("<").append(header);
            if (this._dbIconOverload) {
                if (this._dbIcon != null) {
                    DBObjectXmlUtility.writeDBFolder(out, this._dbIcon.getDBFolder(), null);
                } else {
                    out.append(" ").append("refPath").append("=''");
                }
            }
            if (this._colorDrawOverload) {
                DBObjectXmlUtility.writeAttrColor(out, "border", this._colorDraw != null, this._colorDraw);
            }
            if (this._colorFillOverload) {
                DBObjectXmlUtility.writeAttrColor(out, "filling", this._colorFill != null, this._colorFill);
            }
            out.append("/>\n");
        }
    }

    public File savePNG(File path, int w, int h, double scale) {
        StringBuilder name = new StringBuilder(128);
        DBIcon dbIcon = this.collectDBIcon();
        if (dbIcon != null) {
            name.append("Icon_").append(dbIcon.getDBFolder().getParent().getName()).append("_");
        } else {
            name.append("Icon_color_");
        }
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(name.toString(), ".png", path);
            Graphics2D graph = null;
            int width = (int)((double)(w + 1) * scale);
            int height = (int)((double)(h + 1) * scale);
            BufferedImage image = new BufferedImage(width, height, 1);
            graph = image.createGraphics();
            graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graph.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graph.setClip(0, 0, width, height);
            graph.setColor(Color.white);
            graph.fillRect(0, 0, width, height);
            this.paint(graph, 0, 0, width, height);
            ImageIO.write((RenderedImage)image, "png", tmpFile);
        }
        catch (Throwable th) {
            _LOG.log(Level.INFO, "Probleme lors de la sauvegarde de l'image de simulation : " + this.toString(), th);
            tmpFile = null;
        }
        return tmpFile;
    }

    public synchronized ImageIcon getImage(int w, int h) {
        if (this._imageIcon != null && (this._imageIcon.getIconWidth() + 1 != w || this._imageIcon.getIconHeight() + 1 != h)) {
            this._imageIcon = null;
        }
        if (this._imageIcon == null) {
            BufferedImage image = new BufferedImage(w + 1, h + 1, 1);
            Graphics2D graph = image.createGraphics();
            graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graph.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graph.setColor(Color.white);
            graph.fillRect(0, 0, w + 1, h + 1);
            this.paint(graph, 0, 0, w, h);
            this._imageIcon = new ImageIcon(image);
        }
        return this._imageIcon;
    }
}

