/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractColumnsModel;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaAbstractEventPanel;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaEventListDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AltaEventPanel
extends AltaAbstractEventPanel {
    protected CeciliaAppl _appl;
    protected EventTable _ctrlTable;
    protected EventTableModel _ctrlTableModel;
    CeciliaAction _ctrlAdd;
    CeciliaAction _ctrlDel;
    CeciliaAction _ctrlEdit;
    protected JLabel _eventNameLabel;
    protected JTextField _eventName;
    EventTableEditor _eventNameEditor = new EventTableEditor();
    int _editingRow = -1;

    protected void renameEvent(AltaEvent event, String rename) {
        event.setName(rename);
        this.getAltaComponent().setModified(true);
    }

    @Override
    protected String validateName(String name) {
        if (name.equals("no_event")) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", name), ResMsgVoc.getString("VOC_ERROR"), 0);
            return null;
        }
        return super.validateName(name);
    }

    public AltaEventPanel(CeciliaAppl appl) {
        this._appl = appl;
        this.doCreate();
    }

    private void doCreate() {
        JButton fieldsDlg = new JButton(ResMsgVoc.getString("VOC_FIELDS"));
        this.createActions();
        JToolBar panelEventButton = new JToolBar();
        JPanel panelEventValue = new JPanel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createMainPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)fieldsDlg, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        if (!this._appl.isReader()) {
            this.add((Component)panelEventButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)panelEventValue, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        panelEventButton.add(Box.createHorizontalGlue());
        panelEventButton.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createHorizontalGlue());
        panelEventButton.setFloatable(false);
        this._eventNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._eventName = new JTextField("");
        this._eventName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AltaEventPanel.this.addEvent();
                    AltaEventPanel.this._eventName.requestFocus();
                }
            }
        });
        panelEventValue.setLayout(new GridBagLayout());
        panelEventValue.setBorder(BorderFactory.createEtchedBorder());
        panelEventValue.add((Component)this._eventNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelEventValue.add((Component)this._eventName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._eventNameLabel.setForeground(Color.black);
        this.selectEvent();
        this._ctrlTable.getActionMap().put("DELETE", this._ctrlDel);
        this._ctrlTable.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        fieldsDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<PrefFieldBoolean> originItems = AltaEventPanel.this._ctrlTableModel.getColumns().getOptionnalFields();
                List<PrefFieldBoolean> copyItems = PrefFieldsFactory.clone(originItems);
                if (!PrefFieldsFactory.displayDlgChangeFields(AltaEventPanel.this._ctrlTable, copyItems)) {
                    return;
                }
                boolean change = PrefFieldsFactory.copySelected(copyItems, originItems);
                if (change) {
                    AltaEventPanel.this._ctrlTableModel.getColumns().resetFilterIndexes();
                    AltaEventPanel.this._ctrlTableModel.fireTableChanged(new TableModelEvent(AltaEventPanel.this._ctrlTableModel, -1));
                    AltaEventPanel.this._ctrlTable.updateSorter();
                }
            }
        });
    }

    protected JComponent createMainPanel() {
        this._ctrlTableModel = new EventTableModel();
        this._ctrlTable = new EventTable((AltaAbstractEventPanel.AltaAbstractEventTableModel)this._ctrlTableModel);
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        if (!this._appl.isReader()) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(this._ctrlEdit);
            popupMenu.add(this._ctrlDel);
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    AltaEventPanel.this.selectEvent();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            scrollTable.setComponentPopupMenu(popupMenu);
        }
        return scrollTable;
    }

    @Override
    public void focusTreatment() {
        this.requestFocus();
        this._eventName.requestFocus();
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaEventPanel.this.addEvent();
                AltaEventPanel.this._eventName.requestFocus();
            }
        }.setDesc(ResMsgOcas.getString("CMD_EVENT_ADD"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaEventPanel.this._appl.isReader()) {
                    return;
                }
                AltaEventPanel.this.deleteEvents();
            }
        }.setDesc(ResMsgOcas.getString("CMD_EVENT_DEL"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaEventPanel.this._currentComponent == null) {
                    return;
                }
                AltaEventPanel.this.doEditEvents();
            }
        }.setDesc(ResMsgOcas.getString("CMD_EVENT_EDIT"));
    }

    protected List<AltaEvent> deleteEvents() {
        int[] viewIndices;
        ArrayList<AltaEvent> deletedEvents = new ArrayList<AltaEvent>();
        if (this._currentComponent != null && (viewIndices = this._ctrlTable.getSelectedRows()).length != 0) {
            int[] modelIndices = new int[viewIndices.length];
            for (int i = viewIndices.length - 1; i >= 0; --i) {
                modelIndices[i] = this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
            }
            Arrays.sort(modelIndices);
            List<AltaEvent> events = this.getAltaComponent().getEvents();
            for (int i = modelIndices.length - 1; i >= 0; --i) {
                AltaEvent evt = events.remove(modelIndices[i]);
                if (evt == null) continue;
                deletedEvents.add(evt);
            }
            this._ctrlTable.clearSelection();
            this.refreshTable();
            this.getAltaComponent().setModified(true);
            this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
            this._eventName.setText("");
        }
        return deletedEvents;
    }

    public void doEditEvents() {
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (viewIndices.length == 0) {
            return;
        }
        int[] modelIndices = new int[viewIndices.length];
        ArrayList<AltaEvent> selectEvents = new ArrayList<AltaEvent>(viewIndices.length);
        for (int i = 0; i < viewIndices.length; ++i) {
            modelIndices[i] = this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
            selectEvents.add(this._currentComponent.getEvents().get(modelIndices[i]));
        }
        if (!this.displayDlgEventsEdit(selectEvents, this._appl)) {
            return;
        }
        this.refreshTable();
        ListSelectionModel selectModel = this._ctrlTable.getSelectionModel();
        selectModel.setValueIsAdjusting(true);
        selectModel.clearSelection();
        for (int i = 0; i < modelIndices.length; ++i) {
            int rowView = this._ctrlTable.convertRowIndexToView(modelIndices[i]);
            selectModel.addSelectionInterval(rowView, rowView);
        }
        selectModel.setValueIsAdjusting(false);
        this.getAltaComponent().setModified(true);
        this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
    }

    public void refreshTable() {
        ((AbstractTableModel)this._ctrlTable.getModel()).fireTableDataChanged();
        this._ctrlTable.setRowHeight(20);
    }

    protected AltaEvent getModelEvent(String name) {
        return null;
    }

    public AltaEvent addEvent() {
        if (this._currentComponent == null) {
            return null;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this._currentComponent.getEvents().size() >= DemoLimits.Limit.COMPONENT_EVENTS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgOcas.getString("DEMO_COMPONENT_EVENTS"), JOptionCecilia.getTopTitleOf(this._ctrlTable), 0);
            return null;
        }
        String name = this._eventName.getText();
        if ((name = this.validateName(name)) == null || name.isEmpty()) {
            return null;
        }
        AltaEvent event = this.getModelEvent(name);
        if (event != null) {
            event = event.getCopy();
            event.setName(name);
        } else {
            event = new AltaEvent(name);
            event.initialise(this._appl);
        }
        this._currentComponent.getEvents().add(event);
        int idxModel = this._currentComponent.getEvents().size() - 1;
        this.refreshTable();
        int idxView = this._ctrlTable.convertRowIndexToView(idxModel);
        this._ctrlTable.setRowSelectionInterval(idxView, idxView);
        Rectangle rect = this._ctrlTable.getCellRect(idxView, 0, true);
        this._ctrlTable.scrollRectToVisible(rect);
        this.getAltaComponent().setModified(true);
        this.getAltaComponent().updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
        return event;
    }

    public void selectEvent() {
        int[] indices = this._ctrlTable.getSelectedRows();
        if (indices.length != 0) {
            this._ctrlDel.setEnabled(true);
            this._ctrlEdit.setEnabled(true);
            if (this._currentComponent != null && indices.length == 1) {
                int idx = this._ctrlTable.convertRowIndexToModel(indices[0]);
                this._eventName.setText(this._currentComponent.getEvents().get(idx).getName());
            } else {
                this._eventName.setText("");
            }
        } else {
            this._ctrlEdit.setEnabled(false);
            this._ctrlDel.setEnabled(false);
        }
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this.refreshTable();
    }

    public void updateLangage() {
        this._eventNameLabel.setText(ResMsgVoc.getString("VOC_NAME"));
        this.refreshTable();
        this._ctrlAdd.setName(ResMsgVoc.getString("VOC_ADD"));
        this._ctrlDel.setName(ResMsgVoc.getString("VOC_DELETE"));
        this._ctrlEdit.setName(ResMsgVoc.getString("VOC_EDIT"));
        this._ctrlAdd.setDesc(ResMsgOcas.getString("CMD_EVENT_ADD"));
        this._ctrlDel.setDesc(ResMsgOcas.getString("CMD_EVENT_DEL"));
        this._ctrlEdit.setDesc(ResMsgOcas.getString("CMD_EVENT_EDIT"));
    }

    public JTextField getCtrlEventName() {
        return this._eventName;
    }

    public class EventTableEditor
    extends JTextField {
        boolean enterHasBeenPressed;

        EventTableEditor() {
            super("");
            this.enterHasBeenPressed = false;
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        EventTableEditor.this.enterHasBeenPressed = true;
                        EventTableEditor.this.validText();
                    }
                }
            });
        }

        @Override
        public void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            switch (e.getID()) {
                case 1005: {
                    if (this.enterHasBeenPressed) break;
                    this.validText();
                    break;
                }
                case 1004: {
                    this.enterHasBeenPressed = false;
                }
            }
        }

        public void validText() {
            int rowModel = AltaEventPanel.this._ctrlTable.convertRowIndexToModel(AltaEventPanel.this._editingRow);
            AltaEvent event = AltaEventPanel.this._currentComponent.getEvents().get(rowModel);
            if (!event.getName().equals(this.getText())) {
                String name = AltaEventPanel.this.validateName(this.getText());
                if (name != null) {
                    AltaEventPanel.this._eventName.setText(name);
                    AltaEventPanel.this.renameEvent(event, name);
                }
                AltaEventPanel.this.refreshTable();
                int rowView = AltaEventPanel.this._ctrlTable.convertRowIndexToView(rowModel);
                AltaEventPanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
            }
            if (AltaEventPanel.this._ctrlTable.getCellEditor() != null) {
                AltaEventPanel.this._ctrlTable.getCellEditor().stopCellEditing();
            }
            AltaEventPanel.this._ctrlTable.setEditable(false);
        }
    }

    public class EventTable
    extends AltaAbstractEventPanel.AltaAbstractEventTable {
        public boolean _isEditable;

        public EventTable(AltaAbstractEventPanel.AltaAbstractEventTableModel model) {
            super(model);
            this._isEditable = false;
            this.setRowHeight(20);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    EventTable.this._isEditable = false;
                    if (AltaEventPanel.this._currentComponent != null) {
                        int[] indices = EventTable.this.getSelectedRows();
                        if (indices.length == 1) {
                            int idxModel = EventTable.this.convertRowIndexToModel(indices[0]);
                            AltaEventPanel.this._eventName.setText(AltaEventPanel.this._currentComponent.getEvents().get(idxModel).getName());
                        } else {
                            AltaEventPanel.this._eventName.setText("");
                        }
                    }
                }
            });
        }

        @Override
        protected boolean withSorter() {
            return true;
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            this._isEditable = true;
            int colView = this.columnAtPoint(e.getPoint());
            int colModel = this.convertColumnIndexToModel(colView);
            if (colModel == 0) {
                int rowView;
                AltaEventPanel.this._editingRow = rowView = this.rowAtPoint(e.getPoint());
                this.editCellAt(rowView, colView);
                Component editor = this.getEditorComponent();
                if (editor != null) {
                    editor.requestFocus();
                }
            } else {
                this._isEditable = false;
                AltaEventPanel.this.doEditEvents();
            }
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this._isEditable = false;
            super.editingCanceled(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this._isEditable = false;
            super.editingStopped(e);
        }

        public boolean isEditable() {
            return this._isEditable;
        }

        public void setEditable(boolean editable) {
            this._isEditable = editable;
        }

        @Override
        public void createDefaultColumnsFromModel() {
            super.createDefaultColumnsFromModel();
            TableColumnModel tableCols = this.getColumnModel();
            EventColumnsModel modelCols = AltaEventPanel.this._ctrlTableModel.getColumns();
            for (int c = 0; c < this.getColumnCount(); ++c) {
                TableColumn tableCol = tableCols.getColumn(c);
                int idxModel = this.convertColumnIndexToModel(c);
                int size = ((Number)modelCols.getColumnField(idxModel).getInfo("Width")).intValue();
                tableCol.setPreferredWidth(size * 13);
                if (c != 0) continue;
                tableCol.setCellEditor(new EventTableCellEditor());
                tableCol.setCellRenderer(new EventTableCellRenderer());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            try {
                AltaEventPanel.this.selectEvent();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public class EventTableModel
    extends AltaAbstractEventPanel.AltaAbstractEventTableModel {
        EventTableModel() {
            this._columnModel = this.createColumnsModel();
            PluginWithOptions prefs = AltaEventPanel.this._appl.getPreferencies().getOptions(AltaEventListDisplayPreferencies.PREF_KEY);
            if (prefs == null || !(prefs instanceof AltaEventListDisplayPreferencies)) {
                prefs = new AltaEventListDisplayPreferencies();
                AltaEventPanel.this._appl.getPreferencies().addOptions(prefs);
                prefs.refreshOptions(AltaEventPanel.this._appl.getPlugable());
            }
            List<PrefFieldBoolean> listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
            this._columnModel.setOptionnalFields(PrefFieldsFactory.clone(listPrefs));
        }

        public EventColumnsModel getColumns() {
            return (EventColumnsModel)this._columnModel;
        }

        @Override
        public int getRowCount() {
            if (AltaEventPanel.this.getAltaComponent() == null) {
                return 0;
            }
            return AltaEventPanel.this.getAltaComponent().getEvents().size();
        }

        public AltaEvent getAltaEvent(int i) {
            AltaComponent comp = AltaEventPanel.this.getAltaComponent();
            if (comp == null || i < 0 || i > comp.getEvents().size()) {
                return null;
            }
            return AltaEventPanel.this.getAltaComponent().getEvents().get(i);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaEventPanel.this.getAltaComponent() == null) {
                return "null";
            }
            switch (this._columnModel.getColumnField(col).getIdxCode()) {
                case 1: {
                    return AltaEventPanel.this.getAltaComponent().getEvents().get(row).getName();
                }
                case 100: {
                    return StringUtilities.escapeCR((String)AltaEventPanel.this.getAltaComponent().getEvents().get(row).getLabel());
                }
                case 101: {
                    AltaEvent event = AltaEventPanel.this.getAltaComponent().getEvents().get(row);
                    return event.getModelLaw();
                }
                case 102: {
                    AltaEvent event = AltaEventPanel.this.getAltaComponent().getEvents().get(row);
                    Law law = null;
                    DBModelLaw dbModelLaw = event.getModelLaw();
                    if (dbModelLaw != null) {
                        law = dbModelLaw.getLaw();
                    }
                    if (law == null) {
                        law = event.getOccurrence();
                    }
                    return law;
                }
                case 103: {
                    AltaEvent event = AltaEventPanel.this.getAltaComponent().getEvents().get(row);
                    return event.getInspected();
                }
                case 104: {
                    AltaEvent event = AltaEventPanel.this.getAltaComponent().getEvents().get(row);
                    return event.getInflightTested();
                }
                case 110: {
                    AltaEvent event = AltaEventPanel.this.getAltaComponent().getEvents().get(row);
                    String attributes = event.getAttributesAsDisplayedString();
                    if (attributes == null || attributes.isEmpty()) {
                        return "-";
                    }
                    return attributes;
                }
                case 111: {
                    AltaEvent event = AltaEventPanel.this.getAltaComponent().getEvents().get(row);
                    Set<Param> params = event.recupParams(new LinkedHashSet<Param>(), new FctParamSelect.FctParamFMEA());
                    return ParamFMEA.transcodeCollections(params);
                }
            }
            return " ";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (AltaEventPanel.this._appl.isReader()) {
                return false;
            }
            if (AltaEventPanel.this._ctrlTable.getSelectedRows().length != 1) {
                return false;
            }
            if (!AltaEventPanel.this._ctrlTable.isEditable()) {
                return false;
            }
            return col == 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }

        @Override
        protected ItemAbstractColumnsModel createColumnsModel() {
            return new EventColumnsModel();
        }
    }

    protected static class EventColumnsModel
    extends ItemAbstractColumnsModel {
        PrefFieldBoolean _nameItem = new PrefFieldBoolean(ResMsgVoc.getString("VOC_NAME"), "nom", 1, 10, "L");

        public EventColumnsModel() {
            this.init();
        }

        @Override
        public List<PrefFieldBoolean> createOptionnalFields() {
            return AltaAbstractEventPanel.createFields();
        }

        @Override
        public void setOptionnalFields(List<PrefFieldBoolean> optionnalFields) {
            this._optionnalFields = optionnalFields;
            this._items.clear();
            this._items.add(this._nameItem);
            for (PrefFieldBoolean item : this._optionnalFields) {
                this._items.add(item);
            }
            this.resetFilterIndexes();
        }
    }

    public class EventTableCellEditor
    extends DefaultCellEditor {
        EventTableCellEditor() {
            super(AltaEventPanel.this._eventNameEditor);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowView, int colView) {
            if (rowView != -1 && table.convertColumnIndexToModel(colView) == 0) {
                AltaEvent event = AltaEventPanel.this._currentComponent.getEvents().get(table.convertRowIndexToModel(rowView));
                AltaEventPanel.this._eventNameEditor.setText(event.getName());
                return AltaEventPanel.this._eventNameEditor;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, rowView, colView);
        }
    }

    public class EventTableCellRenderer
    extends DefaultTableCellRenderer {
        public EventTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel object = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            AltaEvent event = AltaEventPanel.this._currentComponent.getEvents().get(row);
            if (event.getOccurrence() == null && event.getModelLaw() == null) {
                object.setIcon(ResIcoCore.getImageIcon("VIDE_PI"));
            } else {
                object.setIcon(ResIcoOcas.getImageIcon("EVENT_PROPERTIES"));
            }
            return object;
        }
    }
}

