/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.ColorButton;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.icon.gui.IconDlgChooser;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AltaIconAndSizeDlg
extends JDialogCecilia {
    private static final String ICON_KEEP_PROPORTION_KEY = AltaIconAndSizeDlg.class.getName() + "#KeyKeepProportion";
    private CeciliaAppl _application;
    private DBIcon _currentIcon = null;
    private JLabel _widthLabel = new JLabel(ResMsgVoc.getString("VOC_WIDTH") + " : ");
    private JLabel _heightLabel = new JLabel(ResMsgVoc.getString("VOC_HEIGHT") + " : ");
    private JTextField _width = new JTextField(Integer.toString(80));
    private JTextField _height = new JTextField(Integer.toString(80));
    private JCheckBox _keepProportion = new JCheckBox(ResMsgOcas.getString("ICON_KEEP_PROPRTION"));
    private JLabel _iconLabel = new JLabel(ResMsgOcas.getString("MODEL_EDIT_FILE_ICON") + " : ");
    private JTextField _iconFile = new JTextField("");
    private JButton _selectIconButton = new JButton("...");
    private JCheckBox _drawBorderOption = new JCheckBox(ResMsgOcas.getString("MODEL_EDIT_DRAW_BORDER"), true);
    private ColorButton _ctrlColorDraw = new ColorButton(ResMsgVoc.getString("VOC_LINE"));
    private JCheckBox _fillBorderOption = new JCheckBox(ResMsgOcas.getString("MODEL_EDIT_FILL_BORDER"), false);
    private ColorButton _ctrlColorFill = new ColorButton(ResMsgVoc.getString("VOC_FILLING"));
    private JCheckBox _autoMovePortOption = new JCheckBox(ResMsgOcas.getString("MODEL_EDIT_FLOW_AUTO_MOVA"), true);
    private static IconDlgChooser _dlgIcon = null;
    private static Object _lockerDlgIcon = new Object();
    String _oldValueForFocusWidth;
    String _oldValueForFocusHeight;

    public AltaIconAndSizeDlg(Window win, CeciliaAppl appl) {
        super(win, true);
        this._application = appl;
        this.setTitle(ResMsgOcas.getString("TITLE_SIZE_ICON"));
        this.make();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    private void make() {
        this.createCtrls();
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this._widthLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        topPanel.add((Component)this._width, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        topPanel.add((Component)this._heightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        topPanel.add((Component)this._height, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        topPanel.add((Component)this._keepProportion, new GridBagConstraints(2, 1, 1, 2, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        rightPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        rightPanel.add((Component)this._iconLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        rightPanel.add((Component)this._iconFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        rightPanel.add((Component)this._selectIconButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)this._drawBorderOption, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        if (!Boolean.getBoolean("cecilia.BackwardCompatibility.62x")) {
            bottomPanel.add((Component)this._ctrlColorDraw, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
            bottomPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            bottomPanel.add((Component)this._fillBorderOption, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
            bottomPanel.add((Component)this._ctrlColorFill, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
            rightPanel.add((Component)bottomPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        } else {
            rightPanel.add((Component)bottomPanel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        }
        rightPanel.add((Component)this._autoMovePortOption, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)rightPanel, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this._keepProportion.setSelected(Boolean.parseBoolean(this._application.getPlugable().getOption(ICON_KEEP_PROPORTION_KEY)));
        this.init();
        this.pack();
    }

    private void createCtrls() {
        this._width.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AltaIconAndSizeDlg.this._oldValueForFocusWidth = AltaIconAndSizeDlg.this._width.getText().trim();
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                AltaIconAndSizeDlg.this.doFocusLostWidth();
                super.focusLost(e);
            }
        });
        this._height.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AltaIconAndSizeDlg.this._oldValueForFocusHeight = AltaIconAndSizeDlg.this._height.getText().trim();
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                AltaIconAndSizeDlg.this.doFocusLostHeight();
                super.focusLost(e);
            }
        });
        this._selectIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IconDlgChooser dlg = AltaIconAndSizeDlg.this.createIconDlgChooser();
                DBIcon dbIcon = AltaIconAndSizeDlg.this._currentIcon;
                if (dbIcon != null) {
                    dlg.setSelectFolder(dbIcon.getDBFolder());
                }
                dlg.setVisible(true);
                if (!dlg.getResult()) {
                    return;
                }
                DBFolder dbFolder = dlg.getSelectFolder();
                if (dbFolder == null) {
                    return;
                }
                DBWrap dbWrap = AltaIconAndSizeDlg.this._application.getDAOFactory().findOrCreateWrap(dbFolder);
                if (dbWrap == null) {
                    return;
                }
                dbIcon = (DBIcon)dbWrap;
                ImageIcon image = dbIcon.getImage();
                if (image != null) {
                    AltaIconAndSizeDlg.this._width.setText(Integer.toString(image.getIconWidth()));
                    AltaIconAndSizeDlg.this._height.setText(Integer.toString(image.getIconHeight()));
                    AltaIconAndSizeDlg.this._iconFile.setText(dbFolder.getRefPath());
                    AltaIconAndSizeDlg.this._currentIcon = dbIcon;
                }
            }
        });
        this._iconFile.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String dbPath = AltaIconAndSizeDlg.this._iconFile.getText().trim();
                DBIcon dbIcon = null;
                if (!dbPath.isEmpty()) {
                    ImageIcon image;
                    dbIcon = AltaIconAndSizeDlg.this.verifyDBIcon(dbPath);
                    if (dbIcon == null) {
                        if (AltaIconAndSizeDlg.this._currentIcon == null) {
                            AltaIconAndSizeDlg.this._iconFile.setText("");
                        } else {
                            AltaIconAndSizeDlg.this._iconFile.setText(AltaIconAndSizeDlg.this._currentIcon.getRefPath());
                        }
                    } else if (dbIcon.equals(AltaIconAndSizeDlg.this._currentIcon)) {
                        dbIcon = null;
                    }
                    if (dbIcon != null && (image = dbIcon.getImage()) != null) {
                        AltaIconAndSizeDlg.this._width.setText(Integer.toString(image.getIconWidth()));
                        AltaIconAndSizeDlg.this._height.setText(Integer.toString(image.getIconHeight()));
                    }
                }
                super.focusLost(e);
            }
        });
        this._drawBorderOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaIconAndSizeDlg.this._ctrlColorDraw.setEnabled(AltaIconAndSizeDlg.this._drawBorderOption.isSelected());
            }
        });
        this._fillBorderOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaIconAndSizeDlg.this._ctrlColorFill.setEnabled(AltaIconAndSizeDlg.this._fillBorderOption.isSelected());
            }
        });
    }

    protected void doFocusLostWidth() {
        if (this._keepProportion.isSelected()) {
            try {
                String curValue = this._width.getText().trim();
                int old1 = Integer.parseInt(this._oldValueForFocusWidth);
                int cur1 = Integer.parseInt(curValue);
                if (old1 == cur1) {
                    return;
                }
                double coef = (double)old1 / (double)cur1;
                int old2 = Integer.parseInt(this._height.getText().trim());
                int cur2 = (int)((double)old2 / coef);
                this._height.setText(Integer.toString(cur2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void doFocusLostHeight() {
        if (this._keepProportion.isSelected()) {
            try {
                String curValue = this._height.getText().trim();
                int old1 = Integer.parseInt(this._oldValueForFocusHeight);
                int cur1 = Integer.parseInt(curValue);
                if (old1 == cur1) {
                    return;
                }
                double coef = (double)old1 / (double)cur1;
                int old2 = Integer.parseInt(this._width.getText().trim());
                int cur2 = (int)((double)old2 / coef);
                this._width.setText(Integer.toString(cur2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    DBIcon verifyDBIcon(String dbPath) {
        DBWrap dbWrap;
        DBFolder dbFolder;
        if (!dbPath.isEmpty() && (dbFolder = this._application.getDAOFactory().createFolderDAO().findFolder(DBFolder.Family.IMAG.getRootName(), dbPath)) != null && (dbWrap = this._application.getDAOFactory().findOrCreateWrap(dbFolder)) != null) {
            return (DBIcon)dbWrap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IconDlgChooser createIconDlgChooser() {
        if (_dlgIcon == null) {
            Object object = _lockerDlgIcon;
            synchronized (object) {
                IconDlgChooser dlg = null;
                if (_dlgIcon == null) {
                    Window win = SwingUtilities.getWindowAncestor(this);
                    dlg = new IconDlgChooser(win, this._application);
                }
                if (dlg != null && _dlgIcon == null) {
                    _dlgIcon = dlg;
                }
            }
        }
        return _dlgIcon;
    }

    public void copyToCtrl(AltaComponent currentComponent) {
        Color drawColor = currentComponent.getIconRenderer().getColorDraw();
        this._drawBorderOption.setSelected(drawColor != null);
        this._ctrlColorDraw.setColor(drawColor != null ? drawColor : Color.black);
        this._ctrlColorDraw.setEnabled(this._drawBorderOption.isSelected());
        Color fillColor = currentComponent.getIconRenderer().getColorFill();
        this._fillBorderOption.setSelected(fillColor != null);
        this._ctrlColorFill.setColor(fillColor != null ? fillColor : Color.white);
        this._ctrlColorFill.setEnabled(this._fillBorderOption.isSelected());
        this._autoMovePortOption.setSelected(currentComponent.isAutoMovePort());
        this._width.setText(Integer.toString(currentComponent.getWidth()));
        this._height.setText(Integer.toString(currentComponent.getHeight()));
        this._currentIcon = currentComponent.getIconRenderer().getDBIcon();
        this._iconFile.setText(this._currentIcon == null ? "" : this._currentIcon.getRefPath());
    }

    @Override
    protected void validDialog() {
        if (this._width.hasFocus()) {
            this.doFocusLostWidth();
        } else if (this._height.hasFocus()) {
            this.doFocusLostHeight();
        }
        super.validDialog();
        if (this.getResult()) {
            this._application.getPlugable().setOption(ICON_KEEP_PROPORTION_KEY, Boolean.toString(this._keepProportion.isSelected()));
        }
    }

    @Override
    protected boolean verifyParameters() {
        block12: {
            int value;
            block11: {
                if (this._width.getText().trim().isEmpty()) {
                    try {
                        value = Integer.parseInt(this._width.getText().trim());
                        if (value < 9) {
                        }
                    }
                    catch (NumberFormatException e) {}
                    break block11;
                    JOptionPane.showMessageDialog(this._width, "Entier >= 5 attendu");
                    this._width.requestFocus();
                    return false;
                }
            }
            if (this._height.getText().trim().isEmpty()) {
                try {
                    value = Integer.parseInt(this._height.getText().trim());
                    if (value < 5) {
                    }
                }
                catch (NumberFormatException e) {}
                break block12;
                JOptionPane.showMessageDialog(this._height, "Entier >= 5 attendu");
                this._height.requestFocus();
                return false;
            }
        }
        String dbPath = this._iconFile.getText().trim();
        if (dbPath.isEmpty()) {
            this._currentIcon = null;
        } else {
            DBIcon dbIcon = this.verifyDBIcon(dbPath);
            if (dbIcon == null || dbIcon.getImage() == null) {
                JOptionPane.showMessageDialog(this._iconFile, "Icon invalide");
                this._iconFile.requestFocus();
                return false;
            }
            this._currentIcon = dbIcon;
        }
        return true;
    }

    public Color getColorDraw() {
        if (this._drawBorderOption.isSelected()) {
            return this._ctrlColorDraw.getColor();
        }
        return null;
    }

    public Color getColorFill() {
        if (this._fillBorderOption.isSelected()) {
            return this._ctrlColorFill.getColor();
        }
        return null;
    }

    public boolean isAutoMovePort() {
        return this._autoMovePortOption.isSelected();
    }

    public int getIconWidth() {
        if (this._width.getText().trim().isEmpty()) {
            return -1;
        }
        try {
            int value = Integer.parseInt(this._width.getText().trim());
            if (value < 9) {
                return -1;
            }
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getIconHeight() {
        if (this._height.getText().trim().isEmpty()) {
            return -1;
        }
        try {
            int value = Integer.parseInt(this._height.getText().trim());
            if (value < 9) {
                return -1;
            }
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public DBIcon getIcon() {
        return this._currentIcon;
    }
}

