/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.io;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.attrib.DBAttribUtility;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.DBIconRenderer;
import com.dassault.cecilia.dbobj.mbsa.component.io.LawParserOcas51;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DBComponentReaderRaw
extends DBNodeReaderRaw {
    private static Logger _LOG = Logger.getLogger(DBComponentReaderRaw.class.getPackage().getName());
    protected AltaFileHeader _properties;
    String _name;
    String _typeModel;
    int _width;
    int _height;
    boolean _drawBorder;
    boolean _autoMovePort;
    int _portIdSeqValue;
    DBIcon _dbIcon;
    String _defEquipment;
    protected Map<String, AltaFlow> _mapPorts = new LinkedHashMap<String, AltaFlow>();
    protected Map<String, AltaState> _mapStates = new LinkedHashMap<String, AltaState>();
    protected Map<String, AltaEvent> _mapEvents = new LinkedHashMap<String, AltaEvent>();
    private Map<Integer, AlgaSheet> _mapSheets = new TreeMap<Integer, AlgaSheet>();
    List<DBIconRenderer> _lstSimuls = new ArrayList<DBIconRenderer>();
    boolean _logInfoSheetWithoutName = false;
    LawParser _lawParser = null;
    CECFactory _cecFactory = null;
    static Object _lockLawParser = new Object();
    protected static final Pattern FRB_PATH = Pattern.compile("(/)?[^/]+(/[^/]+){4}(/[0-9]+)?");
    private DBFolder _dbRootIcons = null;

    public DBComponentReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        super(dbFolder, logMng);
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._typeModel;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getPortSeq() {
        return this._portIdSeqValue;
    }

    public boolean getDrawBorder() {
        return this._drawBorder;
    }

    public boolean getAutoMovePort() {
        return this._autoMovePort;
    }

    public DBIcon getIcon() {
        return this._dbIcon;
    }

    @Override
    public AltaFileHeader getProperties() {
        return this._properties;
    }

    @Override
    public Collection<AltaFlow> getFlows() {
        return this._mapPorts.values();
    }

    public Collection<AltaState> getStates() {
        return this._mapStates.values();
    }

    public Collection<AltaEvent> getEvents() {
        return this._mapEvents.values();
    }

    public Collection<AlgaSheet> getSheets() {
        return this._mapSheets.values();
    }

    public Collection<DBIconRenderer> getSimuls() {
        return this._lstSimuls;
    }

    @Override
    public boolean readRaw(String data, CECFactory cecFactory) throws IOException {
        String line;
        BufferedReader inData = new BufferedReader(new StringReader(data));
        boolean bReadNodeBalise = false;
        while ((line = inData.readLine()) != null) {
            int position = line.indexOf("<");
            if (position == -1) continue;
            if (line.indexOf("<header") != -1) {
                this._properties = AltaFileHeader.loadFromFile(inData);
                continue;
            }
            if (line.indexOf("<sheet") != -1) {
                this.readSheet(line);
                continue;
            }
            if (bReadNodeBalise && line.indexOf("<law>") == 0) {
                this.readLaw(inData, line);
                continue;
            }
            if (bReadNodeBalise && line.indexOf("<defEquipment") == 0) {
                this.readContent(inData, line, "/defEquipment", cecFactory);
                continue;
            }
            if ((position = (line = line.substring(position + 1)).indexOf(" ")) != -1) {
                String field = line.substring(0, position);
                if (!bReadNodeBalise) {
                    if (!field.equals("model")) continue;
                    bReadNodeBalise = this.readModel(line, position);
                    continue;
                }
                if (field.equals("icon")) {
                    this.readIcon(line, cecFactory);
                    continue;
                }
                if (field.equals("simul")) {
                    this.readSimul(line, cecFactory);
                    continue;
                }
                if (field.equals("state")) {
                    this.readState(line, cecFactory);
                    continue;
                }
                if (field.equals("event")) {
                    this.readEvent(line, cecFactory);
                    continue;
                }
                if (field.equals("event_properties")) {
                    this.readEventProperties(inData, line, cecFactory);
                    continue;
                }
                if (field.equals("synchro")) {
                    this.readSync(inData, line, cecFactory);
                    continue;
                }
                if (field.equals("operatorId")) {
                    this.readOperatorId(line, cecFactory);
                    continue;
                }
                if (!field.equals("port")) continue;
                this.readPort(line, cecFactory);
                continue;
            }
            if (line.indexOf("/model") != 0) continue;
        }
        if (this._properties == null) {
            this._properties = new AltaFileHeader();
        }
        if (this._name == null) {
            return false;
        }
        if (this._typeModel == null) {
            return false;
        }
        return this._code != null;
    }

    protected void readContent(BufferedReader inData, String line, String endBalise, CECFactory cecFactory) throws IOException {
        throw new IOException("Internal error : Pas de contenu au niveau d'un composant !");
    }

    protected void readSync(BufferedReader inData, String line, CECFactory cecFactory) throws IOException {
        throw new IOException("Internal error : Pas de synchro au niveau d'un composant !");
    }

    private boolean readModel(String line, int position) {
        String name = "";
        String typeModel = "";
        int width = -1;
        int height = -1;
        boolean drawBorder = true;
        boolean autoMovePort = true;
        int portIdSeqValue = -1;
        if ((position = (line = line.substring(position)).indexOf("name=")) != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("type=")) != -1) {
            typeModel = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("width=")) != -1) {
            width = CoreUtil.searchValue(line.substring(position));
        }
        if ((position = line.indexOf("height=")) != -1) {
            height = CoreUtil.searchValue(line.substring(position));
        }
        if ((position = line.indexOf("noBorder")) != -1) {
            drawBorder = false;
        }
        if ((position = line.indexOf("autoMovePort=")) != -1) {
            autoMovePort = Boolean.valueOf(CoreUtil.searchString(line.substring(position)));
        }
        if ((position = line.indexOf("portIdSeqValue")) != -1) {
            portIdSeqValue = CoreUtil.searchValue(line.substring(position));
        }
        if (!name.equals("") && !typeModel.equals("") && width != -1 && height != -1) {
            this._name = name;
            this._typeModel = typeModel;
            this._width = width;
            this._height = height;
            this._drawBorder = drawBorder;
            this._autoMovePort = autoMovePort;
            this._portIdSeqValue = portIdSeqValue;
            return true;
        }
        return false;
    }

    protected void readSheet(String line) {
        int number = Integer.parseInt(CoreUtil.searchString(line, "number="));
        int order = Integer.parseInt(CoreUtil.searchString(line, "order="));
        boolean selected = Boolean.valueOf(CoreUtil.searchString(line, "selected="));
        boolean visible = Boolean.valueOf(CoreUtil.searchString(line, "visible="));
        Object name = null;
        if (line.indexOf("name=") != -1) {
            name = CoreUtil.searchString(line, "name=");
        }
        if (name == null) {
            if (!this._logInfoSheetWithoutName) {
                this._logInfoSheetWithoutName = true;
                this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.getString("MSG_RAW_SHEET_NONAME"));
            }
            this.logMsg(Level.FINE, "Le calque n\u00b0" + number + " n'a pas de nom. => utilisation d'un nom par defaut");
            name = ResMsgVoc.getString("VOC_LAYER") + " " + number;
        }
        AlgaSheet sheet = new AlgaSheet(number, (String)name, order, selected, visible);
        this._mapSheets.put(number, sheet);
    }

    protected AlgaSheet getSheet(int sheetLocation) {
        AlgaSheet sheet = this._mapSheets.get(sheetLocation);
        if (sheet != null) {
            return sheet;
        }
        this.logMsg(Level.INFO, "Le calque n\u00b0" + sheetLocation + " n'a pas ete declaree au prealable\n  (utilisation d'une solution de secours)");
        for (AlgaSheet current : this._mapSheets.values()) {
            if (sheet == null) {
                sheet = current;
            }
            if (!current.isSelected() || !current.isVisible()) continue;
            return current;
        }
        if (sheet == null) {
            this.logMsg(Level.FINE, "Il n'y a pas de calque");
            sheet = new AlgaSheet(1, "Default layeur", 1, true, true);
            this._mapSheets.put(1, sheet);
        }
        return sheet;
    }

    private void readState(String line, CECFactory cecFactory) {
        String name = "";
        String type = "";
        String value = "";
        long typeId = -1L;
        int position = line.indexOf("name=");
        if (position != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("type=")) != -1) {
            type = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("default=")) != -1) {
            value = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("typeId=")) != -1 && (typeId = (long)CoreUtil.searchValue(line.substring(position))) != -1L && (typeId = cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(typeId)) == -1L) {
            this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", typeId));
        }
        if (!(name.isEmpty() || type.isEmpty() && typeId == -1L)) {
            AltaType altaType = null;
            if (!type.isEmpty()) {
                altaType = AltaTypeParser.getType(type);
            }
            if (altaType == null) {
                altaType = AltaTypeParser.getDBType(type, typeId, cecFactory);
            }
            if (altaType == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_TYPE_VARIABLE", name, type));
                altaType = AltaTypeBool.getInstance();
                value = "false";
            }
            this._mapStates.put(name, new AltaState(name, altaType, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LawParser createLawParser(CECFactory cecFactory) {
        if (this._lawParser == null || cecFactory != this._cecFactory) {
            Object object = _lockLawParser;
            synchronized (object) {
                LawParserOcas51 lawParser = null;
                if (this._lawParser == null || cecFactory != this._cecFactory) {
                    this._lawParser = null;
                    this._cecFactory = cecFactory;
                    lawParser = new LawParserOcas51(cecFactory.getLawManager(), cecFactory);
                }
                if (this._lawParser == null) {
                    this._lawParser = lawParser;
                }
            }
        }
        return this._lawParser;
    }

    private void readEvent(String line, CECFactory cecFactory) {
        String name = "";
        String occurrence = "";
        int position = line.indexOf("name=");
        if (position != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("occurrence=")) != -1) {
            occurrence = CoreUtil.searchString(line.substring(position));
        }
        if (!name.isEmpty()) {
            AltaEvent event = new AltaEvent(name);
            if (occurrence != null && !occurrence.isEmpty()) {
                LawParser lawParser = this.createLawParser(cecFactory);
                Law law = lawParser.parseLaw(occurrence);
                if (law != null) {
                    event.setOccurrence(law);
                } else {
                    lawParser.traceError(this._logManager, name, occurrence, _LOG, true);
                }
            }
            this._mapEvents.put(name, event);
        }
    }

    protected void readEventProperties(BufferedReader inData, String line, CECFactory cecFactory) throws IOException {
        AltaEvent event;
        Param param;
        LawParser lawParser;
        String parValue;
        String name = "";
        Param inspected = null;
        Param inflight_tested = null;
        int position = line.indexOf("event_name=");
        if (position != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("inspected=")) != -1) {
            parValue = CoreUtil.searchString(line.substring(position));
            lawParser = this.createLawParser(cecFactory);
            param = lawParser.parseParam(parValue);
            if (param != null) {
                param.setType(TypeParam.DELAY);
                inspected = param;
            } else {
                lawParser.traceError(this._logManager, name, parValue, _LOG, false);
            }
        }
        if ((position = Math.max(line.indexOf("inflight-tested="), line.indexOf("inflighttested="))) != -1) {
            parValue = CoreUtil.searchString(line.substring(position));
            lawParser = this.createLawParser(cecFactory);
            param = lawParser.parseParam(parValue);
            if (param != null) {
                param.setType(TypeParam.DELAY);
                inflight_tested = param;
            } else {
                lawParser.traceError(this._logManager, name, parValue, _LOG, false);
            }
        }
        if ((event = this.getOrCreateEvent(name)) != null) {
            event.setInspected(inspected);
            event.setInflightTested(inflight_tested);
            this.readEventProperties(inData, event, cecFactory);
        }
    }

    protected AltaEvent getOrCreateEvent(String name) {
        return this._mapEvents.get(name);
    }

    protected DBModelLaw readDBModelLawFromPath(String path, CECFactory cecFactory, String name) {
        DBFolder dbFolder = cecFactory.createFolderDAO().findFolder("LAW_MODELS", path);
        if (dbFolder == null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_UNKNOWN", path, name));
        } else {
            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_READ", dbFolder.getRefPath(), name));
            } else {
                return (DBModelLaw)dbWrap;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEventProperties(BufferedReader inData, AltaEvent event, CECFactory cecFactory) throws IOException {
        ArrayList<DBAttrib.Value> attributes = new ArrayList<DBAttrib.Value>();
        event.removeAllAttributes();
        try {
            String line;
            while ((line = inData.readLine()) != null) {
                if (line.indexOf("</event_properties>") != -1) {
                    break;
                }
                if (line.indexOf("<attribute") != -1) {
                    String description = CoreUtil.searchString(line, "value=");
                    Attr attr = DBAttribUtility.checkEventAttribute(description);
                    if (attr == null) {
                        this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_FORMAT_WITH_EVT", description, event.getName()));
                    } else {
                        DBFolder dbFolder = cecFactory.createFolderDAO().findFolder("ATTRIBUTES", attr.getKey().getName());
                        if (dbFolder == null) {
                            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNKNOWN_WITH_EVT", attr.getKey().getName(), event.getName()));
                        } else {
                            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
                            if (dbWrap == null) {
                                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ_WITH_EVT", attr.getKey().getName(), event.getName()));
                            } else {
                                DBAttrib dbAttrib = (DBAttrib)dbWrap;
                                DBAttrib.Value dbValue = dbAttrib.createInstance(dbAttrib.correctRAWValue(attr.getValue()));
                                if (dbValue == null) {
                                    this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNCOMPATIBLE_WITH_EVT", description, event.getName()));
                                } else {
                                    attributes.add(dbValue);
                                }
                            }
                        }
                    }
                }
                if (line.indexOf("<law") != -1) {
                    String value = CoreUtil.searchString(line, "value=");
                    if (line.indexOf("eventModelId=") != -1) {
                        long idBTP = -1L;
                        try {
                            int idOldObjBTP = Integer.parseInt(CoreUtil.searchString(line, "eventModelId="));
                            idBTP = cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(idOldObjBTP);
                            if (idBTP == -1L) {
                                this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", idOldObjBTP));
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.logMsg(Level.WARNING, "L'attribut 'eventModelId' n'est pas un entier");
                        }
                        DBFolder dbFolder = cecFactory.createFolderDAO().findFolder(idBTP, value, "LAW_MODELS");
                        if (dbFolder == null) {
                            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_UNKNOWN", value, event.getName()));
                        } else {
                            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
                            if (dbWrap == null) {
                                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_READ", dbFolder.getRefPath(), event.getName()));
                            } else {
                                event.setModelLaw((DBModelLaw)dbWrap);
                            }
                        }
                    } else if (value != null && !value.isEmpty()) {
                        if (FRB_PATH.matcher(value).matches()) {
                            DBModelLaw dbModelLaw = this.readDBModelLawFromPath(value, cecFactory, event.getName());
                            if (dbModelLaw != null) {
                                event.setModelLaw(dbModelLaw);
                            }
                        } else {
                            LawParser lawParser = this.createLawParser(cecFactory);
                            Law law = lawParser.parseLaw(value);
                            if (law != null) {
                                event.setOccurrence(law);
                            } else {
                                lawParser.traceError(this._logManager, event.getName(), value, _LOG, true);
                            }
                        }
                    }
                }
                if (line.indexOf("<comment>") == -1) continue;
                String comment = this.readText(inData, line, "</comment>");
                if (comment.startsWith("\n") && comment.endsWith("\n") && comment.length() >= 2) {
                    comment = comment.substring(1, comment.length() - 1);
                }
                event.setLabel(comment);
            }
        }
        finally {
            event.setAttributes(attributes);
        }
    }

    private void readPort(String line, CECFactory cecFactory) {
        int id = -1;
        String name = "";
        int x = -1;
        int y = -1;
        String type = "";
        String direction = "";
        AltaFlow.Orientation orientation = null;
        long typeId = -1L;
        int position = line.indexOf("id=");
        if (position != -1) {
            id = CoreUtil.searchValue(line.substring(position));
        }
        if (id == -1) {
            id = ++this._portIdSeqValue;
        }
        if ((position = line.indexOf("name=")) != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("type=")) != -1) {
            type = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("direction=")) != -1) {
            direction = CoreUtil.searchString(line.substring(position));
            orientation = AltaFlow.Orientation.valueOf(direction.toUpperCase());
        }
        if ((position = line.indexOf("x=")) != -1) {
            x = CoreUtil.searchValue(line.substring(position));
        }
        if ((position = line.indexOf("y=")) != -1) {
            y = CoreUtil.searchValue(line.substring(position));
        }
        if ((position = line.indexOf("idExternLaetitia=")) != -1) {
            CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("typeId=")) != -1 && (typeId = (long)CoreUtil.searchValue(line.substring(position))) != -1L && (typeId = cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(typeId)) == -1L) {
            this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", typeId));
        }
        if (!(name.isEmpty() || type.isEmpty() && typeId == -1L || x == -1 || y == -1)) {
            AltaType altaType = null;
            if (!type.isEmpty()) {
                altaType = AltaTypeParser.getType(type);
            }
            if (altaType == null) {
                altaType = AltaTypeParser.getDBType(type, typeId, cecFactory);
            }
            if (altaType == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_TYPE_VARIABLE", name, type));
                altaType = AltaTypeBool.getInstance();
            }
            if (orientation == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_PORT_ORIENTATION", name));
                orientation = AltaFlow.Orientation.IN;
            }
            AltaFlow flow = new AltaFlow(name, altaType);
            flow.setX(x).setY(y).setOrientation(orientation).setID(id);
            this._mapPorts.put(name, flow);
        }
    }

    protected DBIcon readImag(String line, CECFactory cecFactory) {
        DBFolder dbFolder;
        String name = "";
        int position = line.indexOf("name=");
        if (position != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        if (name.isEmpty()) {
            return null;
        }
        DAOFolder daoFolder = cecFactory.createFolderDAO();
        if (this._dbRootIcons == null) {
            this._dbRootIcons = daoFolder.getRootID("IMAGE_FAMILIES");
        }
        if ((dbFolder = daoFolder.findFolder(this._dbRootIcons, name, true)) == null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_ICONE_UNKNOWN", name));
        } else if (dbFolder != null) {
            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_ICONE_READ", dbFolder.getRefPath()));
            } else {
                return (DBIcon)dbWrap;
            }
        }
        return null;
    }

    private void readIcon(String line, CECFactory cecFactory) {
        DBIcon dbIcon = this.readImag(line, cecFactory);
        if (dbIcon != null) {
            this._dbIcon = dbIcon;
        }
    }

    private void readSimul(String line, CECFactory cecFactory) {
        DBIcon dbSimul = this.readImag(line, cecFactory);
        this._lstSimuls.add(new DBIconRenderer(dbSimul));
    }
}

