/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.component.pref;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaAbstractEventPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AltaEventListDisplayPreferencies
extends PrefFieldsCategory {
    public static String PREF_KEY = AltaEventListDisplayPreferencies.class.getName();
    public static final String PREF_NBR_EVENTS = PREF_KEY + "#MaxEventsInSync";
    private static final int PREF_NBR_EVENTS_DEFAULT = 4;
    protected JComboBox _ctrlNbrEvents;
    protected int _valueNbrEvents = 4;
    JPanel _perfsPanel;

    @Override
    protected List<PrefFieldBoolean> createFields() {
        return AltaAbstractEventPanel.createFields();
    }

    @Override
    public String getKey() {
        return PREF_KEY;
    }

    @Override
    protected JPanel makeContent() {
        if (this._perfsPanel == null) {
            this._ctrlNbrEvents = new JComboBox<Object>(new Object[]{"2", "3", "4", "5", "6", "7", "8", "9"});
            this._ctrlNbrEvents.setEditable(true);
            this._ctrlNbrEvents.setSelectedItem(Integer.toString(this._valueNbrEvents));
            this._ctrlNbrEvents.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String strLevel = AltaEventListDisplayPreferencies.this._ctrlNbrEvents.getSelectedItem().toString();
                        AltaEventListDisplayPreferencies.this._valueNbrEvents = Integer.parseInt(strLevel);
                    }
                    catch (Exception ex) {
                        AltaEventListDisplayPreferencies.this._ctrlNbrEvents.setSelectedItem(Integer.toString(AltaEventListDisplayPreferencies.this._valueNbrEvents));
                    }
                }
            });
            JPanel panelNEs = new JPanel(new GridBagLayout());
            JLabel lbl = new JLabel(ResMsgOcas.getString("PREF_MBSA_TAB_SYNCS_NBREVENT"));
            lbl.setToolTipText(ResMsgOcas.getString("PREF_MBSA_TAB_SYNCS_NBREVENT_TOOLTIP"));
            panelNEs.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
            panelNEs.add((Component)this._ctrlNbrEvents, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(10, 10, 5, 10), 0, 0));
            panelNEs.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 5, 0), 0, 0));
            panelNEs.setBorder(BorderFactory.createTitledBorder(ResMsgVoc.getString("VOC_SYNCS")));
            this._perfsPanel = new JPanel(new GridBagLayout());
            this._perfsPanel.add((Component)panelNEs, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this._perfsPanel.add((Component)super.makeContent(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        }
        return this._perfsPanel;
    }

    @Override
    public JPanel getPanel() {
        return this.makeContent();
    }

    @Override
    public String getInfo(String key) {
        if ("plugin.key".equals(key)) {
            return PREF_KEY;
        }
        if ("plugin.key.path".equals(key)) {
            return "MBSA/DISPLAY";
        }
        if ("plugin.name".equals(key)) {
            return ResMsgOcas.getString("PREF_MBSA_TAB_EVENTS");
        }
        if ("plugin.title".equals(key)) {
            return ResMsgOcas.getString("PREF_MBSA_TAB_EVENTS");
        }
        if ("plugin.description".equals(key)) {
            return ResMsgObj.getString("PREF_DISPLAY_VIEW_TITLE") + " - " + ResMsgOcas.getString("PREF_MBSA_TAB_EVENTS");
        }
        return null;
    }

    @Override
    public Icon getIcon(String key) {
        return ResIcoCore.getImageIcon("MBSA_EVENT");
    }

    @Override
    protected void load(Plugable launcher) {
        super.load(launcher);
        this._valueNbrEvents = PlugableUtility.getIntOpt(launcher, PREF_NBR_EVENTS, 4);
        if (this._valueNbrEvents < 0) {
            this._valueNbrEvents = 4;
        }
        if (this._ctrlNbrEvents != null) {
            this._ctrlNbrEvents.setSelectedItem(Integer.toString(this._valueNbrEvents));
        }
    }

    @Override
    protected void save(Plugable launcher) {
        launcher.setOption(PREF_NBR_EVENTS, Integer.toString(this._valueNbrEvents));
        super.save(launcher);
    }

    public int getNbrEvents() {
        return this._valueNbrEvents;
    }
}

