/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment;

import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.IOException;
import java.util.logging.Logger;

public class AltaLink {
    private static Logger _LOG = Logger.getLogger(AltaLink.class.getPackage().getName());
    long _ID;
    AltaEquipment _equip;
    AltaSub _fromSub;
    AltaFlow _fromFlow;
    DBRecordField _fromField;
    AltaSub _toSub;
    AltaFlow _toFlow;
    DBRecordField _toField;
    boolean _toBeDeleted = false;

    public AltaLink() {
        this(null, null, null, null);
        this._ID = -1L;
    }

    public AltaLink(AltaSub fromSub, AltaFlow fromFlow, AltaSub toSub, AltaFlow toFlow) {
        this._fromSub = fromSub;
        this._fromFlow = fromFlow;
        this._fromField = null;
        this._toSub = toSub;
        this._toFlow = toFlow;
        this._toField = null;
    }

    public AltaLink getCopy(CopyUtility util) {
        AltaSub fromSub = this._fromSub;
        AltaFlow fromFlow = this._fromFlow;
        if (fromSub != null) {
            AltaSub tmpSub = (AltaSub)util.getRef((Object)this._fromSub);
            if (tmpSub == null) {
                _LOG.warning("InternalCopyError : Don't find ref for sub " + this._fromSub.getName());
            } else {
                fromSub = tmpSub;
            }
        } else {
            AltaFlow tmpFlow = (AltaFlow)util.getRef((Object)this._fromFlow);
            if (tmpFlow == null) {
                _LOG.warning("InternalCopyError : Don't find ref for flow " + this._fromFlow.getName());
            } else {
                fromFlow = tmpFlow;
            }
        }
        AltaSub toSub = this._toSub;
        AltaFlow toFlow = this._toFlow;
        if (toSub != null) {
            AltaSub tmpSub = (AltaSub)util.getRef((Object)this._toSub);
            if (tmpSub == null) {
                _LOG.warning("InternalCopyError : Don't find ref for sub " + this._toSub.getName());
            } else {
                toSub = tmpSub;
            }
        } else {
            AltaFlow tmpFlow = (AltaFlow)util.getRef((Object)this._toFlow);
            if (tmpFlow == null) {
                _LOG.warning("InternalCopyError : Don't find ref for flow " + this._toFlow.getName());
            } else {
                toFlow = tmpFlow;
            }
        }
        AltaLink copy = new AltaLink(fromSub, fromFlow, toSub, toFlow);
        copy._fromField = this._fromField;
        copy._toField = this._toField;
        copy._ID = this._ID;
        return copy;
    }

    public long getID() {
        return this._ID;
    }

    public AltaLink setID(long id) {
        this._ID = id;
        return this;
    }

    public AltaSub getFromSub() {
        return this._fromSub;
    }

    public AltaFlow getFromFlow() {
        return this._fromFlow;
    }

    public DBRecordField getFromField() {
        return this._fromField;
    }

    public AltaLink setFromField(DBRecordField field) {
        this._fromField = field;
        return this;
    }

    public AltaLink setFrom(AltaSub sub, AltaFlow flow, DBRecordField field) {
        this._fromSub = sub;
        this._fromFlow = flow;
        this._fromField = field;
        return this;
    }

    public AltaSub getToSub() {
        return this._toSub;
    }

    public AltaFlow getToFlow() {
        return this._toFlow;
    }

    public DBRecordField getToField() {
        return this._toField;
    }

    public AltaLink setToField(DBRecordField field) {
        this._toField = field;
        return this;
    }

    public AltaLink setTo(AltaSub sub, AltaFlow flow, DBRecordField field) {
        this._toSub = sub;
        this._toFlow = flow;
        this._toField = field;
        return this;
    }

    public boolean toBeDeleted() {
        return this._toBeDeleted;
    }

    void setEquipement(AltaEquipment equip) {
        this._equip = equip;
    }

    public AlgaWithPorts getFromGraphic() {
        if (this._fromSub == null) {
            return this._equip.getGraphic(this._fromFlow);
        }
        return this._fromSub.getGraphic();
    }

    public AlgaWithPorts getToGraphic() {
        if (this._toSub == null) {
            return this._equip.getGraphic(this._toFlow);
        }
        return this._toSub.getGraphic();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        AltaLink.toStringPort(sb, this._fromSub, this._fromFlow, this._fromField);
        sb.append("=>");
        AltaLink.toStringPort(sb, this._toSub, this._toFlow, this._toField);
        return sb.toString();
    }

    private static void toStringPort(StringBuilder sb, AltaSub sub, AltaFlow flow, DBRecordField field) {
        if (sub != null) {
            sb.append(sub.getName()).append(".");
        }
        sb.append(flow.getName());
        if (field != null) {
            sb.append("^").append(field.getName());
        }
    }

    public boolean isRecord() {
        if (this._fromField != null) {
            return false;
        }
        if (this._toField != null) {
            return false;
        }
        return this._fromFlow.getType() instanceof DBRecord;
    }

    public boolean verify() {
        boolean result = this.doVerify();
        return result;
    }

    private boolean doVerify() {
        boolean outTo;
        boolean outFrom;
        if (this._fromFlow == null || this._toFlow == null) {
            return false;
        }
        if (this._fromFlow.getOrientation() == AltaFlow.Orientation.LOCAL) {
            return false;
        }
        if (this._toFlow.getOrientation() == AltaFlow.Orientation.LOCAL) {
            return false;
        }
        boolean bl = outFrom = this._fromFlow.getOrientation() == AltaFlow.Orientation.OUT;
        if (this._fromSub != null) {
            boolean bl2 = outFrom = !outFrom;
        }
        if (this._fromField != null && this._fromField.getDirection() == DBRecordField.Direction.INVERSE) {
            outFrom = !outFrom;
        }
        boolean bl3 = outTo = this._toFlow.getOrientation() == AltaFlow.Orientation.OUT;
        if (this._toSub != null) {
            boolean bl4 = outTo = !outTo;
        }
        if (this._toField != null && this._toField.getDirection() == DBRecordField.Direction.INVERSE) {
            boolean bl5 = outTo = !outTo;
        }
        if (outFrom == outTo) {
            return false;
        }
        if (outFrom) {
            this.swapFlows();
        }
        if (this._toField == null) {
            if (this._fromField == null) {
                return this._fromFlow.getType().equivalents(this._toFlow.getType());
            }
            if (this._fromFlow.getType() instanceof DBRecord) {
                DBRecord fromRecord = (DBRecord)this._fromFlow.getType();
                if (fromRecord.getFields().contains(this._fromField)) {
                    return this._fromField.getType().equivalents(this._toFlow.getType());
                }
                return false;
            }
            return false;
        }
        if (this._fromField == null) {
            if (this._toFlow.getType() instanceof DBRecord) {
                DBRecord toRecord = (DBRecord)this._toFlow.getType();
                if (toRecord.getFields().contains(this._toField)) {
                    return this._toField.getType().equivalents(this._fromFlow.getType());
                }
                return false;
            }
            return false;
        }
        if (this._toFlow.getType() instanceof DBRecord && this._fromFlow.getType() instanceof DBRecord) {
            DBRecord toRecord = (DBRecord)this._toFlow.getType();
            DBRecord fromRecord = (DBRecord)this._fromFlow.getType();
            if (toRecord.getFields().contains(this._toField) && fromRecord.getFields().contains(this._fromField)) {
                return this._fromField.getType().equivalents(this._toField.getType());
            }
            return false;
        }
        return false;
    }

    private void swapFlows() {
        AltaSub sub = this._fromSub;
        AltaFlow flow = this._fromFlow;
        DBRecordField field = this._fromField;
        this._fromSub = this._toSub;
        this._fromFlow = this._toFlow;
        this._fromField = this._toField;
        this._toSub = sub;
        this._toFlow = flow;
        this._toField = field;
    }

    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("alta.link");
        out.append(" ").append("id").append("='").append(Long.toString(this._ID)).append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("from").append("='"), AltaLink.codePort(this._fromSub, this._fromFlow, this._fromField));
        out.append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("to").append("='"), AltaLink.codePort(this._toSub, this._toFlow, this._toField));
        out.append("'");
        out.append("/>\n");
    }

    private static String codePort(AltaSub sub, AltaFlow flow, DBRecordField field) {
        StringBuilder sb = new StringBuilder();
        if (sub != null) {
            sb.append(sub.getName()).append(".");
        }
        sb.append(flow.getName());
        if (flow.getID() >= 0L) {
            sb.append("[").append(flow.getID()).append("]");
        }
        if (field != null) {
            sb.append("^").append(field.getName());
            if (field.getID() >= 0L) {
                sb.append("[").append(field.getID()).append("]");
            }
        }
        return sb.toString();
    }

    private static void appendPort(Appendable out, AltaSub sub, AltaFlow flow, DBRecordField field) throws IOException {
        if (sub != null) {
            out.append(sub.getName()).append(".");
        }
        out.append(flow.getName());
        if (field != null) {
            out.append("^").append(field.getName());
        }
    }

    public Appendable appendFrom(Appendable out) throws IOException {
        AltaLink.appendPort(out, this._fromSub, this._fromFlow, this._fromField);
        return out;
    }

    public Appendable appendTo(Appendable out) throws IOException {
        AltaLink.appendPort(out, this._toSub, this._toFlow, this._toField);
        return out;
    }

    public boolean update(DBLogs.DBLogsManager logMng) {
        boolean result;
        String oldLink;
        block14: {
            block19: {
                Object current;
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block13: {
                                    if (this._toBeDeleted) {
                                        return false;
                                    }
                                    oldLink = this.toString();
                                    result = false;
                                    if (this._fromSub == null) break block13;
                                    if (this._fromSub.getNode() == null) break block14;
                                    current = null;
                                    if (this._fromFlow.getID() >= 0L) {
                                        current = this._fromSub.getNode().getFlowWithID(this._fromFlow.getID());
                                    }
                                    if (current == null) {
                                        current = this._fromSub.getNode().getFlow(this._fromFlow.getName());
                                    }
                                    if (current == null) break block14;
                                    this._fromFlow = current;
                                    break block15;
                                }
                                current = this._equip.getFlow(this._fromFlow.getName());
                                if (current == null) break block14;
                                this._fromFlow = current;
                            }
                            if (this._fromField == null) break block16;
                            if (!(this._fromFlow.getType() instanceof DBRecord)) break block14;
                            current = null;
                            if (this._fromField.getID() >= 0L) {
                                current = ((DBRecord)this._fromFlow.getType()).getFieldWithID(this._fromField.getID());
                            }
                            if (current == null) {
                                current = ((DBRecord)this._fromFlow.getType()).fieldExist(this._fromField.getName());
                            }
                            if (current == null) break block14;
                            this._fromField = current;
                        }
                        if (this._toSub == null) break block17;
                        if (this._toSub.getNode() == null) break block14;
                        current = null;
                        if (this._toFlow.getID() >= 0L) {
                            current = this._toSub.getNode().getFlowWithID(this._toFlow.getID());
                        }
                        if (current == null) {
                            current = this._toSub.getNode().getFlow(this._toFlow.getName());
                        }
                        if (current == null) break block14;
                        this._toFlow = current;
                        break block18;
                    }
                    current = this._equip.getFlow(this._toFlow.getName());
                    if (current == null) break block14;
                    this._toFlow = current;
                }
                if (this._toField == null) break block19;
                if (!(this._toFlow.getType() instanceof DBRecord)) break block14;
                current = null;
                if (this._toField.getID() >= 0L) {
                    current = ((DBRecord)this._toFlow.getType()).getFieldWithID(this._toField.getID());
                }
                if (current == null) {
                    current = ((DBRecord)this._toFlow.getType()).fieldExist(this._toField.getName());
                }
                if (current == null) break block14;
                this._toField = current;
            }
            result = true;
        }
        if (!result) {
            logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_INVALID", oldLink));
            this._toBeDeleted = true;
        }
        return result;
    }
}

