/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AltaSynchro
extends AltaEvent {
    Type _type = Type.CCF;
    ArrayList<String> _events = new ArrayList();

    public AltaSynchro(String name) {
        super(name);
    }

    @Override
    public AltaSynchro getCopy() {
        AltaSynchro other = new AltaSynchro(this._name);
        other.copy(this);
        return other;
    }

    protected void copy(AltaSynchro src) {
        super.copy(src);
        this.setType(src.getType());
        this.setEvents(src.getEvents());
    }

    public Type getType() {
        return this._type;
    }

    public AltaSynchro setType(Type type) {
        this._type = type;
        return this;
    }

    public List<String> getEvents() {
        return this._events;
    }

    public AltaSynchro setEvents(List<String> events) {
        this._events = new ArrayList<String>(events);
        return this;
    }

    public void addTransition(String eventName) {
        if (this._events.isEmpty()) {
            this._events.add(eventName);
        } else {
            for (int i = 0; i < this._events.size(); ++i) {
                if (eventName.compareTo(this._events.get(i)) >= 0) continue;
                this._events.add(i, eventName);
                return;
            }
            this._events.add(eventName);
        }
    }

    public void removeTransition(String eventName) {
        this._events.remove(eventName);
    }

    public void removeTransition(int index) {
        this._events.remove(index);
    }

    public boolean transitionExist(String eventName) {
        return this._events.contains(eventName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(3 + this._name.length());
        sb.append("<").append(this._name).append(">");
        return sb.toString();
    }

    public String getSeparator() {
        String separator = " ? ";
        switch (this.getType()) {
            case CCF: {
                separator = " ? ";
                break;
            }
            case DIFF: {
                separator = " | ";
                break;
            }
            case MEC: {
                separator = " , ";
            }
        }
        return separator;
    }

    @Override
    public void toXML(Appendable out, String indent0) throws IOException {
        out.append(indent0).append("<").append("alta.sync");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._name).append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("type").append("='"), this._type.getCode()).append("'");
        out.append(">\n");
        for (int i = 0; i < this._events.size(); ++i) {
            out.append(indent0).append("  <").append("alta.event");
            DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._events.get(i)).append("'");
            out.append("/>\n");
        }
        this.toXML_Content(out, indent0, this.getLabel(), true);
        out.append(indent0).append("</").append("alta.sync").append(">\n");
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng, AltaEquipment equip) {
        super.update(daoFactory, logMng, this.getName());
        boolean result = true;
        ArrayList<String> chgEvts = new ArrayList<String>(this._events.size());
        for (String evt : this._events) {
            ObjectWithName owny = equip.findFieldFromPath(evt);
            if (owny != null && owny instanceof AltaEvent) {
                chgEvts.add(evt);
                continue;
            }
            logMng.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("ERR_OWNY_UNKNOW_FRM", evt, ResMsgVoc.getString("VOC_EVENT")));
            result = false;
        }
        return result;
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getAbstract());
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_TYPE"), this.getType().getLabel()));
        if (this.getEvents() != null) {
            sb.append(ResMsgVoc.getString("VOC_EVENTS")).append(" : \n");
            ArrayList<String> events = new ArrayList<String>(this.getEvents());
            events.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            for (String event : events) {
                sb.append("-").append(event).append('\n');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static enum Type {
        CCF(ResMsgOcas.getString("SYNC_EDIT_CCF")),
        DIFF(ResMsgOcas.getString("SYNC_EDIT_DIFF")),
        MEC(ResMsgOcas.getString("SYNC_EDIT_SYNC"));

        String _code = this.toString().toLowerCase();
        String _label;

        private Type(String label) {
            this._label = label;
        }

        public String getCode() {
            return this._code;
        }

        public String getLabel() {
            return this._label;
        }

        public static class SpecificListCellRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Type) {
                    this.setText(((Type)((Object)value)).getLabel());
                }
                return this;
            }
        }

        public static class SpecificTableCellRenderer
        extends DefaultTableCellRenderer {
            public SpecificTableCellRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Type) {
                    this.setText(((Type)((Object)value)).getLabel());
                }
                return this;
            }
        }
    }
}

