/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.DBIconRenderer;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AlgaContext {
    Rectangle _viewRect = new Rectangle(0, 0, 100, 50);
    double _zoom = 1.0;
    boolean _bPrinting = false;
    AltaContentDisplayPreferencies.LinkDisplay _bLinkInFront = AltaContentDisplayPreferencies.LinkDisplay.BG;
    boolean _bPaintingPort = true;
    PolicyLabel _labelPolicy = PolicyLabel.NODE;
    public static final String FONT_COURRIER_NAME = "Courier";
    Map<FontDefine, Font> _mapFonts = new HashMap<FontDefine, Font>();
    String _fontDefaultName = "Courier";
    int _fontDefaultType = 0;
    int _fontDefaultSize = 12;
    Map<StrokeDefine, Stroke> _mapStrokes = new HashMap<StrokeDefine, Stroke>();

    public Rectangle getRectView() {
        return this._viewRect;
    }

    public void setRectView(Rectangle rect) {
        this._viewRect = rect;
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setZoom(double zoom) {
        this._zoom = zoom;
    }

    public boolean isPrinting() {
        return this._bPrinting;
    }

    public void setPrinting(boolean b) {
        this._bPrinting = b;
    }

    public boolean isDisplay() {
        return !this._bPrinting;
    }

    public AltaContentDisplayPreferencies.LinkDisplay getLinkDisplay() {
        return this._bLinkInFront;
    }

    public void setLinkDisplay(AltaContentDisplayPreferencies.LinkDisplay b) {
        this._bLinkInFront = b;
    }

    public boolean isPaintingPort() {
        return this._bPaintingPort;
    }

    public void setPaintingPort(boolean b) {
        this._bPaintingPort = b;
    }

    public PolicyLabel getPolicyLabel() {
        return this._labelPolicy;
    }

    public void setPolicyLabel(PolicyLabel v) {
        this._labelPolicy = v;
    }

    public boolean itsCompatiblePolicyLabel(PolicyLabel v) {
        switch (v) {
            case NONE: {
                return this._labelPolicy == PolicyLabel.NONE;
            }
            case ALL: {
                return this._labelPolicy == PolicyLabel.ALL;
            }
            case NODE: {
                return this._labelPolicy == PolicyLabel.ALL || this._labelPolicy == PolicyLabel.NODE;
            }
            case LINK: {
                return this._labelPolicy == PolicyLabel.ALL || this._labelPolicy == PolicyLabel.LINK;
            }
        }
        return false;
    }

    public Font getFont(String fontName, int fontType, int fontSize) {
        FontDefine def;
        Font font;
        if (fontName == null || fontName.isEmpty()) {
            fontName = this._fontDefaultName;
        }
        if (fontType < 0) {
            fontType = this._fontDefaultType;
        }
        if (fontSize < 0) {
            fontSize = this._fontDefaultSize;
        }
        if ((font = this._mapFonts.get(def = new FontDefine(fontName, fontType, fontSize))) == null) {
            font = new Font(def._name, def._type, def._size);
            this._mapFonts.put(def, font);
        }
        return font;
    }

    public void setDefaultFontName(String fontName) {
        this._fontDefaultName = fontName;
    }

    public void setDefaultFontType(int fontType) {
        this._fontDefaultType = fontType;
    }

    public void setDefaultFontSize(int fontSize) {
        this._fontDefaultSize = fontSize;
    }

    public Stroke getStroke(int size, int cap, int join, boolean dash) {
        StrokeDefine def = new StrokeDefine(size, cap, join, dash);
        Stroke stroke = this._mapStrokes.get(def);
        if (stroke == null) {
            if (dash) {
                float[] dashPattern = new float[]{10.0f, 10.0f, 10.0f, 10.0f, 30.0f, 10.0f, 30.0f, 10.0f, 30.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 30.0f};
                stroke = new BasicStroke(def._size, def._cap, def._join, 10.0f, dashPattern, 0.0f);
            } else {
                stroke = new BasicStroke(def._size, def._cap, def._join);
            }
            this._mapStrokes.put(def, stroke);
        }
        return stroke;
    }

    public Color getDefaultColor() {
        return Color.black;
    }

    public Color getColorSelect(boolean locked) {
        if (locked) {
            return Color.gray;
        }
        if (this.isDisplay()) {
            return Color.blue;
        }
        return this.getDefaultColor();
    }

    public Color getColorLink(AltaLink link, boolean selected, boolean locked) {
        if (!link.verify()) {
            return Color.red;
        }
        if (selected && this.isDisplay()) {
            return this.getColorSelect(locked);
        }
        return this.getDefaultColor();
    }

    public Color getColorFlow(AltaFlow flow, boolean selected, boolean locked) {
        if (selected && this.isDisplay()) {
            return this.getColorSelect(locked);
        }
        return this.getDefaultColor();
    }

    public DBIconRenderer getIconSub(AltaSub sub) {
        return sub.getNode().getIconRenderer();
    }

    public static enum PolicyLabel {
        NONE(ResMsgVoc.getString("VOC_AUCUN")),
        NODE(ResMsgOcas.getString("VIEW_LABELS_NODES")),
        LINK(ResMsgOcas.getString("VIEW_LABELS_LINKS")),
        ALL(ResMsgOcas.getString("VIEW_LABELS_ALL"));

        String _label;

        private PolicyLabel(String label) {
            this._label = label;
        }

        public String getLabel() {
            return this._label;
        }

        public static class SpecificListCellRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof PolicyLabel) {
                    this.setText(((PolicyLabel)((Object)value)).getLabel());
                }
                return this;
            }
        }

        public static class SpecificTableCellRenderer
        extends DefaultTableCellRenderer {
            public SpecificTableCellRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof PolicyLabel) {
                    this.setText(((PolicyLabel)((Object)value)).getLabel());
                }
                return this;
            }
        }
    }

    private static class FontDefine {
        String _name;
        int _type;
        int _size;

        FontDefine(String name, int type, int size) {
            this._name = name;
            this._type = type;
            this._size = size;
        }

        public int hashCode() {
            return (this._name.hashCode() * 7 + this._type) * 5 + this._size;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FontDefine)) {
                return false;
            }
            FontDefine other = (FontDefine)obj;
            if (!other._name.equals(this._name)) {
                return false;
            }
            if (other._type != this._type) {
                return false;
            }
            return other._size == this._size;
        }
    }

    private static class StrokeDefine {
        int _size;
        int _cap;
        int _join;
        boolean _dash;

        StrokeDefine(int size, int cap, int join, boolean dash) {
            if (size < 0) {
                size = 1;
            }
            if (cap < 0) {
                cap = 0;
            }
            if (join < 0) {
                join = 2;
            }
            this._size = size;
            this._cap = cap;
            this._join = join;
            this._dash = dash;
        }

        public int hashCode() {
            return ((this._size * 7 + this._cap) * 5 + this._join) * 3 + (this._dash ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StrokeDefine)) {
                return false;
            }
            StrokeDefine other = (StrokeDefine)obj;
            if (other._size != this._size) {
                return false;
            }
            if (other._cap != this._cap) {
                return false;
            }
            if (other._join != this._join) {
                return false;
            }
            return other._dash == this._dash;
        }
    }
}

