/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Iterator;

public class AlgaLine
extends AlgaPoints {
    boolean _arrowBegin;
    boolean _arrowEnd;
    private static final int ARROW_SIZE = 8;
    private static final double NOARROW_DISTANCE = 24.0;
    private static GeneralPath ARROW_SHAPE = new GeneralPath();

    public AlgaLine() {
        this._opaque = true;
        this._foreground = Color.black;
    }

    public boolean isArrowBegin() {
        return this._arrowBegin;
    }

    public AlgaLine setArrowBegin(boolean arrowBegin) {
        this._arrowBegin = arrowBegin;
        return this;
    }

    public boolean isArrowEnd() {
        return this._arrowEnd;
    }

    public AlgaLine setArrowEnd(boolean arrowEnd) {
        this._arrowEnd = arrowEnd;
        return this;
    }

    @Override
    public AlgaLine getCopy(boolean withDepth, CopyUtility util) {
        AlgaLine result = new AlgaLine();
        result.copy(this, withDepth, util);
        return result;
    }

    @Override
    protected void copy(AlgaGraph grfsrc, boolean withDepth, CopyUtility util) {
        super.copy(grfsrc, withDepth, util);
        if (grfsrc instanceof AlgaLine) {
            AlgaLine src = (AlgaLine)grfsrc;
            this._arrowBegin = src._arrowBegin;
            this._arrowEnd = src._arrowEnd;
        }
    }

    @Override
    public boolean isVisio() {
        return true;
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        return "[Line]";
    }

    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        Pt last = null;
        Pt previous = null;
        Pt next = null;
        Pt first = null;
        GeneralPath path = new GeneralPath();
        Iterator<Pt> iterPt = this.iteratePoint();
        previous = first = iterPt.next();
        path.moveTo(first.getX(), first.getY());
        while (iterPt.hasNext()) {
            if (last != null) {
                previous = last;
            }
            last = iterPt.next();
            if (next == null) {
                next = last;
            }
            path.lineTo(last.getX(), last.getY());
        }
        Color oldColor = g.getColor();
        g.setColor(this.getForeground());
        g.draw(path);
        if (this.isArrowBegin()) {
            this.paintArrow(g, context, next, first);
        }
        if (this.isArrowEnd()) {
            this.paintArrow(g, context, previous, last);
        }
        g.setColor(oldColor);
        if (this.isSelected() && context.isDisplay()) {
            this.paintSelection(g, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSelection(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setStroke(context.getStroke(1, -1, -1, false));
        g.setColor(context.getColorSelect(this.isLocked()));
        if (this.isLocked()) {
            Iterator<Pt> iterPt = this.iteratePoint();
            while (iterPt.hasNext()) {
                Pt next = iterPt.next();
                g.drawRect(next._x - 3, next._y - 3, 6, 6);
            }
        } else {
            Iterator<Pt> iterPt = this.iteratePoint();
            Pt first = iterPt.next();
            g.fillRect(first._x - 3, first._y - 3, 6, 6);
            Pt prev = first;
            while (iterPt.hasNext()) {
                Pt next = iterPt.next();
                g.fillRect(next._x - 3, next._y - 3, 6, 6);
                AffineTransform oldTransf = g.getTransform();
                try {
                    g.translate((prev._x + next._x) / 2, (prev._y + next._y) / 2);
                    g.fill(MIDDLE_HIT_SHAPE);
                }
                finally {
                    g.setTransform(oldTransf);
                }
                prev = next;
            }
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintArrow(Graphics2D g, AlgaContext context, Pt pt1, Pt pt2) {
        double diffY;
        double diffX = pt2.getX() - pt1.getX();
        double dist = Math.sqrt(diffX * diffX + (diffY = (double)(pt2.getY() - pt1.getY())) * diffY);
        if (dist < 24.0) {
            return;
        }
        double angle = -1.0;
        angle = diffY == 0.0 ? (diffX > 0.0 ? 0.0 : Math.PI) : (diffX == 0.0 ? (diffY < 0.0 ? 4.71238898038469 : 1.5707963267948966) : (diffY > 0.0 ? (diffX > 0.0 ? Math.atan(diffY / diffX) : Math.PI - Math.atan(diffY / -diffX)) : (diffX > 0.0 ? -Math.atan(-diffY / diffX) : Math.PI + Math.atan(-diffY / -diffX))));
        AffineTransform oldTransf = g.getTransform();
        try {
            g.translate(pt2.getX(), pt2.getY());
            g.rotate(angle);
            g.fill(ARROW_SHAPE);
            g.draw(ARROW_SHAPE);
        }
        finally {
            g.setTransform(oldTransf);
        }
    }

    static {
        ARROW_SHAPE.moveTo(-8.0f, -4.0f);
        ARROW_SHAPE.lineTo(0.0f, 0.0f);
        ARROW_SHAPE.lineTo(-8.0f, 4.0f);
        ARROW_SHAPE.closePath();
        ARROW_SHAPE.append(new Line2D.Double(-10.0, 0.0, 0.0, 0.0), false);
    }
}

