/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.graph;

import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Iterator;

public class AlgaPolygone
extends AlgaPoints {
    GeneralPath _path = new GeneralPath();

    public AlgaPolygone() {
        this._opaque = true;
        this._background = Color.white;
        this._foreground = Color.black;
    }

    @Override
    public AlgaPolygone getCopy(boolean withDepth, CopyUtility util) {
        AlgaPolygone result = new AlgaPolygone();
        result.copy(this, withDepth, util);
        result.computeControlPoints();
        return result;
    }

    @Override
    public boolean isVisio() {
        return true;
    }

    @Override
    public String getTooltip(AltaEquipment owner, int x, int y) {
        return "[Polygone]";
    }

    @Override
    public boolean isClosePath() {
        return true;
    }

    @Override
    public void paint(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fill(this._path);
        }
        g.setColor(this.getForeground());
        g.draw(this._path);
        g.setColor(oldColor);
        if (this.isSelected() && context.isDisplay()) {
            this.paintSelection(g, context);
        }
    }

    @Override
    public void computeControlPoints() {
        this._path = new GeneralPath();
        Iterator<Pt> iterPt = this.iteratePoint();
        Pt pt = iterPt.next();
        this._path.moveTo(pt.getX(), pt.getY());
        while (iterPt.hasNext()) {
            pt = iterPt.next();
            this._path.lineTo(pt.getX(), pt.getY());
        }
        this._path.closePath();
        super.computeControlPoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSelection(Graphics2D g, AlgaContext context) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setStroke(context.getStroke(1, -1, -1, false));
        g.setColor(context.getColorSelect(this.isLocked()));
        if (this.isLocked()) {
            Iterator<Pt> iterPt = this.iteratePoint();
            while (iterPt.hasNext()) {
                Pt next = iterPt.next();
                g.drawRect(next._x - 3, next._y - 3, 6, 6);
            }
        } else {
            Iterator<Pt> iterPt = this.iteratePoint();
            Pt first = iterPt.next();
            g.fillRect(first._x - 3, first._y - 3, 6, 6);
            Pt prev = first;
            while (iterPt.hasNext()) {
                Pt next = iterPt.next();
                g.fillRect(next._x - 3, next._y - 3, 6, 6);
                AffineTransform oldTransf = g.getTransform();
                try {
                    g.translate((prev._x + next._x) / 2, (prev._y + next._y) / 2);
                    g.fill(MIDDLE_HIT_SHAPE);
                }
                finally {
                    g.setTransform(oldTransf);
                }
                prev = next;
            }
            AffineTransform oldTransf = g.getTransform();
            try {
                g.translate((prev._x + first._x) / 2, (prev._y + first._y) / 2);
                g.fill(MIDDLE_HIT_SHAPE);
            }
            finally {
                g.setTransform(oldTransf);
            }
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this._path.contains(x, y)) {
            return true;
        }
        return super.contains(x, y);
    }
}

