/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.table.ArrayTableModel;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import java.util.ArrayList;

class AlgaSheetTableModel
extends ArrayTableModel<AlgaSheet> {
    boolean _bReadOnly = false;

    public void setReadOnly(boolean readOnly) {
        this._bReadOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this._bReadOnly;
    }

    public AlgaSheetTableModel(ArrayList<AlgaSheet> array) {
        super(array);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResMsgOcas.getString("VOC_NUMBER");
            }
            case 1: {
                return ResMsgVoc.getString("VOC_NAME");
            }
            case 2: {
                return ResMsgOcas.getString("VOC_VISIBLE");
            }
            case 3: {
                return ResMsgOcas.getString("VOC_SELECTED");
            }
        }
        return "Error";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.isReadOnly()) {
            return column > 1;
        }
        return true;
    }

    @Override
    public Object getValueAt(int row, int column) {
        AlgaSheet sheet = (AlgaSheet)this.getItemAt(row);
        switch (column) {
            case 0: {
                return sheet.getNumber();
            }
            case 1: {
                return sheet.getName();
            }
            case 2: {
                return sheet.isVisible();
            }
            case 3: {
                return sheet.isSelected();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        AlgaSheet sheet = (AlgaSheet)this.getItemAt(row);
        switch (column) {
            case 0: {
                if (!(aValue instanceof Number)) break;
                int id = ((Number)aValue).intValue();
                if (id < 0 || id > 30) {
                    return;
                }
                if (id == sheet.getNumber()) {
                    return;
                }
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (i == row || id != ((AlgaSheet)this.getItemAt(i)).getNumber()) continue;
                    return;
                }
                sheet.setNumber(id);
                break;
            }
            case 1: {
                if (!(aValue instanceof String)) break;
                String name = ((String)aValue).trim();
                if (name.isEmpty()) {
                    return;
                }
                if (name.equals(sheet.getName())) {
                    return;
                }
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (i == row || !name.equals(((AlgaSheet)this.getItemAt(i)).getName())) continue;
                    return;
                }
                sheet.setName(name);
                break;
            }
            case 2: {
                if (!(aValue instanceof Boolean)) break;
                boolean visible = (Boolean)aValue;
                if (!visible && sheet.isSelected()) {
                    return;
                }
                sheet.setVisible(visible);
                break;
            }
            case 3: {
                if (!(aValue instanceof Boolean)) break;
                boolean selected = (Boolean)aValue;
                if (!selected) {
                    return;
                }
                if (selected == sheet.isSelected()) {
                    return;
                }
                int oldSelectIndex = -1;
                for (int i = 0; oldSelectIndex == -1 && i < this.getRowCount(); ++i) {
                    if (i == row || !((AlgaSheet)this.getItemAt(i)).isSelected()) continue;
                    oldSelectIndex = i;
                }
                sheet.setSelected(true);
                if (!sheet.isVisible()) {
                    sheet.setVisible(true);
                    this.fireTableCellUpdated(row, 2);
                }
                ((AlgaSheet)this.getItemAt(oldSelectIndex)).setSelected(false);
                this.fireTableCellUpdated(oldSelectIndex, column);
            }
        }
    }
}

