/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.cecilia.action.CArrayCmd;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderTransferable;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdInsertSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdMove;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdRename;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.MoveGrfUtility;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AltaContentEditView
extends AltaContentView {
    private static Logger _LOG = Logger.getLogger(AltaContentEditView.class.getPackage().getName());
    AltaContentEditPanel _ctrl;
    JTextField _ctrlEditName;
    private static final int MARGE_CTRL_EDIT_NAME_W = 10;
    private static final int MARGE_CTRL_EDIT_NAME_H = 4;

    public AltaContentEditView(AltaContentEditPanel ctrl, AlgaContext context) {
        super(context);
        this._ctrl = ctrl;
        this.setDropTarget(new DropTarget(this, new AltaDropTargetListener()));
        this.addKeyListener(new AltaMoveKeyListener());
        this.addKeyListener(new AltaRenameKeyListener());
        this.addMouseListener(new AltaEditMouseListener());
        this.setFocusable(true);
        this.createEditName();
    }

    public AltaContentEditPanel getPanel() {
        return this._ctrl;
    }

    @Override
    protected boolean isReadOnly() {
        return this._ctrl.isReadOnly();
    }

    protected void dropFolder(DBFolder dbFolder, Point location) {
        _LOG.finest("AltaContentView::Drop: " + dbFolder.getRefPath() + " at " + location);
        OCmdInsertSub cmd = new OCmdInsertSub(this._ctrl.getAppl(), this._ctrl, dbFolder, (int)location.getX(), (int)location.getY());
        cmd.realiseDo();
    }

    private void createEditName() {
        this._ctrlEditName = new JTextField(20);
        this._ctrlEditName.setColumns(10);
        this._ctrlEditName.setFont(new Font("Monospaced", 0, 12));
        this._ctrlEditName.setAutoscrolls(true);
        this._ctrlEditName.setVisible(false);
        this.add(this._ctrlEditName);
    }

    public void displayCtrlEditName(AlgaNode node) {
        Rectangle textBound = node.getTextBounds(this.getGraphics());
        double x = this.getZoom() * (textBound.getX() - 10.0);
        double y = this.getZoom() * (textBound.getY() - 4.0);
        this._ctrlEditName.setLocation((int)x, (int)y);
        double w = this.getZoom() * (textBound.getWidth() + 20.0);
        double h = this.getZoom() * (textBound.getHeight() + 8.0);
        this._ctrlEditName.setSize((int)w, (int)h);
        this._ctrlEditName.setVisible(true);
    }

    class AltaDropTargetListener
    implements DropTargetListener {
        AltaDropTargetListener() {
        }

        protected boolean isAltaDropAcceptable(int dropAction, Transferable transferable) {
            if (AltaContentEditView.this.isReadOnly()) {
                return false;
            }
            if ((dropAction & 2) == 0) {
                return false;
            }
            try {
                DBFolder dbFolder = (DBFolder)transferable.getTransferData(DBFolderTransferable.DB_FLAVOR);
                if (!dbFolder.isVersion()) {
                    return false;
                }
                if (dbFolder.getFamily() == DBFolder.Family.COMPONENT) {
                    return true;
                }
                if (dbFolder.getFamily() == DBFolder.Family.EQUIPMENT) {
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        protected boolean isDragAcceptable(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DBFolderTransferable.DB_FLAVOR)) {
                return this.isAltaDropAcceptable(event.getDropAction(), event.getTransferable());
            }
            return false;
        }

        protected boolean isDropAcceptable(DropTargetDropEvent event) {
            if (event.isDataFlavorSupported(DBFolderTransferable.DB_FLAVOR)) {
                return this.isAltaDropAcceptable(event.getDropAction(), event.getTransferable());
            }
            return false;
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            try {
                event.acceptDrop(2);
                Transferable transferable = event.getTransferable();
                DBFolder dbFolder = (DBFolder)transferable.getTransferData(DBFolderTransferable.DB_FLAVOR);
                AltaContentEditView.this.dropFolder(dbFolder, event.getLocation());
                event.dropComplete(true);
            }
            catch (IOException e) {
                _LOG.log(Level.WARNING, "Drag'n Drop error", e);
                event.dropComplete(false);
            }
            catch (UnsupportedFlavorException e) {
                _LOG.log(Level.WARNING, "Drag'n Drop error", e);
                event.dropComplete(false);
            }
        }
    }

    class AltaMoveKeyListener
    extends KeyAdapter {
        MoveGrfUtility _moveUtility = new MoveGrfUtility();
        int _deltaX;
        int _deltaY;
        int _nbrPress = 0;

        AltaMoveKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this._nbrPress == 0 && AltaContentEditView.this._ctrl.getNbrUnlocked() == 0) {
                return;
            }
            if (AltaContentEditView.this.isReadOnly()) {
                return;
            }
            int dx = 0;
            int dy = 0;
            switch (e.getKeyCode()) {
                case 37: {
                    dx = -1;
                    break;
                }
                case 39: {
                    dx = 1;
                    break;
                }
                case 38: {
                    dy = -1;
                    break;
                }
                case 40: {
                    dy = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            dx *= 1;
            dy *= 1;
            if ((e.getModifiersEx() & 0x40) == 64) {
                dx *= 10;
                dy *= 10;
                if ((e.getModifiersEx() & 0x80) == 128) {
                    dx *= 10;
                    dy *= 10;
                }
            }
            if (this._nbrPress == 0 && !this._moveUtility.prepare(AltaContentEditView.this, true, true)) {
                return;
            }
            if (this._nbrPress > 1) {
                this._moveUtility.drawRect(this._deltaX, this._deltaY, (Graphics2D)AltaContentEditView.this.getGraphics(), AltaContentEditView.this.getZoom());
            }
            ++this._nbrPress;
            this._deltaX = this._moveUtility.adjustX(this._deltaX + dx);
            this._deltaY = this._moveUtility.adjustY(this._deltaY + dy);
            if (this._nbrPress > 1) {
                this._moveUtility.drawRect(this._deltaX, this._deltaY, (Graphics2D)AltaContentEditView.this.getGraphics(), AltaContentEditView.this.getZoom());
            }
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this._nbrPress == 0) {
                return;
            }
            if (AltaContentEditView.this.isReadOnly()) {
                return;
            }
            e.consume();
            if (this._nbrPress > 1) {
                this._moveUtility.drawRect(this._deltaX, this._deltaY, (Graphics2D)AltaContentEditView.this.getGraphics(), AltaContentEditView.this.getZoom());
            }
            if (this._moveUtility.moveShape()) {
                OCmdMove cmd = new OCmdMove(AltaContentEditView.this.getPanel(), this._moveUtility.adjustX(this._deltaX), this._moveUtility.adjustY(this._deltaY));
                cmd.realiseDo();
            } else {
                CArrayCmd cmd = new CArrayCmd(AltaContentEditView.this.getPanel().getAppl(), AltaContentEditView.this.getPanel());
                this._moveUtility.prepareMoveHitPoint(cmd, AltaContentEditView.this.getPanel(), this._deltaX, this._deltaY);
                if (cmd.realiseDo()) {
                    AltaContentEditView.this.getPanel().addHisto(cmd);
                }
            }
            this._nbrPress = 0;
            this._deltaY = 0;
            this._deltaX = 0;
        }
    }

    class AltaRenameKeyListener
    extends KeyAdapter {
        AltaRenameKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (AltaContentEditView.this._ctrl.getNbrNodeUnlocked() != 1) {
                return;
            }
            if (AltaContentEditView.this.isReadOnly()) {
                return;
            }
            if (e.getKeyCode() == 113) {
                AlgaGraph grf = AltaContentEditView.this.getContent().getSelectedGraph();
                if (grf == null || grf.isLocked() || !(grf instanceof AlgaNode)) {
                    return;
                }
                AlgaNode node = (AlgaNode)grf;
                OCmdRename cmd = new OCmdRename(AltaContentEditView.this.getPanel().getAppl(), AltaContentEditView.this.getPanel(), node);
                cmd.realiseDo();
                e.consume();
            }
        }
    }

    class AltaEditMouseListener
    extends MouseAdapter {
        AltaEditMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            Graphics g = AltaContentEditView.this.getGraphics();
            int x = (int)((double)e.getX() / AltaContentEditView.this._zoom);
            int y = (int)((double)e.getY() / AltaContentEditView.this._zoom);
            AlgaGraph selected = null;
            boolean rename = false;
            List<AlgaSheet> sheets = AltaContentEditView.this.getContent().getSheets();
            block0: for (int i = sheets.size() - 1; i >= 0 && selected == null; --i) {
                AlgaSheet sheet = sheets.get(i);
                if (!sheet.isVisible()) continue;
                for (AlgaGraph grf : sheet.getGraphs()) {
                    AlgaNode node;
                    Rectangle textBound;
                    if (!grf.isLocked() && grf instanceof AlgaNode && (textBound = (node = (AlgaNode)grf).getTextBounds(g)).contains(x, y)) {
                        selected = grf;
                        rename = true;
                        continue block0;
                    }
                    if (!grf.contains(x, y) || !grf.isSelected()) continue;
                    selected = grf;
                    rename = false;
                    continue block0;
                }
            }
            if (selected != null) {
                if (rename) {
                    OCmdRename cmd = new OCmdRename(AltaContentEditView.this.getPanel().getAppl(), AltaContentEditView.this.getPanel(), (AlgaNode)selected);
                    cmd.realiseDo();
                } else if (!e.isShiftDown()) {
                    AltaContentEditView.this._ctrl.doEdit();
                }
            }
        }
    }
}

