/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.dbobj.folder.DBFolderThreadClose;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaGeneralPanel;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaIconPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaFlowEquipPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaSynchroPanel;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgEquipment;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaCodeFrame;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorInterface;
import com.dassault.cecilia.dbobj.mbsa.node.gui.HelperLabel;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AltaEquipmentFrame
extends AltaCodeFrame
implements EditorInterface {
    private static final int IDX_GRAL = 0;
    private static final int IDX_FLOW = 1;
    private static final int IDX_CONT = 2;
    private static final int IDX_SYNC = 3;
    private static final int IDX_ICON = 4;
    private static final int IDX_CODE = 5;
    Component _oldTabSelected = null;
    AltaGeneralPanel _generalPanel;
    AltaFlowEquipPanel _flowPanel;
    AltaIconPanel _iconPanel;
    AltaSynchroPanel _syncPanel;
    AltaContentEditPanel _contentPanel;

    public AltaEquipmentFrame(CeciliaAppl appl, AltaEquipment dbEquipment) {
        super(dbEquipment.getCopy(), appl);
        this.makePanel();
        this.editEquipment(this.getAltaNode());
        this.setModified(false);
    }

    @Override
    protected AltaEquipment getAltaNode() {
        return (AltaEquipment)super.getAltaNode();
    }

    public AltaContentEditPanel selectAndGetEditPanel() {
        this._tabPane.setSelectedIndex(2);
        return this._contentPanel;
    }

    public void focusTreatment() {
        this.requestFocus();
        if (this._tabPane != null) {
            switch (this._tabPane.getSelectedIndex()) {
                case 0: {
                    this._generalPanel.focusTreatment();
                    break;
                }
                case 1: {
                    this._flowPanel.focusTreatment();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this._syncPanel.requestFocus();
                    break;
                }
                case 4: {
                    this._iconPanel.requestFocus();
                    break;
                }
                case 5: {
                    this._codeEditor.getEditorComponent().requestFocus();
                }
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.focusTreatment();
    }

    private void makePanel() {
        this._generalPanel = new AltaGeneralPanel(this.getApplication());
        this._contentPanel = new AltaContentEditPanel(this.getApplication());
        this._contentPanel.make();
        this._flowPanel = new AltaFlowEquipPanel(this.getApplication(), this._contentPanel);
        this._syncPanel = new AltaSynchroPanel(this.getApplication());
        this._iconPanel = new AltaIconPanel(this.getApplication());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_GENERAL"), this._generalPanel);
        this._tabPane.addTab(ResMsgOcas.getString("MODEL_EDIT_INOUT"), ResIcoCore.getImageIcon("MBSA_FLOW"), this._flowPanel);
        this._tabPane.addTab(ResMsgVoc.getString("VOC_CONTENT"), this._contentPanel);
        this._tabPane.addTab(ResMsgVoc.getString("VOC_SYNCS"), ResIcoCore.getImageIcon("MBSA_SYNC"), this._syncPanel);
        this._tabPane.addTab(ResMsgVoc.getString("VOC_ICONS"), ResIcoOcas.getImageIcon("ICONE_PI"), this._iconPanel);
        this._tabPane.addTab(ResMsgOcas.getString("MODEL_EDIT_ALTARICA_CODE"), ResIcoOcas.getImageIcon("CODE_PI"), this.createAltaEditor());
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        this._tabPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        content.add((Component)this._tabPane, "Center");
        content.add(this.createAndPlugLogsButtonAt(this.createCodeAndClosePanel()), "South");
        this.defineActions();
        this.setSize(700, 500);
    }

    @Override
    protected int getTabIndex(AltaCodeFrame.CodeTabType tabType) {
        switch (tabType) {
            case GENERAL: {
                return 0;
            }
            case FLOW: {
                return 1;
            }
            case CONTENT: {
                return 2;
            }
            case SYNC: {
                return 3;
            }
            case ICON: {
                return 4;
            }
            case CODE: {
                return 5;
            }
        }
        return -1;
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        super.changePreferencies(prefs);
        this._contentPanel.changePreferencies(prefs);
        this._syncPanel.changePreferencies(prefs);
    }

    @Override
    public String getHelpRoots(Vector list) {
        AltaEquipment model = this.getAltaNode();
        for (AltaFlow port : model.getFlows()) {
            if (port.getOrientation() == AltaFlow.Orientation.IN) {
                UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_INPUT"), port.getType()));
                continue;
            }
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_OUTPUT"), port.getType()));
        }
        for (AltaSynchro sync : model.getSynchros()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sync.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_SYNC"), ""));
        }
        for (AltaSub sub : model.getSubs()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sub.getName(), (Icon)(sub.getNode() instanceof AltaEquipment ? ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_") : ResIcoCore.getImageIcon("FOLDER_COMPONENT_")), ""));
        }
        if (model.getSimuls().size() > 0) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel("icone", (Icon)ResIcoOcas.getImageIcon("ICONE_PI"), ""));
        }
        return model.getDBFolder().getRefPath();
    }

    @Override
    public String analyseString(String str, char car, Vector list) {
        String resultString = "";
        switch (car) {
            case '^': 
            case '_': {
                AltaFlow flow;
                String[] componentsSplited = str.split("\\.");
                AltaComponent component = this.getAltaNode();
                if (componentsSplited.length > 1) {
                    for (int i = 0; i < componentsSplited.length - 1; ++i) {
                        if (!(component instanceof AltaEquipment) || component.getSub(componentsSplited[i]) == null) {
                            return null;
                        }
                        component = component.getSub(componentsSplited[i]).getNode();
                    }
                }
                if ((flow = component.getFlow(componentsSplited[componentsSplited.length - 1])) == null || !(flow.getType() instanceof DBRecord)) break;
                DBRecord dbRecord = (DBRecord)flow.getType();
                for (int i = dbRecord.getValueCount() - 1; i >= 0; --i) {
                    DBRecordField field = dbRecord.getFieldAt(i);
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(field.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FIELD"), field.getType()));
                }
                resultString = ((DBType)flow.getType()).getDBFolder().getRefPath();
                break;
            }
            case '.': {
                String[] componentsSplited = str.split("\\.");
                AltaNode model = null;
                for (String component : componentsSplited) {
                    if (model == null) {
                        model = this.getAltaNode();
                    }
                    if (!(model instanceof AltaEquipment) || ((AltaEquipment)model).getSub(component) == null) {
                        return null;
                    }
                    model = ((AltaEquipment)model).getSub(component).getNode();
                }
                if (model == null) break;
                if (model instanceof AltaComponent) {
                    for (AltaFlow port : model.getFlows()) {
                        if (port.getOrientation() == AltaFlow.Orientation.IN) {
                            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_INPUT"), port.getType()));
                            continue;
                        }
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_OUTPUT"), port.getType()));
                    }
                    for (AltaState state : ((AltaComponent)model).getStates()) {
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel(state.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_STATE"), state.getType()));
                    }
                    for (AltaEvent event : ((AltaComponent)model).getEvents()) {
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel(event.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_EVENT"), ""));
                    }
                    if (((AltaComponent)model).getSimuls().size() > 0) {
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel("icone", (Icon)ResIcoOcas.getImageIcon("ICONE_PI"), ""));
                    }
                    resultString = model.getDBFolder().getRefPath();
                }
                if (!(model instanceof AltaEquipment)) break;
                for (AltaSynchro sync : ((AltaEquipment)model).getSynchros()) {
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sync.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_SYNC"), ""));
                }
                for (AltaSub sub : ((AltaEquipment)model).getSubs()) {
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sub.getName(), (Icon)(sub.getNode() instanceof AltaEquipment ? ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_") : ResIcoCore.getImageIcon("FOLDER_COMPONENT_")), ""));
                }
                resultString = model.getDBFolder().getRefPath();
            }
        }
        return resultString;
    }

    private void defineActions() {
        this._tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AltaEquipmentFrame.this._oldTabSelected instanceof AltaEditPanel) {
                    ((AltaEditPanel)AltaEquipmentFrame.this._oldTabSelected).toDoWhenDeActivated();
                } else if (AltaEquipmentFrame.this._oldTabSelected == AltaEquipmentFrame.this._editorTabPane) {
                    AltaEquipmentFrame.this.getAltaNode().setCode(AltaEquipmentFrame.this._codeEditor.getText());
                }
                Component tabSelected = AltaEquipmentFrame.this._tabPane.getSelectedComponent();
                if (tabSelected == AltaEquipmentFrame.this._editorTabPane) {
                    AltaEquipmentFrame.this._editorTabPane.setSelectedIndex(0);
                    try {
                        AltaEquipmentFrame.this._codeEditor.setHeader(AltaEquipmentFrame.this.getAltaNode().getHeader(true));
                    }
                    catch (IOException ioe) {
                        AltaEquipmentFrame.this._codeEditor.setHeader("/*Exception: " + ioe.getMessage() + "*/");
                    }
                    AltaEquipmentFrame.this._codeEditor.setText(AltaEquipmentFrame.this.getAltaNode().getCode());
                    try {
                        AltaEquipmentFrame.this._codeEditor.setBottom(AltaEquipmentFrame.this.getAltaNode().getFooter());
                    }
                    catch (IOException ioe) {
                        AltaEquipmentFrame.this._codeEditor.setBottom("/*Exception: " + ioe.getMessage() + "*/");
                    }
                } else if (tabSelected instanceof AltaEditPanel) {
                    ((AltaEditPanel)tabSelected).toDoWhenActivated();
                }
                AltaEquipmentFrame.this.focusTreatment();
                AltaEquipmentFrame.this._oldTabSelected = tabSelected;
            }
        });
    }

    private void editEquipment(AltaEquipment node) {
        this._generalPanel.setComponent(node);
        this._flowPanel.setComponent(node);
        this._contentPanel.setComponent(node);
        this._syncPanel.setComponent(node);
        this._iconPanel.setComponent(node);
        this.editNode(node);
    }

    @Override
    public void updateLangage() {
        this._generalPanel.updateLangage();
        this._flowPanel.updateLangage();
        this._syncPanel.updateLangage();
        this._iconPanel.updateLangage();
        super.updateLangage();
    }

    @Override
    protected String getDescription() {
        return this._generalPanel.getPropertiesPanel().getComment();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        if (this._oldTabSelected == this._editorTabPane) {
            this.getAltaNode().setCode(this._codeEditor.getText());
        }
        this.updateSelectedOperator();
        if (!this.doSave()) {
            return false;
        }
        this._generalPanel.getCtrlName().setText(this.getDBFolder().getParent().getName());
        this._generalPanel.getPropertiesPanel().updateDBFolder(this.getDBFolder());
        return true;
    }

    public boolean saveAsModel() {
        return false;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._generalPanel.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this._generalPanel.setModified(modified);
    }

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_COMPONENT");
    }

    @Override
    public boolean toDoWhenClosing() {
        if (!super.toDoWhenClosing()) {
            return false;
        }
        if (!this.verifyClose()) {
            return false;
        }
        new DBFolderThreadClose(this.getDBFolder(), this.getApplication(), this._ctrlClose){

            @Override
            protected void firstDo() {
                super.firstDo();
                AltaEquipmentFrame.this._editorHelper.hideWindow();
            }
        }.realiseDo();
        return true;
    }

    @Override
    public void toDoWhenDeActivated() {
        CeciliaGUI gui = this.getApplication().getTopWindow();
        if (this._tabPane.getSelectedComponent() instanceof AltaEditPanel) {
            ((AltaEditPanel)this._tabPane.getSelectedComponent()).toDoWhenDeActivated();
            gui.setEnabledAction("SEARCH", false);
        }
        ((SearchAction)gui.getAction("SEARCH")).saveContextDlg(this.getApplication(), this, SearchDlg.SearchType.ARCHITECTURE, this.getAltaNode().getRefPath());
        if (this._editorHelper != null) {
            this._editorHelper.hideWindow();
        }
        super.toDoWhenDeActivated();
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        if (this._tabPane.getSelectedComponent() instanceof AltaEditPanel) {
            ((AltaEditPanel)this._tabPane.getSelectedComponent()).toDoWhenActivated();
            CeciliaGUI gui = this.getApplication().getTopWindow();
            gui.setEnabledAction("SEARCH", true);
            ((SearchAction)gui.getAction("SEARCH")).updateContextDlg(this.getApplication(), this, SearchDlg.SearchType.ARCHITECTURE, this._contentPanel.getAltaComponent().getRefPath());
        }
        this.focusTreatment();
    }

    @Override
    public boolean isEditable() {
        return !this.isReadOnly();
    }

    @Override
    protected GenerateAltaricaCode generateCode() {
        if (this._oldTabSelected == this._editorTabPane) {
            this.getAltaNode().setCode(this._codeEditor.getText());
        }
        this.updateSelectedOperator();
        return super.generateCode();
    }

    @Override
    public IModel getModel(String key) {
        if (key.equals("docbook.file") || key.equals("word.file")) {
            return this.getModel(key, "Equipment_");
        }
        return super.getModel(key);
    }

    @Override
    protected void configBook(ExpBook book) {
        XPortCfgEquipment xcfg = new XPortCfgEquipment();
        xcfg.configBook(book, this.getAltaNode());
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getAltaNode().getLogs());
        this.getAltaNode().update(this.getApplication().getDAOFactory(), logMng);
        this._flowPanel.refreshTable();
        this._iconPanel.refreshTable();
        this._syncPanel.refreshTable();
        this.getAltaNode().computeControlPoints();
        this._contentPanel.refreshContent();
        this._generalPanel.fireRefresh(false);
        this.getAltaNode().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getAltaNode().getUseRelations());
        this.updateLogs(this.getAltaNode().getUseRelations(), oldLevel, oldNbr);
    }

    @Override
    protected void updatePrivateLogs() {
        this.getAltaNode().updateLinksLogs(this.getApplication().getDBUser().getLogin(), this.getAltaNode().getLinks());
    }
}

