/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.lib.util.io.BasicLexer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AltaEquipmentTreeModel
extends DefaultTreeModel {
    VisibleField _filter = VisibleField.ALL;
    boolean _onlySub = false;
    boolean _withoutEmptySub = false;

    public AltaEquipmentTreeModel() {
        this(new AltaEquipment(null));
    }

    public AltaEquipmentTreeModel(AltaEquipment eqpRoot) {
        super(new DefaultMutableTreeNode(eqpRoot));
        this.instanciateNode((DefaultMutableTreeNode)this.root);
    }

    @Override
    public void setRoot(TreeNode newRoot) {
        this.getRoot().removeAllChildren();
        if (!(newRoot instanceof DefaultMutableTreeNode)) {
            return;
        }
        super.setRoot((DefaultMutableTreeNode)newRoot);
        this.instanciateNode((DefaultMutableTreeNode)newRoot);
        this.nodeStructureChanged(newRoot);
    }

    private void instanciateNode(DefaultMutableTreeNode parent) {
        Object obj = parent.getUserObject();
        if (this.isLeafEqp(obj)) {
            return;
        }
        for (int i = 0; i < this.getChildCountEqp(obj); ++i) {
            Object child = this.getChildEqp(obj, i);
            if (this._withoutEmptySub && this.isNodeEmpty(child)) continue;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(child);
            parent.add(node);
            this.instanciateNode(node);
        }
    }

    public void setRoot(AltaEquipment eqpRoot) {
        this.setRoot(eqpRoot, false);
    }

    public void setRoot(AltaEquipment eqpRoot, boolean force) {
        if (this.getRoot().getUserObject() == eqpRoot && !force) {
            return;
        }
        this.setRoot(new DefaultMutableTreeNode(eqpRoot));
    }

    @Override
    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    public void setFilter(VisibleField filter) {
        this._filter = filter;
    }

    public void setOnlySub(boolean onlySub) {
        this._onlySub = onlySub;
    }

    public void setWithoutEmptySub(boolean value) {
        this._withoutEmptySub = value;
    }

    private AltaComponent getNodeEqp(Object parent) {
        if (parent instanceof AltaEquipment) {
            return (AltaEquipment)parent;
        }
        if (parent instanceof AltaSub) {
            return ((AltaSub)parent).getNode();
        }
        return null;
    }

    private boolean withField(VisibleField field, AltaComponent node) {
        if (this._onlySub && node == this.getRoot().getUserObject()) {
            return false;
        }
        if (field == this._filter) {
            return true;
        }
        switch (field) {
            case EVENTS: 
            case OPERATORS: 
            case VARS: {
                return this._filter == VisibleField.ALL;
            }
            case FLOWS: 
            case STATES: {
                return this._filter == VisibleField.ALL || this._filter == VisibleField.VARS;
            }
        }
        return false;
    }

    private boolean isNodeEmpty(Object current) {
        AltaComponent node = null;
        if (current instanceof AltaComponent) {
            node = (AltaComponent)current;
        } else if (current instanceof AltaSub) {
            node = ((AltaSub)current).getNode();
        } else {
            return false;
        }
        if (this.withField(VisibleField.EVENTS, node) && !node.getEvents().isEmpty()) {
            return false;
        }
        if (this.withField(VisibleField.FLOWS, node) && !node.getFlows().isEmpty()) {
            return false;
        }
        if (this.withField(VisibleField.STATES, node) && !node.getStates().isEmpty()) {
            return false;
        }
        if (this.withField(VisibleField.OPERATORS, node) && !node.getUsedOperator().isEmpty()) {
            return false;
        }
        if (node instanceof AltaEquipment) {
            AltaEquipment equip = (AltaEquipment)node;
            if (this.withField(VisibleField.EVENTS, node) && !equip.getSynchros().isEmpty()) {
                return false;
            }
            for (AltaSub sub : equip.getSubs()) {
                if (this.isNodeEmpty(sub)) continue;
                return false;
            }
        }
        return true;
    }

    public int getChildCountEqp(Object parent) {
        int nbr = 0;
        AltaComponent node = this.getNodeEqp(parent);
        if (node != null) {
            if (node instanceof AltaEquipment) {
                AltaEquipment equip = (AltaEquipment)node;
                nbr += equip.getSubs().size();
                if (this.withField(VisibleField.EVENTS, node)) {
                    nbr += equip.getSynchros().size();
                }
            }
            if (this.withField(VisibleField.EVENTS, node)) {
                nbr += node.getEvents().size();
            }
            if (this.withField(VisibleField.FLOWS, node)) {
                nbr += node.getFlows().size();
            }
            if (this.withField(VisibleField.STATES, node)) {
                nbr += node.getStates().size();
            }
            if (this.withField(VisibleField.OPERATORS, node)) {
                nbr += node.getUsedOperator().size();
            }
        }
        return nbr;
    }

    public boolean isLeafEqp(Object child) {
        AltaComponent node = this.getNodeEqp(child);
        return node == null;
    }

    public Object getChildEqp(Object parent, int index) {
        int size = 0;
        AltaComponent node = this.getNodeEqp(parent);
        if (node != null) {
            if (node instanceof AltaEquipment) {
                AltaEquipment equip = (AltaEquipment)node;
                size = equip.getSubs().size();
                if (index < size) {
                    return equip.getListSubs().get(index);
                }
                index -= size;
                if (this.withField(VisibleField.EVENTS, node)) {
                    size = equip.getSynchros().size();
                    if (index < size) {
                        return equip.getSynchros().get(index);
                    }
                    index -= size;
                }
            }
            if (this.withField(VisibleField.EVENTS, node)) {
                size = node.getEvents().size();
                if (index < size) {
                    return node.getEvents().get(index);
                }
                index -= size;
            }
            if (this.withField(VisibleField.FLOWS, node)) {
                size = node.getFlows().size();
                if (index < size) {
                    return node.getFlows().get(index);
                }
                index -= size;
            }
            if (this.withField(VisibleField.STATES, node)) {
                size = node.getStates().size();
                if (index < size) {
                    return node.getStates().get(index);
                }
                index -= size;
            }
            if (this.withField(VisibleField.OPERATORS, node)) {
                size = node.getUsedOperator().size();
                if (index < size) {
                    return node.getUsedOperator().get(index);
                }
                index -= size;
            }
        }
        return null;
    }

    public TreePath constructTreePath(String path) {
        DefaultMutableTreeNode last = this.getRoot();
        TreePath treepath = new TreePath(last);
        BasicLexer lexer = new BasicLexer(path);
        String tok = lexer.readNextIdentify(true);
        boolean stop = false;
        while (!stop && tok != null && tok.length() > 0) {
            Object obj = this.getNodeEqp(last.getUserObject());
            if (obj instanceof AltaEquipment) {
                AltaSub value = ((AltaEquipment)obj).getSub(tok);
                if (value == null) {
                    obj = ((AltaComponent)obj).getFieldWithName(tok);
                    stop = true;
                } else {
                    obj = value;
                }
            } else {
                obj = ((AltaComponent)obj).getFieldWithName(tok);
                stop = true;
            }
            if (obj == null) {
                return null;
            }
            DefaultMutableTreeNode child = null;
            for (int i = 0; i < last.getChildCount(); ++i) {
                DefaultMutableTreeNode tmpChild = (DefaultMutableTreeNode)last.getChildAt(i);
                if (tmpChild.getUserObject() != obj) continue;
                child = tmpChild;
                break;
            }
            if (child == null) {
                return null;
            }
            last = child;
            treepath = treepath.pathByAddingChild(last);
            if (lexer.readChar() == '.') {
                tok = lexer.readNextIdentify(true);
                continue;
            }
            stop = true;
        }
        return treepath;
    }

    private void constructPath(TreePath current, StringBuilder builder) {
        Object obj;
        TreePath parent = current.getParentPath();
        if (parent != null) {
            this.constructPath(parent, builder);
        }
        if (builder.length() > 0) {
            builder.append(".");
        }
        if ((obj = current.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            obj = ((DefaultMutableTreeNode)obj).getUserObject();
        }
        if (obj instanceof AltaSub) {
            builder.append(((AltaSub)obj).getName());
        } else if (obj instanceof ObjectWithName) {
            builder.append(((ObjectWithName)obj).getName());
        }
    }

    public String constructPath(TreePath treepath) {
        StringBuilder sb = new StringBuilder();
        this.constructPath(treepath, sb);
        return sb.toString();
    }

    public static enum VisibleField {
        ALL,
        EVENTS,
        VARS,
        FLOWS,
        STATES,
        OPERATORS;

    }
}

