/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractColumnsModel;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaAbstractEventPanel;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaEventListDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaSynchroEditDlg;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaSynchroTableCellRenderer;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;

public class AltaSynchroPanel
extends AltaAbstractEventPanel {
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_EVTS = "events";
    public static final int IDX_TYPE = 10;
    public static final int IDX_EVTS = 11;
    private CeciliaAppl _appl;
    AltaSynchroTable _ctrlTable;
    SynchroTableModel _ctrlTableModel;
    AltaSynchroTableCellRenderer _rendererSynchroTable;
    JLabel _ctrlNameLabel;
    JTextField _ctrlName;
    protected CeciliaAction _ctrlAdd;
    protected CeciliaAction _ctrlDel;
    protected CeciliaAction _ctrlEdit;
    JPopupMenu _popupMenu = new JPopupMenu();
    AltaSynchroEditDlg _dlgEdit;

    public AltaSynchroPanel(CeciliaAppl appl) {
        this._appl = appl;
        this.createActions();
        this.createTable();
        this.make();
    }

    @Override
    public AltaEquipment getAltaComponent() {
        return (AltaEquipment)this._currentComponent;
    }

    private void createTable() {
        this._ctrlTableModel = new SynchroTableModel();
        this._ctrlTable = new AltaSynchroTable((AltaAbstractEventPanel.AltaAbstractEventTableModel)this._ctrlTableModel);
        this._ctrlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AltaSynchroPanel.this.selectEvent();
            }
        });
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaSynchroPanel.this.addEvent();
                AltaSynchroPanel.this._ctrlName.setText("");
                AltaSynchroPanel.this._ctrlName.requestFocus();
            }
        }.setDesc(ResMsgOcas.getString("CMD_EVENT_ADD"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] viewIndices;
                if (AltaSynchroPanel.this._appl.isReader()) {
                    return;
                }
                if (AltaSynchroPanel.this.getAltaComponent() != null && (viewIndices = AltaSynchroPanel.this._ctrlTable.getSelectedRows()).length != 0) {
                    int[] modelIndices = new int[viewIndices.length];
                    for (int i = viewIndices.length - 1; i >= 0; --i) {
                        modelIndices[i] = AltaSynchroPanel.this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
                    }
                    Arrays.sort(modelIndices);
                    List<AltaSynchro> events = AltaSynchroPanel.this.getAltaComponent().getSynchros();
                    for (int i = modelIndices.length - 1; i >= 0; --i) {
                        events.remove(modelIndices[i]);
                    }
                    AltaSynchroPanel.this._ctrlTable.clearSelection();
                    AltaSynchroPanel.this.refreshTable();
                    AltaSynchroPanel.this.getAltaComponent().setModified(true);
                    AltaSynchroPanel.this._ctrlName.setText("");
                }
            }
        }.setDesc(ResMsgOcas.getString("CMD_EVENT_DEL"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AltaSynchroPanel.this.getAltaComponent() == null) {
                    return;
                }
                AltaSynchroPanel.this.doEditEvents();
            }
        }.setDesc(ResMsgOcas.getString("CMD_EVENT_EDIT"));
        this._popupMenu.add(this._ctrlEdit.createMenuItem());
        this._popupMenu.add(this._ctrlDel.createMenuItem());
    }

    private void make() {
        JButton fieldsDlg = new JButton(ResMsgVoc.getString("VOC_FIELDS"));
        JToolBar panelEventButton = new JToolBar();
        JPanel panelEventValue = new JPanel();
        this.setLayout(new GridBagLayout());
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        this.add((Component)scrollTable, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)fieldsDlg, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        if (!this._appl.isReader()) {
            scrollTable.setComponentPopupMenu(this._popupMenu);
            this.add((Component)panelEventButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)panelEventValue, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        panelEventButton.add(Box.createGlue());
        panelEventButton.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createGlue());
        panelEventButton.setFloatable(false);
        fieldsDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<PrefFieldBoolean> originItems = AltaSynchroPanel.this._ctrlTableModel.getColumns().getOptionnalFields();
                List<PrefFieldBoolean> copyItems = PrefFieldsFactory.clone(originItems);
                if (!PrefFieldsFactory.displayDlgChangeFields(AltaSynchroPanel.this._ctrlTable, copyItems)) {
                    return;
                }
                boolean change = PrefFieldsFactory.copySelected(copyItems, originItems);
                if (change) {
                    AltaSynchroPanel.this._ctrlTableModel.getColumns().resetFilterIndexes();
                    AltaSynchroPanel.this._ctrlTableModel.fireTableChanged(new TableModelEvent(AltaSynchroPanel.this._ctrlTableModel, -1));
                    AltaSynchroPanel.this._ctrlTable.updateSorter();
                }
            }
        });
        this._ctrlNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlNameLabel.setForeground(Color.black);
        this._ctrlName = new JTextField("");
        this._ctrlName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AltaSynchroPanel.this.addEvent();
                    AltaSynchroPanel.this._ctrlName.setText("");
                    AltaSynchroPanel.this._ctrlName.requestFocus();
                }
            }
        });
        panelEventValue.setLayout(new GridBagLayout());
        panelEventValue.setBorder(BorderFactory.createEtchedBorder());
        panelEventValue.add((Component)this._ctrlNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelEventValue.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.selectEvent();
    }

    @Override
    protected String validateName(String name) {
        if (name.equals("no_event")) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.msgFormat("MODEL_EDIT_RESERVED_WORD", name), ResMsgVoc.getString("VOC_ERROR"), 0);
            return null;
        }
        return super.validateName(name);
    }

    public void refreshTable() {
        this._ctrlTableModel.fireTableDataChanged();
    }

    @Override
    public void focusTreatment() {
        this.requestFocus();
        this._ctrlName.requestFocus();
    }

    protected void doEditSync() {
        int[] indices = this._ctrlTable.getSelectedRows();
        if (indices.length != 1) {
            return;
        }
        if (this._dlgEdit == null) {
            AltaSynchroEditDlg dlg = new AltaSynchroEditDlg(SwingUtilities.getWindowAncestor(this));
            if (this._dlgEdit == null) {
                this._dlgEdit = dlg;
            }
        }
        this._dlgEdit.setEditable(!this._appl.isReader());
        int idxModel = this._ctrlTable.convertRowIndexToModel(indices[0]);
        List<AltaSynchro> allSynchro = this.getAltaComponent().getSynchros();
        this._dlgEdit.setSynchro(allSynchro.get(idxModel), allSynchro, this.getAltaComponent());
        this._dlgEdit.setVisible(true);
        if (this._dlgEdit.getResult()) {
            AltaSynchro select = allSynchro.get(idxModel);
            select.setName(this._dlgEdit.getName());
            select.setLabel(this._dlgEdit.getLabel());
            select.setEvents(this._dlgEdit.getEvents());
            this._ctrlTableModel.fireTableRowsUpdated(idxModel, idxModel);
            this.getAltaComponent().setModified(true);
        }
    }

    protected void doEditEvents() {
        int[] viewIndices = this._ctrlTable.getSelectedRows();
        if (viewIndices.length == 0) {
            return;
        }
        int[] modelIndices = new int[viewIndices.length];
        ArrayList<AltaEvent> selectEvents = new ArrayList<AltaEvent>(viewIndices.length);
        for (int i = 0; i < viewIndices.length; ++i) {
            modelIndices[i] = this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
            selectEvents.add(this.getAltaComponent().getSynchros().get(modelIndices[i]));
        }
        if (!this.displayDlgEventsEdit(selectEvents, this._appl)) {
            return;
        }
        this.refreshTable();
        ListSelectionModel selectModel = this._ctrlTable.getSelectionModel();
        selectModel.setValueIsAdjusting(true);
        selectModel.clearSelection();
        for (int i = 0; i < modelIndices.length; ++i) {
            int rowView = this._ctrlTable.convertRowIndexToView(modelIndices[i]);
            selectModel.addSelectionInterval(rowView, rowView);
        }
        selectModel.setValueIsAdjusting(false);
        this.getAltaComponent().setModified(true);
    }

    public void addEvent() {
        if (this.getAltaComponent() == null) {
            return;
        }
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO && this.getAltaComponent().getSynchros().size() >= DemoLimits.Limit.EQUIPMENT_SYNCS.getLimit()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlTable), ResMsgOcas.getString("DEMO_EQUIPMENT_SYNCS"), JOptionCecilia.getTopTitleOf(this._ctrlTable), 0);
            return;
        }
        String name = this._ctrlName.getText();
        if ((name = this.validateName(name)) == null || name.isEmpty()) {
            return;
        }
        AltaSynchro event = new AltaSynchro(name);
        event.initialise(this._appl);
        this.getAltaComponent().getSynchros().add(event);
        int idxModel = this.getAltaComponent().getSynchros().size() - 1;
        this.refreshTable();
        int idxView = this._ctrlTable.convertRowIndexToView(idxModel);
        this._ctrlTable.setRowSelectionInterval(idxView, idxView);
        this.getAltaComponent().setModified(true);
    }

    public void selectEvent() {
        int[] indices = this._ctrlTable.getSelectedRows();
        if (indices.length != 0) {
            this._ctrlDel.setEnabled(!this._appl.isReader());
            this._ctrlEdit.setEnabled(true);
            if (this.getAltaComponent() != null && indices.length == 1) {
                this._ctrlName.setText(this.getAltaComponent().getSynchros().get(this._ctrlTable.convertColumnIndexToModel(indices[0])).getName());
            } else {
                this._ctrlName.setText("");
            }
        } else {
            this._ctrlDel.setEnabled(false);
            this._ctrlEdit.setEnabled(false);
        }
    }

    @Override
    public void setComponent(AltaComponent currentComponent) {
        super.setComponent(currentComponent);
        this.refreshTable();
    }

    public void updateLangage() {
        this._ctrlNameLabel.setText(ResMsgVoc.getString("VOC_NAME"));
        this.refreshTable();
        this._ctrlDel.setName(ResMsgVoc.getString("VOC_DELETE"));
        this._ctrlDel.setDesc(ResMsgOcas.getString("CMD_EVENT_DEL"));
        this._ctrlEdit.setName(ResMsgVoc.getString("VOC_EDIT"));
        this._ctrlEdit.setDesc(ResMsgOcas.getString("CMD_EVENT_EDIT"));
        this._ctrlAdd.setDesc(ResMsgOcas.getString("CMD_EVENT_ADD"));
    }

    public void changePreferencies(Preferencies prefs) {
        boolean refreshTable = false;
        PluginWithOptions opts = prefs.getOptions(AltaEventListDisplayPreferencies.PREF_KEY);
        if (opts != null && opts instanceof AltaEventListDisplayPreferencies) {
            int maxNbr = this._rendererSynchroTable.getMaxNbr();
            int nbrEvt = ((AltaEventListDisplayPreferencies)opts).getNbrEvents();
            if (nbrEvt > 0 && nbrEvt != maxNbr) {
                this._rendererSynchroTable.setMaxNbr(nbrEvt);
                refreshTable = true;
            }
        }
        if (refreshTable) {
            this._ctrlTableModel.fireTableDataChanged();
        }
    }

    public class SynchroTableModel
    extends AltaAbstractEventPanel.AltaAbstractEventTableModel {
        SynchroTableModel() {
            this._columnModel = this.createColumnsModel();
            PluginWithOptions prefs = AltaSynchroPanel.this._appl.getPreferencies().getOptions(AltaEventListDisplayPreferencies.PREF_KEY);
            if (prefs == null || !(prefs instanceof AltaEventListDisplayPreferencies)) {
                prefs = new AltaEventListDisplayPreferencies();
                AltaSynchroPanel.this._appl.getPreferencies().addOptions(prefs);
                prefs.refreshOptions(AltaSynchroPanel.this._appl.getPlugable());
            }
            List<PrefFieldBoolean> listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
            this._columnModel.setOptionnalFields(PrefFieldsFactory.clone(listPrefs));
        }

        public SynchroColumnsModel getColumns() {
            return (SynchroColumnsModel)this._columnModel;
        }

        @Override
        public int getRowCount() {
            if (AltaSynchroPanel.this.getAltaComponent() == null) {
                return 0;
            }
            return AltaSynchroPanel.this.getAltaComponent().getSynchros().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (AltaSynchroPanel.this.getAltaComponent() == null) {
                return "null";
            }
            switch (this._columnModel.getColumnField(col).getIdxCode()) {
                case 1: {
                    return AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row).getName();
                }
                case 10: {
                    return AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row).getType();
                }
                case 11: {
                    return AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row);
                }
                case 100: {
                    return StringUtilities.escapeCR((String)AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row).getLabel());
                }
                case 101: {
                    AltaEvent event = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row);
                    return event.getModelLaw();
                }
                case 102: {
                    AltaEvent event = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row);
                    Law law = null;
                    DBModelLaw dbMLaw = event.getModelLaw();
                    if (dbMLaw != null) {
                        law = dbMLaw.getLaw();
                    }
                    if (law == null) {
                        law = event.getOccurrence();
                    }
                    return law;
                }
                case 103: {
                    AltaEvent event = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row);
                    return event.getInspected();
                }
                case 104: {
                    AltaEvent event = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row);
                    return event.getInflightTested();
                }
                case 110: {
                    AltaEvent event = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row);
                    String attributes = event.getAttributesAsDisplayedString();
                    if (attributes == null || attributes.isEmpty()) {
                        return "-";
                    }
                    return attributes;
                }
                case 111: {
                    AltaEvent event = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row);
                    Set<Param> params = event.recupParams(new LinkedHashSet<Param>(), new FctParamSelect.FctParamFMEA());
                    return ParamFMEA.transcodeCollections(params);
                }
            }
            return " ";
        }

        @Override
        public Class getColumnClass(int col) {
            switch (this._columnModel.getColumnField(col).getIdxCode()) {
                case 10: {
                    return AltaSynchro.Type.class;
                }
                case 11: {
                    return AltaSynchro.class;
                }
            }
            return super.getColumnClass(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (AltaSynchroPanel.this._appl.isReader()) {
                return false;
            }
            if (AltaSynchroPanel.this._ctrlTable.getSelectedRows().length != 1) {
                return false;
            }
            switch (this._columnModel.getColumnField(col).getIdxCode()) {
                case 1: 
                case 10: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            switch (this._columnModel.getColumnField(col).getIdxCode()) {
                case 1: {
                    String name = (String)aValue;
                    String oldName = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row).getName();
                    if (oldName.equals(name) || (name = AltaSynchroPanel.this.validateName(name)) == null) break;
                    AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row).setName(name);
                    AltaSynchroPanel.this.refreshTable();
                    int rowView = AltaSynchroPanel.this._ctrlTable.convertRowIndexToView(row);
                    AltaSynchroPanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
                    AltaSynchroPanel.this.getAltaComponent().setModified(true);
                    break;
                }
                case 10: {
                    AltaSynchro.Type oldType = AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row).getType();
                    if (oldType.equals(aValue)) break;
                    AltaSynchroPanel.this.getAltaComponent().getSynchros().get(row).setType((AltaSynchro.Type)((Object)aValue));
                    AltaSynchroPanel.this.refreshTable();
                    int rowView = AltaSynchroPanel.this._ctrlTable.convertRowIndexToView(row);
                    AltaSynchroPanel.this._ctrlTable.setRowSelectionInterval(rowView, rowView);
                    AltaSynchroPanel.this.getAltaComponent().setModified(true);
                    break;
                }
            }
        }

        @Override
        protected ItemAbstractColumnsModel createColumnsModel() {
            return new SynchroColumnsModel();
        }
    }

    private class AltaSynchroTable
    extends AltaAbstractEventPanel.AltaAbstractEventTable {
        public AltaSynchroTable(AltaAbstractEventPanel.AltaAbstractEventTableModel model) {
            super(model);
            AltaSynchroPanel.this._rendererSynchroTable = new AltaSynchroTableCellRenderer();
            this.setDefaultRenderer(AltaSynchro.Type.class, new AltaSynchro.Type.SpecificTableCellRenderer());
            this.setDefaultRenderer(AltaSynchro.class, AltaSynchroPanel.this._rendererSynchroTable);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (AltaSynchroPanel.this.getAltaComponent() == null) {
                        return;
                    }
                    if (AltaSynchroPanel.this._ctrlTable.getSelectedRowCount() == 1) {
                        int[] indices = AltaSynchroPanel.this._ctrlTable.getSelectedRows();
                        AltaSynchroPanel.this._ctrlName.setText(AltaSynchroPanel.this.getAltaComponent().getSynchros().get(AltaSynchroPanel.this._ctrlTable.convertColumnIndexToModel(indices[0])).getName());
                    } else {
                        AltaSynchroPanel.this._ctrlName.setText("");
                    }
                }
            });
            this.getActionMap().put("DELETE", AltaSynchroPanel.this._ctrlDel);
            this.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        }

        @Override
        protected boolean withSorter() {
            return true;
        }

        @Override
        protected List<Integer> getUnsortableCols() {
            return Arrays.asList(((AltaAbstractEventPanel.AltaAbstractEventTableModel)this.getModel()).getColumnIdxByCode(11));
        }

        @Override
        public void createDefaultColumnsFromModel() {
            super.createDefaultColumnsFromModel();
            TableColumnModel colModel = this.getColumnModel();
            SynchroColumnsModel syncColModel = AltaSynchroPanel.this._ctrlTableModel.getColumns();
            for (int c = 0; c < this.getColumnCount(); ++c) {
                int idxModel = this.convertColumnIndexToModel(c);
                int size = ((Number)syncColModel.getColumnField(idxModel).getInfo("Width")).intValue();
                colModel.getColumn(c).setPreferredWidth(size * 13);
                if (10 != syncColModel.getColumnField(idxModel).getIdxCode()) continue;
                JComboBox<Object> ctrlEditType = new JComboBox<Object>();
                ctrlEditType.addItem((Object)AltaSynchro.Type.CCF);
                ctrlEditType.addItem((Object)AltaSynchro.Type.DIFF);
                ctrlEditType.addItem((Object)AltaSynchro.Type.MEC);
                ctrlEditType.setRenderer(new AltaSynchro.Type.SpecificListCellRenderer());
                colModel.getColumn(c).setCellEditor(new DefaultCellEditor(ctrlEditType));
            }
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            if (AltaSynchroPanel.this.getAltaComponent() == null) {
                return;
            }
            int columnView = AltaSynchroPanel.this._ctrlTable.columnAtPoint(e.getPoint());
            int columnDoc = AltaSynchroPanel.this._ctrlTable.convertColumnIndexToModel(columnView);
            int idxCol = AltaSynchroPanel.this._ctrlTableModel.getColumns().getColumnField(columnDoc).getIdxCode();
            if (idxCol == 11) {
                AltaSynchroPanel.this.doEditSync();
            } else if (idxCol > 11) {
                AltaSynchroPanel.this.doEditEvents();
            }
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            String superResult = super.convertToString(obj, row, col);
            if (superResult != null) {
                return superResult;
            }
            row = this.convertRowIndexToModel(row);
            col = this.convertColumnIndexToModel(col);
            Object objCol = this.getModel().getValueAt(row, col);
            switch (this.getItemColumnModel().getColumnField(col).getIdxCode()) {
                case 10: {
                    if (objCol == null) {
                        return "";
                    }
                    return objCol.toString();
                }
                case 11: {
                    StringBuilder sb = new StringBuilder();
                    if (obj == null) {
                        return "";
                    }
                    AltaSynchro synchro = (AltaSynchro)obj;
                    List<String> listEvents = synchro.getEvents();
                    for (String event : listEvents) {
                        sb.append(event);
                        sb.append("\t");
                    }
                    return sb.toString();
                }
            }
            return null;
        }
    }

    protected static class SynchroColumnsModel
    extends ItemAbstractColumnsModel {
        PrefFieldBoolean _nameItem = new PrefFieldBoolean(ResMsgVoc.getString("VOC_NAME"), "nom", 1, 10, "L");
        PrefFieldBoolean _typeItem = new PrefFieldBoolean(ResMsgVoc.getString("VOC_TYPE"), "type", 10, 8, "L");
        PrefFieldBoolean _evtsItem = new PrefFieldBoolean(ResMsgVoc.getString("VOC_EVENTS"), "events", 11, 14, "C");

        public SynchroColumnsModel() {
            this.init();
        }

        @Override
        public List<PrefFieldBoolean> createOptionnalFields() {
            return AltaAbstractEventPanel.createFields();
        }

        @Override
        public void setOptionnalFields(List<PrefFieldBoolean> optionnalFields) {
            this._optionnalFields = optionnalFields;
            this._items.clear();
            this._items.add(this._nameItem);
            this._items.add(this._typeItem);
            this._items.add(this._evtsItem);
            for (PrefFieldBoolean item : this._optionnalFields) {
                this._items.add(item);
            }
            this.resetFilterIndexes();
        }
    }
}

