/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTreeModel;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelect;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderPanelSelectFilterFlags;
import com.dassault.cecilia.core.cecilia.folder.gui.DBFolderSelectUtility;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLine;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPolygone;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdLinkCreate;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlg;
import com.dassault.cecilia.lib.util.CopyUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class OCmdCreateEqpFromSelec
extends OCCmd {
    private DBFolder _dbFolderSystem;
    private String _nameEqp;
    private AltaEquipment _eqp;
    private AltaSub _subEqp;
    private Collection<AlgaLink> _linksToDelete;
    private Collection<AlgaLink> _linksToAdd;
    private AlgaSheet _sheet;
    private Collection<AlgaGraph> _graphSelectedFromSrc;
    private Collection<AlgaNode> _nodes;
    private Collection<AlgaLink> _links;
    private Collection<AlgaGraph> _forms;
    private AltaContentDisplayPreferencies.LinkDisplay _linkDisplay = this.getView().getContext().getLinkDisplay();
    private static EquipmentDlgChooser _dbFTChooser = null;
    private static Object _LockerDlgChooser = new Object();

    public OCmdCreateEqpFromSelec(CeciliaAppl appl, AltaContentPanel c) {
        super(appl, c);
    }

    @Override
    protected boolean prepareDo() {
        int res;
        this._graphSelectedFromSrc = this.getContent().getSelectedGraphs();
        this._nodes = this._graphSelectedFromSrc.stream().filter(e -> e instanceof AlgaNode).map(e -> (AlgaNode)e).collect(Collectors.toList());
        this.computeLinksFromGraphs(this._nodes);
        this._forms = this.getForms(this._graphSelectedFromSrc);
        Collection copyNodes = new ArrayList<AlgaNode>(this._nodes).stream().map(AlgaNode::getLogical).collect(Collectors.toList());
        for (AlgaLink algaLink : this._links) {
            AltaLink tLink = algaLink.getLogical();
            copyNodes.remove(tLink.getFromSub());
            copyNodes.remove(tLink.getToSub());
        }
        if (!copyNodes.isEmpty() && (res = JOptionPane.showConfirmDialog(this.getPanel(), ResMsgOcas.getString("CMD_CREATE_EQP_WARNING_NOT_RELATED"), ResMsgOcas.getString("MENU_CREATE_EQP_FROM_SELECTION"), 0)) != 0) {
            return false;
        }
        this._sheet = null;
        boolean sameSheet = true;
        for (AlgaNode node : this._nodes) {
            if (this._sheet == null) {
                this._sheet = (AlgaSheet)node.getParent();
                continue;
            }
            if (this._sheet == node.getParent()) continue;
            sameSheet = false;
        }
        for (AlgaGraph grf : this._forms) {
            AlgaContainer parent = grf.getParent();
            if (parent instanceof AlgaSheet) {
                sameSheet &= this._sheet == parent;
                continue;
            }
            if (!(parent instanceof AlgaGroup)) continue;
            sameSheet &= this._sheet == parent.getParent();
        }
        if (!sameSheet) {
            JOptionPane.showMessageDialog(this.getPanel(), ResMsgOcas.getString("CMD_CREATE_EQP_ERROR_NOT_SAME_SHEET"), ResMsgOcas.getString("MENU_CREATE_EQP_FROM_SELECTION"), 0);
            return false;
        }
        EquipmentDlgChooser equipmentDlgChooser = this.getDlgChooser(JOptionCecilia.getWindowOf(this.getSource()), this.getAppl());
        equipmentDlgChooser.setVisible(true);
        if (!equipmentDlgChooser.getResult()) {
            return false;
        }
        this._dbFolderSystem = equipmentDlgChooser.getSelectFolder();
        this._nameEqp = equipmentDlgChooser.getNewName();
        return super.prepareDo();
    }

    @Override
    protected void firstDo() {
        AlgaGraph copy;
        LinkedHashSet<AlgaGraph> graphs = new LinkedHashSet<AlgaGraph>();
        graphs.addAll(this._nodes);
        graphs.addAll(this._links);
        int[] computeBounds = this.computeBounds(graphs);
        DBFolder[] dbPrepare = DBFactory.createModel(this._dbFolderSystem, this.getAppl().getDBUser(), this._nameEqp, "1", DBFolder.Family.EQUIPMENT, (short)0, (short)0);
        this._eqp = new AltaEquipment(dbPrepare[1]);
        CopyUtility.Default utility = new CopyUtility.Default();
        AlgaSheet sheet = this._eqp.getContent().getSheets().get(0);
        int i = 0;
        LinkedHashMap<AltaSub, AltaSub> oldSubToNewSub = new LinkedHashMap<AltaSub, AltaSub>();
        for (AlgaNode algaNode : this._nodes) {
            AltaSub sub = algaNode.getLogical().getCopy((CopyUtility)utility);
            copy = algaNode.getCopy(false, (CopyUtility)utility);
            this.updateXY(copy, -computeBounds[0] + 75, -computeBounds[1] + 75);
            sub.setGraphic((AlgaNode)copy);
            sheet.add(copy, i++);
            this._eqp.addSub(sub);
            oldSubToNewSub.put(algaNode.getLogical(), sub);
        }
        HashSet<AlgaLink> newLinks = new HashSet<AlgaLink>();
        for (AlgaLink link : this._links) {
            AltaLink tLink = link.getLogical().getCopy((CopyUtility)utility);
            utility.setRef((Object)link.getLogical(), (Object)tLink);
            AlgaLink gLink = link.getCopy(true, (CopyUtility)utility);
            for (Pt pt : gLink.getPoints()) {
                this.updateXY(pt, -computeBounds[0] + 75, -computeBounds[1] + 75);
            }
            gLink.computeControlPoints();
            sheet.add(gLink, this._linkDisplay == AltaContentDisplayPreferencies.LinkDisplay.BG ? -1 : (this._linkDisplay == AltaContentDisplayPreferencies.LinkDisplay.FG ? Integer.MAX_VALUE : i++));
            newLinks.add(gLink);
            this._eqp.addLink(tLink);
        }
        for (AlgaGraph graph : this._forms) {
            copy = graph.getCopy(true, (CopyUtility)utility);
            boolean outOfBounds = this.moveGraph(copy, -computeBounds[0] + 75, -computeBounds[1] + 75);
            while (outOfBounds) {
                outOfBounds = this.moveGraph(copy, 50, 50);
            }
            sheet.add(copy, i++);
        }
        int n = computeBounds[2] - computeBounds[0];
        this._eqp.setWidth(n);
        int heightEqp = computeBounds[3] - computeBounds[1];
        this._eqp.setHeight(heightEqp);
        this._eqp.getContent().computeSize(null);
        Map<AltaSub, Set<AltaFlow>> flowsToCreate = this.getFlowsToCreate(oldSubToNewSub);
        ArrayList<AltaFlow> newFlows = new ArrayList<AltaFlow>();
        ArrayList<PortToSub> listPortToSub = new ArrayList<PortToSub>();
        for (Map.Entry<AltaSub, Set<AltaFlow>> entry : flowsToCreate.entrySet()) {
            AltaSub sub = entry.getKey();
            Set<AltaFlow> flows = entry.getValue();
            for (AltaFlow flow : flows) {
                StringBuilder sb = new StringBuilder();
                sb.append(flow.getName());
                sb.append('_');
                sb.append(sub.getName());
                AltaFlow newFlow = new AltaFlow(sb.toString(), flow.getType());
                newFlow.setOrientation(flow.getOrientation());
                AlgaTransform transform = sub.getGraphic().getTransform();
                Pt pt = transform.convertPoint(flow.getX(), flow.getY(), sub.getGraphic().getW(), sub.getGraphic().getH());
                int xOnSub = pt.getX();
                int yOnSub = pt.getY();
                xOnSub = xOnSub == 0 ? 0 : (xOnSub == (transform.isRotate() ? sub.getNode().getHeight() : sub.getNode().getWidth()) ? n : sub.getGraphic().getX() - 75 + xOnSub);
                yOnSub = yOnSub == 0 ? 0 : (yOnSub == (transform.isRotate() ? sub.getNode().getWidth() : sub.getNode().getHeight()) ? heightEqp : sub.getGraphic().getY() - 75 + yOnSub);
                newFlow.setX(xOnSub);
                newFlow.setY(yOnSub);
                AlgaPort port = this._eqp.createPort(newFlow);
                if (xOnSub == 0) {
                    port.setCX(40);
                } else if (xOnSub == n) {
                    port.setCX(this._eqp.getContent().getWidth() - 40);
                } else {
                    port.setCX(sub.getGraphic().getX() + pt.getX());
                }
                if (yOnSub == 0) {
                    port.setCY(40);
                } else if (yOnSub == heightEqp) {
                    port.setCY(this._eqp.getContent().getHeight() - 40);
                } else {
                    port.setCY(sub.getGraphic().getY() + pt.getY());
                }
                sheet.add(port, i++);
                listPortToSub.add(new PortToSub(port, sub, flow));
                newFlows.add(newFlow);
            }
        }
        this._eqp.setFlows(newFlows);
        for (PortToSub portToSub : listPortToSub) {
            AlgaPort port = portToSub.getPort();
            AltaSub sub = portToSub.getSub();
            AltaFlow flow = portToSub.getFlow();
            AltaLink link = OCmdLinkCreate.selectValidLink(this.getView(), this._eqp, sub, flow, null, port.getFlow());
            AlgaLink gLink = new AlgaLink().setLogical(link);
            this._eqp.addLink(link);
            gLink.computeControlPoints();
            sheet.add(gLink, i++);
        }
        this._eqp.configureModels(dbPrepare[1].getObject());
        DBFolder dBFolder = this.getAppl().getDAOFactory().createFolderDAO().create(dbPrepare[0]);
        if (dBFolder == null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgObj.msgFormat("MSG_FOL_ERR_CREATE", new Object[0]), JOptionCecilia.getTopTitleOf(this.getSource()), 0);
            return;
        }
        dBFolder.setMustBeUpdated(true);
        this.getAppl().refreshDAOFolder(true);
        SwingUtilities.invokeLater(new DBFolderSelectUtility((DBFolderTree)this.getAppl().getTopWindow().getFolders().getTree(DBFolder.Family.EQUIPMENT), dBFolder));
        this._linksToAdd = new LinkedHashSet<AlgaLink>();
        this._subEqp = new AltaSub(this._eqp, this._nameEqp);
        AlgaNode algaNode = new AlgaNode().setLogical(this._subEqp);
        algaNode.setX(computeBounds[0]);
        algaNode.setY(computeBounds[1]);
        for (PortToSub portToSub : listPortToSub) {
            AltaFlow flowEqp = portToSub.getPort().getFlow();
            AltaSub oldSub = this.getSubSrc(utility, portToSub.getSub());
            AltaFlow flowSub = portToSub.getFlow();
            for (AlgaLink link : this._linksToDelete) {
                AltaLink tLink = link.getLogical();
                AltaFlow fromFlow = tLink.getFromFlow();
                AltaFlow toFlow = tLink.getToFlow();
                AltaSub fromSub = tLink.getFromSub();
                AltaSub toSub = tLink.getToSub();
                AltaLink newLink = null;
                if (fromSub == oldSub && fromFlow == flowSub) {
                    newLink = OCmdLinkCreate.selectInitialValidLink(this.getView(), new HashSet<OCmdLinkCreate.FieldIdentifier>(), this._subEqp, flowEqp, toSub, toFlow, false);
                } else if (toSub == oldSub && toFlow == flowSub) {
                    newLink = OCmdLinkCreate.selectInitialValidLink(this.getView(), new HashSet<OCmdLinkCreate.FieldIdentifier>(), fromSub, fromFlow, this._subEqp, flowEqp, false);
                }
                if (newLink == null) continue;
                if (tLink.getToField() != null) {
                    newLink.setToField(tLink.getToField());
                }
                if (tLink.getFromField() != null) {
                    newLink.setFromField(tLink.getFromField());
                }
                this._linksToAdd.add(new AlgaLink().setLogical(newLink));
            }
        }
        this.redo(true);
        this.getPanel().addHisto(this);
    }

    @Override
    public void undo() {
        AltaEquipment mainEquip = this.getNode();
        for (AlgaLink linkToAdd : this._linksToAdd) {
            mainEquip.delLink(linkToAdd.getLogical());
            this._sheet.remove(linkToAdd);
        }
        mainEquip.delSub(this._subEqp);
        this._sheet.remove(this._subEqp.getGraphic());
        for (AlgaNode node : this._nodes) {
            mainEquip.addSub(node.getLogical());
            this._sheet.add(node, Integer.MAX_VALUE);
        }
        for (AlgaLink link : this._links) {
            mainEquip.addLink(link.getLogical());
            this._sheet.add(link, -1);
        }
        for (AlgaLink link : this._linksToDelete) {
            mainEquip.addLink(link.getLogical());
            this._sheet.add(link, -1);
        }
        for (AlgaGraph form : this._forms) {
            this._sheet.add(form, Integer.MAX_VALUE);
        }
        this.getPanel().refreshContent();
        this.getNode().setModified(true);
        this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
        this.getNode().setChangeInternalStructure(true);
    }

    @Override
    public void redo() {
        this.redo(false);
    }

    private void redo(boolean firstUse) {
        if (!firstUse) {
            DBFolder folder = this._subEqp.getNode().getDBFolder();
            DBFolder find = (DBFolder)this.getAppl().getDAOFactory().createFolderDAO().find(folder.getID());
            if (find == null) {
                JOptionPane.showMessageDialog(this.getPanel(), ResMsgOcas.msgFormat("CMD_CREATE_EQP_ERROR_NOT_EXISTING", folder.getRefPath()), ResMsgOcas.getString("CMD_CREATE_EQP_TITLE_DLG"), 0);
                this.getPanel().getAltaComponent().getUndoManager().clear();
                return;
            }
        }
        AltaEquipment mainEquip = this.getNode();
        for (AlgaLink link : this._links) {
            mainEquip.delLink(link.getLogical());
            this._sheet.remove(link);
        }
        for (AlgaLink link : this._linksToDelete) {
            mainEquip.delLink(link.getLogical());
            this._sheet.remove(link);
        }
        for (AlgaNode node : this._nodes) {
            mainEquip.delSub(node.getLogical());
            this._sheet.remove(node);
        }
        for (AlgaGraph form : this._forms) {
            this._sheet.remove(form);
        }
        mainEquip.addSub(this._subEqp);
        this._sheet.add(this._subEqp.getGraphic(), Integer.MAX_VALUE);
        this._subEqp.getGraphic().computeControlPoints();
        for (AlgaLink linkToAdd : this._linksToAdd) {
            mainEquip.addLink(linkToAdd.getLogical());
            this._sheet.add(linkToAdd, this._linkDisplay == AltaContentDisplayPreferencies.LinkDisplay.BG ? -1 : Integer.MAX_VALUE);
            linkToAdd.computeControlPoints();
        }
        this.getPanel().refreshContent();
        this.getNode().setModified(true);
        this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
        this.getNode().setChangeInternalStructure(true);
    }

    private boolean moveGraph(AlgaGraph copy, int valX, int valY) {
        boolean outOfBounds = false;
        if (copy instanceof AlgaGroup) {
            AlgaGroup grp = (AlgaGroup)copy;
            for (AlgaGraph subGraph : grp.getGraphs()) {
                outOfBounds |= this.moveGraph(subGraph, valX, valY);
            }
        } else if (copy instanceof AlgaPoints) {
            AlgaPoints pts = (AlgaPoints)copy;
            ArrayList<Pt> listPts = pts.getPoints();
            for (Pt pt : listPts) {
                outOfBounds |= this.updateXY(pt, valX, valY);
            }
        } else if (copy instanceof AlgaDraw) {
            outOfBounds |= this.updateXY(copy, valX, valY);
        }
        copy.computeControlPoints();
        return outOfBounds;
    }

    private boolean updateXY(AlgaGraph copy, int valX, int valY) {
        int newX = copy.getX() + valX;
        int newY = copy.getY() + valY;
        copy.setX(newX);
        copy.setY(newY);
        return newX < 75 || newY < 75;
    }

    private boolean updateXY(Pt pt, int valX, int valY) {
        int newX = pt.getX() + valX;
        int newY = pt.getY() + valY;
        pt.setX(newX);
        pt.setY(newY);
        return newX < 75 || newY < 75;
    }

    private void computeLinksFromGraphs(Collection<AlgaNode> graphs) {
        this._links = new HashSet<AlgaLink>();
        this._linksToDelete = new HashSet<AlgaLink>();
        HashSet allLinks = new HashSet();
        for (AlgaSheet sheet : this.getContent().getSheets()) {
            allLinks.addAll(sheet.getGraphs().stream().filter(e -> e instanceof AlgaLink).map(e -> (AlgaLink)e).collect(Collectors.toList()));
        }
        for (AlgaLink link : allLinks) {
            AlgaNode toGNode;
            AltaLink tLink = link.getLogical();
            AltaSub fromSub = tLink.getFromSub();
            AltaSub toSub = tLink.getToSub();
            AlgaNode fromGNode = fromSub == null ? this.getNode().getGraphic(tLink.getFromFlow()) : fromSub.getGraphic();
            AlgaWithPorts algaWithPorts = toGNode = toSub == null ? this.getNode().getGraphic(tLink.getToFlow()) : toSub.getGraphic();
            if (graphs.contains(fromGNode) && graphs.contains(toGNode)) {
                this._links.add(link);
                continue;
            }
            if (!graphs.contains(fromGNode) && !graphs.contains(toGNode)) continue;
            this._linksToDelete.add(link);
        }
    }

    private Collection<AlgaGraph> getForms(Collection<AlgaGraph> graphs) {
        return graphs.stream().filter(e -> e instanceof AlgaGroup || e instanceof AlgaForm || e instanceof AlgaLine || e instanceof AlgaPolygone).collect(Collectors.toList());
    }

    private int[] computeBounds(Collection<AlgaGraph> graphSelectedFromSrc) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (AlgaGraph grf : graphSelectedFromSrc) {
            if (grf instanceof AlgaPort) continue;
            Rectangle r = grf.getSelectBounds();
            minX = (int)Math.min(r.getMinX(), (double)minX);
            minY = (int)Math.min(r.getMinY(), (double)minY);
            maxX = (int)Math.max(r.getMaxX(), (double)maxX);
            maxY = (int)Math.max(r.getMaxY(), (double)maxY);
        }
        return new int[]{minX, minY, maxX, maxY};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EquipmentDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (_dbFTChooser == null) {
            EquipmentDlgChooser dlg = null;
            Object object = _LockerDlgChooser;
            synchronized (object) {
                if (_dbFTChooser == null) {
                    dlg = new EquipmentDlgChooser(win, appl);
                    dlg.getPanelSelect().resetCache();
                }
                if (_dbFTChooser == null) {
                    _dbFTChooser = dlg;
                }
            }
        }
        _dbFTChooser.setLocationRelativeTo(win);
        return _dbFTChooser;
    }

    private AltaSub getSubSrc(CopyUtility.Default utility, AltaSub newSub) {
        for (Map.Entry entry : utility.entrySet()) {
            if (!(entry.getKey() instanceof AltaSub) || entry.getValue() != newSub) continue;
            return (AltaSub)entry.getKey();
        }
        return null;
    }

    private Map<AltaSub, Set<AltaFlow>> getFlowsToCreate(Map<AltaSub, AltaSub> oldSubToNewSub) {
        LinkedHashMap<AltaSub, Set<AltaFlow>> flowsToCreate = new LinkedHashMap<AltaSub, Set<AltaFlow>>();
        List subs = this._nodes.stream().map(AlgaNode::getLogical).collect(Collectors.toList());
        for (AltaSub sub : subs) {
            flowsToCreate.put(oldSubToNewSub.get(sub), new HashSet());
        }
        for (AlgaLink link : this._linksToDelete) {
            AltaLink tLink = link.getLogical();
            AltaSub fromSub = tLink.getFromSub();
            AltaFlow fromFlow = tLink.getFromFlow();
            if (subs.contains(fromSub) && fromFlow.getOrientation() != AltaFlow.Orientation.LOCAL) {
                ((Set)flowsToCreate.get(oldSubToNewSub.get(fromSub))).add(fromFlow);
            }
            AltaSub toSub = tLink.getToSub();
            AltaFlow toFlow = tLink.getToFlow();
            if (!subs.contains(toSub) || toFlow.getOrientation() == AltaFlow.Orientation.LOCAL) continue;
            ((Set)flowsToCreate.get(oldSubToNewSub.get(toSub))).add(toFlow);
        }
        for (AltaSub sub : subs) {
            Set<AltaFlow> flows = new HashSet<AltaFlow>(sub.getNode().getFlows());
            flows = flows.stream().filter(e -> e.getOrientation() != AltaFlow.Orientation.LOCAL).collect(Collectors.toSet());
            for (AlgaLink link : this._links) {
                AltaLink tLink = link.getLogical();
                if (tLink.getToSub() == sub) {
                    flows.remove(tLink.getToFlow());
                }
                if (tLink.getFromSub() != sub) continue;
                flows.remove(tLink.getFromFlow());
            }
            ((Set)flowsToCreate.get(oldSubToNewSub.get(sub))).addAll(flows);
        }
        return flowsToCreate;
    }

    public static class EquipmentDlgChooser
    extends DBWrapSaveAsDlg {
        public EquipmentDlgChooser(Window owner, PlugableAppl appl) {
            super(owner, appl, DBFolder.Family.EQUIPMENT, false);
            this.setTitle(ResMsgOcas.getString("CMD_CREATE_EQP_TITLE_DLG"));
            this.setIconImage(ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_").getImage());
            this.make(owner);
        }

        @Override
        protected DBFolderPanelSelect createPanelSelect() {
            return new DBFolderPanelSelectFilterFlags(this._application, DBFolder.Family.EQUIPMENT){

                @Override
                protected DBFolderTreeModel createTreeModel(PlugableAppl appl, DBFolder.Family dbFamily) {
                    DAOFactory daoFactory = appl.getDAOFactory();
                    return new DBFolderTreeModel(daoFactory.createFolderDAO(), daoFactory.createUserDAO(), appl.getDBUser(), DBFolder.Family.EQUIPMENT, "Select-Equipment"){

                        @Override
                        public boolean acceptFolder(DBFolder dbFolder) {
                            return this.selectFolder(dbFolder);
                        }
                    };
                }
            };
        }
    }

    private static class PortToSub {
        private AlgaPort _port;
        private AltaSub _sub;
        private AltaFlow _flow;

        public PortToSub(AlgaPort port, AltaSub sub, AltaFlow flow) {
            this._port = port;
            this._sub = sub;
            this._flow = flow;
        }

        public AltaFlow getFlow() {
            return this._flow;
        }

        public AlgaPort getPort() {
            return this._port;
        }

        public AltaSub getSub() {
            return this._sub;
        }
    }
}

