/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class OCmdDelete
extends OCCmd {
    List<AlgaSheetTransform> _sheetsTransfom = new ArrayList<AlgaSheetTransform>(8);
    List<AltaLink> _linksToBeUpdateLogs = new ArrayList<AltaLink>(10);
    protected static final int FLAG_LOCKED_VIRTUAL = 4;

    public OCmdDelete(CeciliaAppl appl, AltaContentEditPanel c) {
        super(appl, c);
    }

    @Override
    protected boolean prepareDo() {
        AlgaSheet sheet;
        int i;
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (i = sheets.size() - 1; i >= 0; --i) {
            sheet = sheets.get(i);
            for (AlgaGraph graph : sheet.getGraphs()) {
                graph.setFlag(0);
            }
        }
        for (i = sheets.size() - 1; i >= 0; --i) {
            sheet = sheets.get(i);
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (graph instanceof AlgaPort) {
                    this.preparePort((AlgaPort)graph);
                    continue;
                }
                if (!graph.isLocked()) continue;
                graph.setFlag(4);
                if (!(graph instanceof AlgaLink)) continue;
                AltaLink link = ((AlgaLink)graph).getLogical();
                link.getFromGraphic().setFlag(4);
                link.getToGraphic().setFlag(4);
            }
        }
        boolean selectDirectLocked = false;
        boolean selectIndirectLocked = false;
        boolean selectIndirectInvisible = false;
        for (int i2 = sheets.size() - 1; i2 >= 0; --i2) {
            AlgaSheet sheet2 = sheets.get(i2);
            AlgaSheetTransform transform = null;
            for (AlgaGraph graph : sheet2.getGraphs()) {
                AlgaWithPorts port;
                if (this.isSelectedGraph(graph)) {
                    if (graph instanceof AlgaLink) {
                        this._linksToBeUpdateLogs.add(((AlgaLink)graph).getLogical());
                    }
                    if (this.isLockedGraph(graph)) {
                        selectDirectLocked = true;
                        continue;
                    }
                    if ((graph.getFlag() & 4) != 0) {
                        selectIndirectLocked = true;
                        continue;
                    }
                    if (transform == null) {
                        transform = this.createTransform(sheet2);
                    }
                    transform.addGraph(graph);
                    continue;
                }
                if (!(graph instanceof AlgaLink)) continue;
                AltaLink link = ((AlgaLink)graph).getLogical();
                boolean added = false;
                if (!added && this.isSelectedGraph(port = link.getFromGraphic()) && (port.getFlag() & 4) == 0) {
                    if (transform == null) {
                        transform = this.createTransform(sheet2);
                        if (!sheet2.isVisible()) {
                            selectIndirectInvisible = true;
                        }
                    }
                    transform.addGraph(graph);
                    added = true;
                }
                if (added || !this.isSelectedGraph(port = link.getToGraphic()) || (port.getFlag() & 4) != 0) continue;
                if (transform == null) {
                    transform = this.createTransform(sheet2);
                    if (!sheet2.isVisible()) {
                        selectIndirectInvisible = true;
                    }
                }
                transform.addGraph(graph);
                added = true;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (selectDirectLocked) {
            sb.append(ResMsgOcas.getString("MSG_ERR_DELETE_OBJECT_LOCKED"));
        }
        if (selectIndirectLocked) {
            if (sb.length() > 0) {
                sb.append("<BR>");
            }
            sb.append(ResMsgOcas.getString("MSG_ERR_DELETE_OBJECT_LOCKED_INDIRECT"));
        }
        if (selectIndirectInvisible) {
            if (sb.length() > 0) {
                sb.append("<BR>");
            }
            sb.append(ResMsgOcas.getString("MSG_ERR_DELETE_OBJECT_INVISIBLE"));
        }
        if (sb.length() > 0) {
            sb.insert(0, "<html>");
            if (this._sheetsTransfom.size() == 0) {
                sb.append("</html>");
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), sb.toString(), UIManager.getString("OptionPane.titleText"), 0);
                return false;
            }
            sb.append("<BR>");
            sb.append(ResMsgOcas.getString("MSG_QST_DELETE_CONFIRM"));
            sb.append("</html>");
            int result = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), sb.toString(), UIManager.getString("OptionPane.titleText"), 0);
            if (result != 0) {
                return false;
            }
        }
        return this._sheetsTransfom.size() > 0;
    }

    protected void preparePort(AlgaPort graph) {
        graph.setFlag(4);
    }

    protected boolean isSelectedGraph(AlgaGraph graph) {
        return graph.isSelected();
    }

    protected boolean isLockedGraph(AlgaGraph graph) {
        return graph.isLocked() || graph instanceof AlgaPort;
    }

    public boolean willBeDeleted(AlgaGraph graph) {
        for (AlgaSheetTransform sheet : this._sheetsTransfom) {
            if (!sheet._graphs.contains(graph)) continue;
            return true;
        }
        return false;
    }

    private AlgaSheetTransform createTransform(AlgaSheet sheet) {
        AlgaSheetTransform result = new AlgaSheetTransform(sheet);
        this._sheetsTransfom.add(result);
        return result;
    }

    @Override
    protected void firstDo() {
        if (this._sheetsTransfom.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void redo() {
        for (int i = this._sheetsTransfom.size() - 1; i >= 0; --i) {
            this._sheetsTransfom.get(i).redoGraphics();
        }
        boolean withNode = false;
        for (int i = this._sheetsTransfom.size() - 1; i >= 0; --i) {
            AlgaSheetTransform sheetTransform = this._sheetsTransfom.get(i);
            sheetTransform.redoLogics(this.getNode());
            if (sheetTransform._nodes.isEmpty()) continue;
            withNode = true;
        }
        this.getNode().updateLinksLogs(this.getAppl().getDBUser().getLogin(), this._linksToBeUpdateLogs);
        this.refreshAll();
        if (withNode) {
            this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
            this.getNode().setChangeInternalStructure(true);
        }
    }

    @Override
    public void undo() {
        int i;
        boolean withNode = false;
        for (i = 0; i < this._sheetsTransfom.size(); ++i) {
            AlgaSheetTransform sheetTransform = this._sheetsTransfom.get(i);
            sheetTransform.undoLogics(this.getNode());
            if (sheetTransform._nodes.isEmpty()) continue;
            withNode = true;
        }
        for (i = 0; i < this._sheetsTransfom.size(); ++i) {
            this._sheetsTransfom.get(i).undoGraphics();
        }
        this.getNode().updateLinksLogs(this.getAppl().getDBUser().getLogin(), this._linksToBeUpdateLogs);
        this.refreshAll();
        if (withNode) {
            this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
            this.getNode().setChangeInternalStructure(true);
        }
    }

    class AlgaSheetTransform {
        AlgaSheet _sheet;
        List<AlgaLink> _links;
        List<AlgaNode> _nodes;
        List<AlgaGraph> _graphs;
        List<Integer> _graphsIndexes;

        public AlgaSheetTransform(AlgaSheet sheet) {
            this._sheet = sheet;
            int nbrGraph = this._sheet.getGraphs().size();
            if (nbrGraph < 16) {
                nbrGraph = 16;
            }
            this._graphs = new ArrayList<AlgaGraph>(nbrGraph);
            this._links = new ArrayList<AlgaLink>(nbrGraph * 2 / 3);
            this._nodes = new ArrayList<AlgaNode>(nbrGraph / 2);
        }

        public void addGraph(AlgaGraph graph) {
            this._graphs.add(graph);
            if (graph instanceof AlgaLink) {
                this._links.add((AlgaLink)graph);
            }
            if (graph instanceof AlgaNode) {
                this._nodes.add((AlgaNode)graph);
            }
        }

        public void redoGraphics() {
            if (this._graphs.isEmpty()) {
                return;
            }
            this._graphsIndexes = new ArrayList<Integer>(this._graphs.size() + 1);
            for (int i = 0; i < this._graphs.size(); ++i) {
                int index = this._sheet.remove(this._graphs.get(i));
                this._graphsIndexes.add(index);
            }
        }

        public void undoGraphics() {
            if (this._graphs.isEmpty()) {
                return;
            }
            for (int i = this._graphs.size() - 1; i >= 0; --i) {
                this._sheet.add(this._graphs.get(i), this._graphsIndexes.get(i));
            }
        }

        public void redoLogics(AltaEquipment equip) {
            int i;
            for (i = this._links.size() - 1; i >= 0; --i) {
                equip.delLink(this._links.get(i).getLogical());
            }
            for (i = this._nodes.size() - 1; i >= 0; --i) {
                equip.delSub(this._nodes.get(i).getLogical());
            }
        }

        public void undoLogics(AltaEquipment equip) {
            int i;
            for (i = this._nodes.size() - 1; i >= 0; --i) {
                equip.addSub(this._nodes.get(i).getLogical());
            }
            for (i = this._links.size() - 1; i >= 0; --i) {
                equip.addLink(this._links.get(i).getLogical());
            }
        }
    }
}

