/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.List;

public abstract class OCmdGraphMove
extends OCCmd {
    protected List<Pt> _oldLocations;
    protected List<AlgaGraph> _graphs;
    protected Move _align;

    public OCmdGraphMove(CeciliaAppl appl, AltaContentEditPanel c, Move align) {
        super(appl, c);
        this._align = align;
        this._graphs = new ArrayList<AlgaGraph>(32);
        this._oldLocations = new ArrayList<Pt>(32);
    }

    protected List<AlgaSheet> getSheets() {
        return this.getContent().getSheets();
    }

    @Override
    protected void firstDo() {
        if (this._graphs.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    protected abstract void actionDo();

    @Override
    public final void undo() {
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaGraph graph = this._graphs.get(i);
            Pt pt = this._oldLocations.get(i);
            this.moveGraphToNewPos(Move.HORIZONTAL, pt.getX(), graph);
            this.moveGraphToNewPos(Move.VERTICAL, pt.getY(), graph);
            graph.computeControlPoints();
        }
        this.refreshAll();
    }

    protected final void updateOldLocations() {
        for (AlgaGraph graph : this._graphs) {
            this._oldLocations.add(new Pt(graph.getX(), graph.getY()));
        }
    }

    protected final void moveGraphToNewPos(Move move, int coord, AlgaGraph graph) {
        if (move == Move.HORIZONTAL) {
            if (graph instanceof AlgaPoints) {
                graph.translate(coord - (int)graph.getSelectBounds().getX(), 0);
            } else {
                graph.setX(coord);
            }
        } else if (graph instanceof AlgaPoints) {
            graph.translate(0, coord - (int)graph.getSelectBounds().getY());
        } else {
            graph.setY(coord);
        }
        graph.computeControlPoints();
    }

    public static enum Move {
        LEFT,
        VERTICAL,
        RIGHT,
        TOP,
        HORIZONTAL,
        BOTTOM,
        CENTER;

    }
}

