/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import java.util.ArrayList;
import java.util.List;

public class OCmdGroupAssociate
extends OCCmd {
    AlgaGroup _group;
    AlgaSheet _currentSheet;
    List<AlgaSheetTransform> _sheetsTransfom = new ArrayList<AlgaSheetTransform>();

    public OCmdGroupAssociate(AltaContentEditPanel c) {
        super(c.getAppl(), c);
    }

    @Override
    protected boolean prepareDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        this._currentSheet = this.getContent().getCurrentSheet();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            AlgaSheetTransform transform = null;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || graph.isLocked() || !graph.isVisio()) continue;
                if (transform == null) {
                    transform = this.createTransform(sheet);
                }
                transform.addGraph(graph);
            }
        }
        if (this._sheetsTransfom.size() == 0) {
            return false;
        }
        this._group = new AlgaGroup();
        ArrayList<AlgaGraph> subgrfs = new ArrayList<AlgaGraph>(16);
        for (int i = 0; i < this._sheetsTransfom.size(); ++i) {
            subgrfs.addAll(this._sheetsTransfom.get(i).getGraphs());
        }
        this._group.setGraphs(subgrfs);
        this._group.setSelected(true);
        this._group.computeControlPoints();
        return true;
    }

    private AlgaSheetTransform createTransform(AlgaSheet sheet) {
        AlgaSheetTransform result = new AlgaSheetTransform(sheet);
        this._sheetsTransfom.add(result);
        return result;
    }

    @Override
    protected void firstDo() {
        if (this._sheetsTransfom.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void redo() {
        for (int i = this._sheetsTransfom.size() - 1; i >= 0; --i) {
            this._sheetsTransfom.get(i).redo();
        }
        this._currentSheet.add(this._group, Integer.MAX_VALUE);
        for (AlgaGraph grf : this._group.getGraphs()) {
            grf.setSelected(false);
        }
        this.refreshAll();
    }

    @Override
    public void undo() {
        this._currentSheet.remove(this._group);
        for (AlgaGraph grf : this._group.getGraphs()) {
            grf.setSelected(true);
        }
        for (int i = 0; i < this._sheetsTransfom.size(); ++i) {
            this._sheetsTransfom.get(i).undo();
        }
        this.refreshAll();
    }

    class AlgaSheetTransform {
        AlgaSheet _sheet;
        List<AlgaGraph> _graphs;
        List<Integer> _graphsIndexes;

        public AlgaSheetTransform(AlgaSheet sheet) {
            this._sheet = sheet;
            int nbrGraph = this._sheet.getGraphs().size();
            if (nbrGraph < 16) {
                nbrGraph = 16;
            }
            this._graphs = new ArrayList<AlgaGraph>(nbrGraph);
        }

        public void addGraph(AlgaGraph graph) {
            this._graphs.add(graph);
        }

        public List<AlgaGraph> getGraphs() {
            return this._graphs;
        }

        public void redo() {
            if (this._graphs.isEmpty()) {
                return;
            }
            this._graphsIndexes = new ArrayList<Integer>(this._graphs.size() + 1);
            for (int i = 0; i < this._graphs.size(); ++i) {
                int index = this._sheet.remove(this._graphs.get(i));
                this._graphsIndexes.add(index);
            }
        }

        public void undo() {
            if (this._graphs.isEmpty()) {
                return;
            }
            for (int i = this._graphs.size() - 1; i >= 0; --i) {
                this._sheet.add(this._graphs.get(i), this._graphsIndexes.get(i));
            }
        }
    }
}

