/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.List;

public class OCmdLinkArrow
extends OCCmd {
    boolean _arrow;
    List<AlgaLink> _graphs;

    public OCmdLinkArrow(CeciliaAppl appl, AltaContentEditPanel c, boolean arrow) {
        super(appl, c);
        this._arrow = arrow;
        this._graphs = new ArrayList<AlgaLink>(32);
    }

    @Override
    protected void firstDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                AlgaLink link;
                if (!graph.isSelected() || graph.isLocked() || !(graph instanceof AlgaLink) || (link = (AlgaLink)graph).isDrawArrow() == this._arrow) continue;
                this._graphs.add(link);
            }
        }
        if (this._graphs.size() > 0) {
            this.undo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void undo() {
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaLink graph;
            graph.setDrawArrow(!(graph = this._graphs.get(i)).isDrawArrow());
        }
        this.refreshAll();
    }

    @Override
    public void redo() {
        this.undo();
    }
}

