/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.List;

public class OCmdNodeText
extends OCCmd {
    NamePosition _position;
    List<AlgaWithPorts> _graphs;
    List<NamePosition> _oldPositions;

    public OCmdNodeText(CeciliaAppl appl, AltaContentEditPanel c, NamePosition position) {
        super(appl, c);
        this._position = position;
        this._graphs = new ArrayList<AlgaWithPorts>(32);
        this._oldPositions = new ArrayList<NamePosition>(32);
    }

    @Override
    protected void firstDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            if (!sheet.isVisible()) continue;
            for (AlgaGraph graph : sheet.getGraphs()) {
                if (!graph.isSelected() || graph.isLocked() || !(graph instanceof AlgaWithPorts)) continue;
                AlgaWithPorts grfPorts = (AlgaWithPorts)graph;
                this._graphs.add(grfPorts);
                this._oldPositions.add(grfPorts.getNamePosition());
            }
        }
        if (this._graphs.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    @Override
    public void redo() {
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaWithPorts graph = this._graphs.get(i);
            graph.setNamePosition(this._position);
            graph.computeControlPoints();
        }
        this.refreshAll();
    }

    @Override
    public void undo() {
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaWithPorts graph = this._graphs.get(i);
            NamePosition oldPosition = this._oldPositions.get(i);
            graph.setNamePosition(oldPosition);
            graph.computeControlPoints();
        }
        this.refreshAll();
    }
}

