/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import java.util.ArrayList;
import java.util.Iterator;

public class OCmdPathMovePoint
extends OCCmd {
    AlgaPoints _graphic;
    ArrayList<MovePt> _points;

    public OCmdPathMovePoint(AltaContentEditPanel c, AlgaPoints graphic) {
        super(c.getAppl(), c);
        this._graphic = graphic;
        this._points = new ArrayList();
    }

    public void addMovePoint(double x, double y, int index) {
        this._points.add(new MovePt(x, y, index));
    }

    public void addMoveDeltaPoint(double dx, double dy, int index) {
        this._points.add(new MovePt(dx, dy, index).setDelta(true));
    }

    public void addMovePoint(double x, double y, Pt pt) {
        this._points.add(new MovePt(x, y, pt));
    }

    public void addMoveDeltaPoint(double dx, double dy, Pt pt) {
        this._points.add(new MovePt(dx, dy, pt).setDelta(true));
    }

    @Override
    protected boolean prepareDo() {
        if (this._points.isEmpty()) {
            return false;
        }
        return super.prepareDo();
    }

    @Override
    protected void firstDo() {
        this.redo();
    }

    @Override
    public void redo() {
        for (int i = this._points.size() - 1; i >= 0; --i) {
            this._points.get(i).redo();
        }
        this._graphic.computeControlPoints();
        this.refreshAll();
    }

    @Override
    public void undo() {
        for (int i = this._points.size() - 1; i >= 0; --i) {
            this._points.get(i).undo();
        }
        this._graphic.computeControlPoints();
        this.refreshAll();
    }

    class MovePt {
        int _index;
        int _newX;
        int _newY;
        int _oldX;
        int _oldY;
        Pt _point;

        MovePt(double x, double y, int index) {
            this._newX = (int)x;
            this._newY = (int)y;
            this._index = index;
            Iterator<Pt> iterPt = OCmdPathMovePoint.this._graphic.iteratePoint();
            while (0 < index--) {
                iterPt.next();
            }
            this._point = iterPt.next();
            this._oldX = this._point.getX();
            this._oldY = this._point.getY();
        }

        MovePt(double x, double y, Pt pt) {
            this._newX = (int)x;
            this._newY = (int)y;
            this._index = -1;
            this._point = pt;
            this._oldX = this._point.getX();
            this._oldY = this._point.getY();
        }

        public void redo() {
            this._point.setX(this._newX).setY(this._newY);
        }

        public void undo() {
            this._point.setX(this._oldX).setY(this._oldY);
        }

        public MovePt setDelta(boolean isDelta) {
            if (isDelta) {
                this._newX = this._oldX + this._newX;
                this._newY = this._oldY + this._newY;
            }
            return this;
        }
    }
}

