/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.ComponentDlgChooser;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.CopyUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class OCmdReplace
extends OCCmd {
    static CopyUtility _directCopy = new CopyUtility(){

        public Object getRef(Object src) {
            return src;
        }

        public void setRef(Object src, Object ref) {
            throw new UnsupportedOperationException();
        }

        public boolean selectForCopy(Object src) {
            return true;
        }

        public boolean copyInternalID(Object src) {
            return true;
        }
    };
    List<ItemNode> _nodes = new ArrayList<ItemNode>();
    AltaComponent _selectComponent;
    IdentityHashMap<AltaLink, AlgaLink> _mapLinkLog2Grf = new IdentityHashMap();
    IdentityHashMap<AlgaGraph, AlgaSheet> _mapGrf2Sheet = new IdentityHashMap();
    List<AlgaGraph> _redoComputeCtrlPoints = new ArrayList<AlgaGraph>();
    List<AlgaGraph> _undoComputeCtrlPoints = new ArrayList<AlgaGraph>();
    List<AltaLink> _redoRefreshLinks = new ArrayList<AltaLink>();
    List<AltaLink> _undoRefreshLinks = new ArrayList<AltaLink>();
    private static ComponentDlgChooser __dlgChooser = null;

    public OCmdReplace(CeciliaAppl appl, AltaContentEditPanel c) {
        super(appl, c);
    }

    private static synchronized ComponentDlgChooser getDlgChooser(JComponent c, CAppl appl) {
        if (__dlgChooser == null) {
            __dlgChooser = new ComponentDlgChooser(SwingUtilities.getWindowAncestor(c), appl);
        }
        return __dlgChooser;
    }

    @Override
    protected boolean prepareDo() {
        ArrayList<AlgaNode> selectNodes = new ArrayList<AlgaNode>();
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            for (AlgaGraph graph : sheet.getGraphs()) {
                this._mapGrf2Sheet.put(graph, sheet);
                if (graph instanceof AlgaLink) {
                    AlgaLink link = (AlgaLink)graph;
                    this._mapLinkLog2Grf.put(link.getLogical(), link);
                }
                if (!graph.isSelected() || graph.isLocked() || !(graph instanceof AlgaNode)) continue;
                selectNodes.add((AlgaNode)graph);
            }
        }
        if (selectNodes.isEmpty()) {
            return false;
        }
        AltaComponent firstComponent = ((AlgaNode)selectNodes.get(0)).getLogical().getNode();
        ComponentDlgChooser dlg = OCmdReplace.getDlgChooser(this.getPanel(), this.getAppl());
        dlg.setSelectFolder(firstComponent.getDBFolder());
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return false;
        }
        DBFolder dbFolder = dlg.getSelectFolder();
        if (dbFolder == null) {
            return false;
        }
        DBWrap dbWrap = this.getAppl().getDAOFactory().findOrCreateWrap(dbFolder);
        if (dbWrap == null || !(dbWrap instanceof AltaComponent)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getPanel()), ResMsgOcas.msgFormat("MSG_RAW_COMPONENT_READ", dbFolder.getRefPath()));
            return false;
        }
        this._selectComponent = (AltaComponent)dbWrap;
        for (int i = 0; i < selectNodes.size(); ++i) {
            AlgaNode grf = (AlgaNode)selectNodes.get(i);
            if (grf.getLogical().getNode().equals(this._selectComponent)) continue;
            this._nodes.add(new ItemNode(grf, this.getNode()));
        }
        return !this._nodes.isEmpty();
    }

    @Override
    protected void firstDo() {
        int i;
        for (i = 0; i < this._nodes.size(); ++i) {
            this._nodes.get(i).prepareDo(this._selectComponent);
            this._nodes.get(i).redo();
        }
        for (i = this._redoComputeCtrlPoints.size() - 1; i >= 0; --i) {
            this._redoComputeCtrlPoints.get(i).computeControlPoints();
        }
        this.getNode().updateLinksLogs(this.getAppl().getDBUser().getLogin(), this._redoRefreshLinks);
        this.refreshAll();
        this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
        this.getNode().setChangeInternalStructure(true);
        this.getPanel().addHisto(this);
    }

    @Override
    public void redo() {
        int i;
        for (i = 0; i < this._nodes.size(); ++i) {
            this._nodes.get(i).redo();
        }
        for (i = this._redoComputeCtrlPoints.size() - 1; i >= 0; --i) {
            this._redoComputeCtrlPoints.get(i).computeControlPoints();
        }
        this.getNode().updateLinksLogs(this.getAppl().getDBUser().getLogin(), this._redoRefreshLinks);
        this.refreshAll();
        this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
        this.getNode().setChangeInternalStructure(true);
    }

    @Override
    public void undo() {
        int i;
        for (i = this._nodes.size() - 1; i >= 0; --i) {
            this._nodes.get(i).undo();
        }
        for (i = this._undoComputeCtrlPoints.size() - 1; i >= 0; --i) {
            this._undoComputeCtrlPoints.get(i).computeControlPoints();
        }
        this.getNode().updateLinksLogs(this.getAppl().getDBUser().getLogin(), this._undoRefreshLinks);
        this.refreshAll();
        this.getNode().updateDependTimeUpdt(this.getAppl().getDAOFactory(), this.getNode().getWorkingRelations());
        this.getNode().setChangeInternalStructure(true);
    }

    class ItemNode {
        AltaEquipment _owner;
        AltaSub _oldSub;
        AltaSub _newSub;
        AlgaNode _oldNode;
        AlgaNode _newNode;
        AlgaSheet _sheet;
        int _idxInSheet;
        List<ItemLink> _links;

        public ItemNode(AlgaNode oldNode, AltaEquipment owner) {
            if (oldNode == null) {
                throw new NullPointerException();
            }
            if (owner == null) {
                throw new NullPointerException();
            }
            this._owner = owner;
            this._oldNode = oldNode;
            this._oldSub = oldNode.getLogical();
            this._sheet = OCmdReplace.this._mapGrf2Sheet.remove(oldNode);
            if (this._sheet == null) {
                throw new NullPointerException();
            }
            this._links = new ArrayList<ItemLink>();
        }

        public void prepareDo(AltaComponent changeComponent) {
            this._newSub = new AltaSub(changeComponent, this._oldSub.getName());
            this._newNode = this._oldNode.getCopy(true, _directCopy);
            this._newNode.setLogical(this._newSub);
            OCmdReplace.this._redoComputeCtrlPoints.add(this._newNode);
            OCmdReplace.this._undoComputeCtrlPoints.add(this._oldNode);
            for (AltaLink oldLogLink : this._owner.getLinks()) {
                if (oldLogLink.getFromSub() != this._oldSub && oldLogLink.getToSub() != this._oldSub) continue;
                AlgaLink oldGrfLink = OCmdReplace.this._mapLinkLog2Grf.remove(oldLogLink);
                ItemLink doItemLink = new ItemLink(oldGrfLink, this._owner, OCmdReplace.this._mapGrf2Sheet.remove(oldGrfLink));
                this._links.add(doItemLink);
                OCmdReplace.this._undoComputeCtrlPoints.add(oldGrfLink);
                OCmdReplace.this._undoRefreshLinks.add(oldLogLink);
                AltaFlow oldFlow = oldLogLink.getFromSub() == this._oldSub ? oldLogLink.getFromFlow() : oldLogLink.getToFlow();
                AltaFlow newFlow = changeComponent.getFlow(oldFlow.getName());
                if (newFlow == null || newFlow.getOrientation() != oldFlow.getOrientation()) continue;
                AltaLink newLogLink = oldLogLink.getCopy(_directCopy);
                if (oldLogLink.getFromSub() == this._oldSub) {
                    newLogLink.setFrom(this._newSub, newFlow, oldLogLink.getFromField());
                } else {
                    newLogLink.setTo(this._newSub, newFlow, oldLogLink.getToField());
                }
                doItemLink.prepareDo(newLogLink);
                OCmdReplace.this._mapLinkLog2Grf.put(newLogLink, doItemLink._newGrf);
                OCmdReplace.this._mapGrf2Sheet.put(doItemLink._newGrf, doItemLink._sheet);
                OCmdReplace.this._redoComputeCtrlPoints.add(doItemLink._newGrf);
                OCmdReplace.this._redoRefreshLinks.add(newLogLink);
            }
        }

        public void redo() {
            this._idxInSheet = this._sheet.remove(this._oldNode);
            this._owner.delSub(this._oldSub);
            this._owner.addSub(this._newSub);
            this._sheet.add(this._newNode, this._idxInSheet);
            for (int i = 0; i < this._links.size(); ++i) {
                this._links.get(i).redo();
            }
        }

        public void undo() {
            for (int i = this._links.size() - 1; i >= 0; --i) {
                this._links.get(i).undo();
            }
            this._sheet.remove(this._newNode);
            this._owner.delSub(this._newSub);
            this._owner.addSub(this._oldSub);
            this._oldNode.setLogical(this._oldSub);
            this._sheet.add(this._oldNode, this._idxInSheet);
        }

        public AltaSub getOldSub() {
            return this._oldSub;
        }
    }

    public static class ItemLink {
        AltaEquipment _owner;
        AltaLink _oldLog;
        AltaLink _newLog;
        AlgaLink _oldGrf;
        AlgaLink _newGrf;
        AlgaSheet _sheet;
        int _idxInSheet;

        public ItemLink(AlgaLink oldGrf, AltaEquipment owner, AlgaSheet sheet) {
            if (oldGrf == null) {
                throw new NullPointerException();
            }
            if (owner == null) {
                throw new NullPointerException();
            }
            if (sheet == null) {
                throw new NullPointerException();
            }
            this._owner = owner;
            this._oldGrf = oldGrf;
            this._oldLog = oldGrf.getLogical();
            this._sheet = sheet;
        }

        public void prepareDo(AltaLink newLog) {
            this._newLog = newLog;
            this._newGrf = this._oldGrf.getCopy(false, _directCopy);
            this._newGrf.setLogical(newLog);
        }

        public void redo() {
            this._idxInSheet = this._sheet.remove(this._oldGrf);
            this._owner.delLink(this._oldLog);
            if (this._newLog != null && this._newGrf != null) {
                this._owner.addLink(this._newLog);
                this._sheet.add(this._newGrf, this._idxInSheet);
            }
        }

        public void undo() {
            if (this._newLog != null && this._newGrf != null) {
                this._sheet.remove(this._newGrf);
                this._owner.delLink(this._newLog);
            }
            this._owner.addLink(this._oldLog);
            this._oldGrf.setLogical(this._oldLog);
            this._sheet.add(this._oldGrf, this._idxInSheet);
        }
    }
}

