/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AlgaSheetsDlg;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class OCmdSheetsModify
extends OCCmd {
    public static final int DEFAULT_MAX_SHEETS_VIEW = 15;
    public static final String PROP_MAX_SHEETS_VIEW = "cecilia.mbsa.equipment.MaxSheetsView";
    AlgaSheetsDlg _sheetDlg;
    boolean _readOnly;
    List<AlgaSheet> _undoSheets;
    List<AlgaSheet> _redoSheets;

    public OCmdSheetsModify(CeciliaAppl appl, AltaContentPanel c, AlgaSheetsDlg dlg, boolean readOnly) {
        super(appl, c);
        this._sheetDlg = dlg;
        this._readOnly = readOnly;
    }

    @Override
    protected boolean prepareDo() {
        boolean firstDisplay = this._sheetDlg.getSheets().isEmpty();
        this._undoSheets = this.getContent().getSheets();
        this._sheetDlg.setSheets(this._undoSheets, this._readOnly);
        if (firstDisplay) {
            int nbSheets = this._undoSheets.size();
            int rowHeight = this._sheetDlg.getTable().getRowHeight();
            int max = Integer.getInteger(PROP_MAX_SHEETS_VIEW, 15);
            int dialogSize = 5 * rowHeight;
            if (nbSheets >= max) {
                dialogSize = max * rowHeight;
            } else if (nbSheets > 5) {
                dialogSize = nbSheets * rowHeight;
            }
            this._sheetDlg.getTable().setPreferredScrollableViewportSize(new Dimension(350, dialogSize));
            this._sheetDlg.pack();
        }
        this._sheetDlg.setVisible(true);
        if (!this._sheetDlg.getResult()) {
            return false;
        }
        this._redoSheets = this._sheetDlg.getSheets();
        return true;
    }

    @Override
    protected void firstDo() {
        if (this._readOnly) {
            AlgaContent current = this.getContent();
            ArrayList<AlgaSheet> currentSheets = new ArrayList<AlgaSheet>(this._undoSheets.size());
            AlgaGraph currentSheet = null;
            block0: for (AlgaSheet redoSheet : this._redoSheets) {
                for (AlgaSheet undoSheet : this._undoSheets) {
                    if (redoSheet.getNumber() != undoSheet.getNumber()) continue;
                    currentSheets.add(undoSheet);
                    undoSheet.setVisible(redoSheet.isVisible());
                    undoSheet.setSelected(false);
                    if (currentSheet != null || !redoSheet.isSelected() || !redoSheet.isVisible()) continue block0;
                    currentSheet = undoSheet;
                    continue block0;
                }
            }
            if (currentSheet != null) {
                currentSheet.setSelected(true);
            }
            current.setSheets(currentSheets);
            this.getNode().setModified(true);
            this.getView().repaint();
        } else {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    protected void setSheets(List<AlgaSheet> sheets) {
        this.getContent().setSheets(sheets);
        for (int i = 0; i < sheets.size(); ++i) {
            AlgaSheet sheet = sheets.get(i);
            for (AlgaGraph graph : sheet.getGraphs()) {
                graph.setParent(sheet);
            }
        }
    }

    @Override
    public void redo() {
        this.setSheets(this._redoSheets);
        this.getNode().setModified(true);
        this.getView().repaint();
    }

    @Override
    public void undo() {
        this.setSheets(this._undoSheets);
        this.getNode().setModified(true);
        this.getView().repaint();
    }
}

